/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.apache.commons.math3.exception.MaxCountExceededException;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractTrigArg1;
import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.SyntaxError;

public class Erf
extends AbstractTrigArg1
implements INumeric {
    @Override
    public IExpr e1DblArg(double arg1) {
        try {
            return Num.valueOf(org.apache.commons.math3.special.Erf.erf(arg1));
        }
        catch (MaxCountExceededException maxCountExceededException) {
            return null;
        }
    }

    @Override
    public IExpr evaluateArg1(IExpr arg1) {
        if (arg1.isZero()) {
            return F.C0;
        }
        if (arg1.equals(F.CInfinity)) {
            return F.C1;
        }
        if (arg1.equals(F.CNInfinity)) {
            return F.CN1;
        }
        IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
        if (negExpr != null) {
            return F.Times((IExpr)F.CN1, (IExpr)F.Erf(negExpr));
        }
        return null;
    }

    @Override
    public double evalReal(double[] stack, int top, int size) {
        if (size != 1) {
            throw new UnsupportedOperationException();
        }
        try {
            return org.apache.commons.math3.special.Erf.erf(stack[top]);
        }
        catch (MaxCountExceededException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(1152);
        super.setUp(symbol);
    }
}

