/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.StringX;
import org.matheclipse.core.generic.ITernaryComparator;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISymbol;

public class Equal
extends AbstractFunctionEvaluator
implements ITernaryComparator<IExpr> {
    private IExpr createComparatorResult(IAST lhsAST, IExpr rhs, ISymbol originalHead) {
        IAST lhsClone = lhsAST.removeAtClone(1);
        return F.binary(originalHead, lhsClone, rhs);
    }

    protected IExpr simplifyCompare(IExpr a1, IExpr a2, ISymbol originalHead) {
        IExpr rhs;
        IExpr lhs;
        if (a2.isNumber()) {
            lhs = a1;
            rhs = a2;
        } else if (a1.isNumber()) {
            lhs = a2;
            rhs = a1;
        } else {
            return null;
        }
        if (lhs.isAST()) {
            IAST lhsAST = (IAST)lhs;
            if (lhsAST.isTimes()) {
                if (lhsAST.arg1().isNumber()) {
                    INumber sn = (INumber)lhsAST.arg1();
                    rhs = F.eval(F.Divide(rhs, sn));
                    return this.createComparatorResult(lhsAST, rhs, originalHead);
                }
            } else if (lhsAST.isPlus() && lhsAST.arg1().isNumber()) {
                INumber sn = (INumber)lhsAST.arg1();
                rhs = F.eval(F.Subtract(rhs, sn));
                return this.createComparatorResult(lhsAST, rhs, originalHead);
            }
        }
        return null;
    }

    @Override
    public IExpr evaluate(IAST ast) {
        if (ast.size() > 1) {
            if (ast.size() == 3) {
                IExpr temp2;
                IExpr arg1 = ast.arg1();
                IExpr arg2 = ast.arg2();
                IExpr temp1 = F.evalExpandAll(arg1);
                IExpr difference = F.eval(F.Subtract(temp1, temp2 = F.evalExpandAll(arg2)));
                if (difference.isNumber()) {
                    if (difference.isZero()) {
                        return F.True;
                    }
                    return F.False;
                }
                if (difference.isConstant()) {
                    return F.False;
                }
                IExpr result = this.simplifyCompare(arg1, arg2, F.Equal);
                if (result != null) {
                    return result;
                }
            }
            ITernaryComparator.COMPARE_RESULT b = ITernaryComparator.COMPARE_RESULT.UNDEFINED;
            boolean evaled = false;
            IAST result = ast.clone();
            int i = 2;
            while (i < result.size()) {
                b = this.compare((IExpr)result.get(i - 1), (IExpr)result.get(i));
                if (b == ITernaryComparator.COMPARE_RESULT.FALSE) {
                    return F.False;
                }
                if (b == ITernaryComparator.COMPARE_RESULT.TRUE) {
                    evaled = true;
                    result.remove(i - 1);
                    continue;
                }
                ++i;
            }
            if (evaled) {
                if (result.size() == 2) {
                    return F.True;
                }
                return result;
            }
        }
        return null;
    }

    @Override
    public ITernaryComparator.COMPARE_RESULT compare(IExpr o0, IExpr o1) {
        if (o0.isSame(o1)) {
            return ITernaryComparator.COMPARE_RESULT.TRUE;
        }
        if (o0.isConstant() && o1.isConstant()) {
            return ITernaryComparator.COMPARE_RESULT.FALSE;
        }
        if (o0.isNumber() && o1.isNumber()) {
            return ITernaryComparator.COMPARE_RESULT.FALSE;
        }
        if (o0 instanceof StringX && o1 instanceof StringX) {
            if (o0.isSymbol() || o1.isSymbol()) {
                return ITernaryComparator.COMPARE_RESULT.UNDEFINED;
            }
            return ITernaryComparator.COMPARE_RESULT.TRUE;
        }
        return ITernaryComparator.COMPARE_RESULT.UNDEFINED;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(8);
    }
}

