/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;

public class Divisible
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 3);
        if (ast.arg1().isList()) {
            return ((IAST)ast.arg1()).mapAt(F.List(), ast, 1);
        }
        IExpr result = F.eval(F.Divide(ast.arg1(), ast.arg2()));
        if (result.isNumber()) {
            if (result.isComplex()) {
                IComplex comp = (IComplex)result;
                if (this.isSignedNumberDivisible(comp.getRe()) == F.True && this.isSignedNumberDivisible(comp.getIm()) == F.True) {
                    return F.True;
                }
                return F.False;
            }
            if (result.isSignedNumber()) {
                return this.isSignedNumberDivisible((ISignedNumber)result);
            }
            return F.False;
        }
        return null;
    }

    private IExpr isSignedNumberDivisible(ISignedNumber result) {
        if (result.isInteger()) {
            return F.True;
        }
        if (result.isNumIntValue()) {
            try {
                result.toLong();
                return F.True;
            }
            catch (ArithmeticException ae) {
                return null;
            }
        }
        return F.False;
    }
}

