/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.math.BigInteger;
import org.apache.commons.math3.complex.Complex;
import org.apfloat.Apcomplex;
import org.apfloat.ApcomplexMath;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatMath;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractTrigArg1;
import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.NumberUtil;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.rules.CscRules;
import org.matheclipse.parser.client.SyntaxError;

public class Csc
extends AbstractTrigArg1
implements INumeric,
CscRules {
    @Override
    public IAST getRuleAST() {
        return RULES;
    }

    @Override
    public IExpr evaluateArg1(IExpr arg1) {
        IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
        if (negExpr != null) {
            return F.Times((IExpr)F.CN1, (IExpr)F.Csc(negExpr));
        }
        IExpr imPart = AbstractFunctionEvaluator.getPureImaginaryPart(arg1);
        if (imPart != null) {
            return F.Times((IExpr)F.CNI, (IExpr)F.Csch(imPart));
        }
        IExpr[] parts = AbstractFunctionEvaluator.getPeriodicParts(arg1, F.Pi);
        if (parts != null) {
            if (parts[1].isInteger()) {
                IInteger i = (IInteger)parts[1];
                if (i.isEven()) {
                    return F.Csc(parts[0]);
                }
                return F.Times((IExpr)F.CN1, (IExpr)F.Csc(parts[0]));
            }
            if (parts[1].isFraction()) {
                IFraction f = (IFraction)parts[1];
                BigInteger[] divRem = f.divideAndRemainder();
                if (!NumberUtil.isZero(divRem[0])) {
                    IFraction rest = F.fraction(divRem[1], f.getBigDenominator());
                    if (NumberUtil.isEven(divRem[0])) {
                        return F.Csc(F.Plus(parts[0], (IExpr)F.Times((IExpr)rest, (IExpr)F.Pi)));
                    }
                    return F.Times((IExpr)F.CN1, (IExpr)F.Csc(F.Plus(parts[0], (IExpr)F.Times((IExpr)rest, (IExpr)F.Pi))));
                }
                if (f.equals(F.C1D2)) {
                    return F.Sec(F.Subtract(F.Divide(F.Pi, F.C2), arg1));
                }
            }
        }
        return null;
    }

    @Override
    public IExpr e1DblArg(double arg1) {
        return F.num(1.0 / Math.sin(arg1));
    }

    @Override
    public IExpr e1ComplexArg(Complex arg1) {
        return F.complexNum(arg1.sin().reciprocal());
    }

    @Override
    public IExpr e1ApfloatArg(Apfloat arg1) {
        return F.num(ApfloatMath.sin(arg1).inverse());
    }

    @Override
    public IExpr e1ApcomplexArg(Apcomplex arg1) {
        return F.complexNum(ApcomplexMath.sin(arg1).inverse());
    }

    @Override
    public double evalReal(double[] stack, int top, int size) {
        if (size != 1) {
            throw new UnsupportedOperationException();
        }
        return 1.0 / Math.sin(stack[top]);
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(1152);
        super.setUp(symbol);
    }
}

