/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.apache.commons.math3.complex.Complex;
import org.apfloat.Apcomplex;
import org.apfloat.ApcomplexMath;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatMath;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractTrigArg1;
import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.rules.CoshRules;
import org.matheclipse.parser.client.SyntaxError;

public class Cosh
extends AbstractTrigArg1
implements INumeric,
CoshRules {
    @Override
    public IAST getRuleAST() {
        return RULES;
    }

    @Override
    public IExpr evaluateArg1(IExpr arg1) {
        IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
        if (negExpr != null) {
            return F.Cosh(negExpr);
        }
        IExpr imPart = AbstractFunctionEvaluator.getPureImaginaryPart(arg1);
        if (imPart != null) {
            return F.Cos(imPart);
        }
        if (arg1.isZero()) {
            return F.C1;
        }
        return null;
    }

    @Override
    public IExpr e1DblArg(double arg1) {
        return F.num(Math.cosh(arg1));
    }

    @Override
    public IExpr e1ComplexArg(Complex arg1) {
        return F.complexNum(arg1.cosh());
    }

    @Override
    public IExpr e1ApfloatArg(Apfloat arg1) {
        return F.num(ApfloatMath.cosh(arg1));
    }

    @Override
    public IExpr e1ApcomplexArg(Apcomplex arg1) {
        return F.complexNum(ApcomplexMath.cosh(arg1));
    }

    @Override
    public double evalReal(double[] stack, int top, int size) {
        if (size != 1) {
            throw new UnsupportedOperationException();
        }
        return Math.cosh(stack[top]);
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(1152);
        super.setUp(symbol);
    }
}

