/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.VisitorExpr;

public class ComplexExpand
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 1, 2);
        IExpr arg1 = ast.arg1();
        return ComplexExpand.complexExpand(arg1);
    }

    private static IExpr complexExpand(IExpr arg1) {
        IExpr result = ComplexExpand.complexExpandNull(arg1);
        if (result != null) {
            return result;
        }
        return arg1;
    }

    private static IExpr complexExpandNull(IExpr arg1) {
        ComplexExpandVisitor tteVisitor = new ComplexExpandVisitor();
        return arg1.accept(tteVisitor);
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(128);
    }

    static class ComplexExpandVisitor
    extends VisitorExpr {
        @Override
        public IExpr visit2(IExpr head, IExpr arg1) {
            IExpr x = arg1;
            IExpr result = arg1.accept(this);
            if (result != null) {
                x = result;
            }
            IExpr reX = F.Re(x);
            IExpr imX = F.Im(x);
            if (x.isSymbol()) {
                if (head.equals(F.Re)) {
                    return x;
                }
                if (head.equals(F.Im)) {
                    return F.C0;
                }
                reX = x;
                imX = F.C0;
            } else {
                reX = F.eval(F.Re(x));
                imX = F.eval(F.Im(x));
                IExpr temp = ComplexExpand.complexExpandNull(reX);
                if (temp != null) {
                    reX = temp;
                }
                if ((temp = ComplexExpand.complexExpandNull(imX)) != null) {
                    imX = temp;
                }
            }
            if (head.equals(F.Abs)) {
                return ComplexExpand.complexExpand(F.Sqrt(F.Plus((IExpr)F.Power(reX, F.C2), (IExpr)F.Power(imX, F.C2))));
            }
            if (head.equals(F.Cos)) {
                return F.Plus((IExpr)F.Times((IExpr)F.Cos(reX), (IExpr)F.Cosh(imX)), (IExpr)F.Times(F.CI, F.Sin(reX), F.Sinh(imX)));
            }
            if (head.equals(F.Cot)) {
                return F.Plus((IExpr)F.Times(F.CN1, F.Sin(F.Times((IExpr)F.C2, reX)), F.Power((IExpr)F.Plus((IExpr)F.Cos(F.Times((IExpr)F.C2, reX)), (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Cosh(F.Times((IExpr)F.C2, imX)))), F.CN1)), (IExpr)F.Times(F.CI, F.Sinh(F.Times((IExpr)F.C2, imX)), F.Power((IExpr)F.Plus((IExpr)F.Cos(F.Times((IExpr)F.C2, reX)), (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Cosh(F.Times((IExpr)F.C2, imX)))), F.CN1)));
            }
            if (head.equals(F.Csc)) {
                return F.Plus((IExpr)F.Times(F.integer(-2L), F.Cosh(imX), F.Sin(reX), F.Power((IExpr)F.Plus((IExpr)F.Cos(F.Times((IExpr)F.C2, reX)), (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Cosh(F.Times((IExpr)F.C2, imX)))), F.CN1)), (IExpr)F.Times(F.C2, F.CI, F.Cos(reX), F.Sinh(imX), F.Power((IExpr)F.Plus((IExpr)F.Cos(F.Times((IExpr)F.C2, reX)), (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Cosh(F.Times((IExpr)F.C2, imX)))), F.CN1)));
            }
            if (head.equals(F.Sec)) {
                return F.Plus((IExpr)F.Times(F.C2, F.Cos(reX), F.Cosh(imX), F.Power((IExpr)F.Plus((IExpr)F.Cos(F.Times((IExpr)F.C2, reX)), (IExpr)F.Cosh(F.Times((IExpr)F.C2, imX))), F.CN1)), (IExpr)F.Times(F.C2, F.CI, F.Sin(reX), F.Sinh(imX), F.Power((IExpr)F.Plus((IExpr)F.Cos(F.Times((IExpr)F.C2, reX)), (IExpr)F.Cosh(F.Times((IExpr)F.C2, imX))), F.CN1)));
            }
            if (head.equals(F.Sin)) {
                return F.Plus((IExpr)F.Times((IExpr)F.Cosh(imX), (IExpr)F.Sin(reX)), (IExpr)F.Times(F.CI, F.Sinh(imX), F.Cos(reX)));
            }
            if (head.equals(F.Tan)) {
                return F.Plus((IExpr)F.Times((IExpr)F.Sin(F.Times((IExpr)F.C2, reX)), (IExpr)F.Power((IExpr)F.Plus((IExpr)F.Cos(F.Times((IExpr)F.C2, reX)), (IExpr)F.Cosh(F.Times((IExpr)F.C2, imX))), F.CN1)), (IExpr)F.Times(F.CI, F.Sinh(F.Times((IExpr)F.C2, imX)), F.Power((IExpr)F.Plus((IExpr)F.Cos(F.Times((IExpr)F.C2, reX)), (IExpr)F.Cosh(F.Times((IExpr)F.C2, imX))), F.CN1)));
            }
            if (result != null) {
                return F.$(head, result);
            }
            return null;
        }
    }
}

