/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import com.google.common.base.Function;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.polynomials.Polynomial;
import org.matheclipse.parser.client.SyntaxError;

public class Coefficient
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 3, 4);
        IExpr expr = F.evalExpandAll(ast.arg1());
        ISymbol arg2 = Validate.checkSymbolType(ast, 2);
        try {
            Polynomial poly;
            long n = 1L;
            if (ast.size() == 4) {
                if (ast.arg3().isNegativeInfinity()) {
                    return F.C0;
                }
                n = Validate.checkLongType(ast.arg3());
            }
            if ((poly = new Polynomial(expr, arg2)).isPolynomial()) {
                return poly.coefficient(n);
            }
            throw new WrongArgumentType(ast, expr, 1, "Polynomial expected!");
        }
        catch (ArithmeticException ae) {
            return null;
        }
    }

    public static IExpr coefficient(IExpr expr, ISymbol x, IInteger n) {
        if (expr.isAST()) {
            IAST expAST = (IAST)expr;
            PlusFunction plusFunction = new PlusFunction(x, n);
            if (expAST.isPlus()) {
                IAST filterAST = expAST.map(plusFunction);
                if (filterAST.size() == 1) {
                    return F.C0;
                }
                return F.eval(filterAST);
            }
            return (IExpr)plusFunction.apply(expAST);
        }
        return Coefficient.coefficientAtom(expr, x, n);
    }

    private static IExpr coefficientTimes(IAST times, IExpr arg2, IInteger n) throws ArithmeticException {
        for (int i = 1; i < times.size(); ++i) {
            if (((IExpr)times.get(i)).isPower()) {
                IAST pow = (IAST)times.get(i);
                if (!pow.equalsAt(1, arg2)) continue;
                if (pow.arg2().isNumEqualInteger(n)) {
                    return times.removeAtClone(i);
                }
                return F.C0;
            }
            if (!times.equalsAt(i, arg2)) continue;
            if (n.equals(F.C0)) {
                return F.C0;
            }
            if (n.equals(F.C1)) {
                return times.removeAtClone(i);
            }
            return F.C0;
        }
        if (n.equals(F.C0)) {
            return times;
        }
        return F.C0;
    }

    private static IExpr coefficientPower(IAST powerAST, IExpr arg2, IInteger n) {
        if (powerAST.equalsAt(1, arg2)) {
            if (powerAST.arg2().isNumEqualInteger(n)) {
                return F.C1;
            }
            return F.C0;
        }
        return F.C0;
    }

    private static IExpr coefficientAtom(IExpr expr, IExpr arg2, IInteger n) {
        if (n.equals(F.C0)) {
            if (expr.equals(arg2)) {
                return F.C0;
            }
            return expr;
        }
        if (n.equals(F.C1)) {
            if (expr.equals(arg2)) {
                return F.C1;
            }
            return F.C0;
        }
        return F.C0;
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(128);
        super.setUp(symbol);
    }

    private static class PlusFunction
    implements Function<IExpr, IExpr> {
        IExpr arg2;
        IInteger n;

        public PlusFunction(IExpr arg2, IInteger n) {
            this.arg2 = arg2;
            this.n = n;
        }

        @Override
        public IExpr apply(IExpr from) throws ArithmeticException {
            if (from.isPower()) {
                return Coefficient.coefficientPower((IAST)from, this.arg2, this.n);
            }
            if (from.isTimes()) {
                return Coefficient.coefficientTimes((IAST)from, this.arg2, this.n);
            }
            return Coefficient.coefficientAtom(from, this.arg2, this.n);
        }
    }
}

