/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISymbol;

public class Chop
extends AbstractFunctionEvaluator {
    public static final double DEFAULT_CHOP_DELTA = 1.0E-5;

    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 2, 3);
        IExpr arg1 = ast.arg1();
        double delta = 1.0E-5;
        if (ast.size() == 3 && ast.arg2() instanceof INum) {
            delta = ((INum)ast.arg2()).getRealPart();
        }
        try {
            arg1 = F.eval(arg1);
            if (arg1.isAST()) {
                IAST list = (IAST)arg1;
                return list.mapAt(F.Chop(F.Null), 1);
            }
            if (arg1.isNumber()) {
                return F.chopNumber((INumber)arg1, delta);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(224);
    }
}

