/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import com.google.common.base.Predicate;
import edu.jas.poly.GenPolynomial;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import org.matheclipse.core.convert.ExprVariables;
import org.matheclipse.core.convert.JASIExpr;
import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.ASTRange;
import org.matheclipse.core.expression.ExprRingFactory;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.polynomials.Polynomial;
import org.matheclipse.core.reflection.system.Apart;
import org.matheclipse.parser.client.SyntaxError;

public class Cancel
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        IAST result;
        Validate.checkRange(ast, 2, 3);
        IExpr arg1 = ast.arg1();
        if (arg1.isPlus() && (result = ((IAST)arg1).mapAt(F.Cancel(null), 1)) != null) {
            return result;
        }
        IExpr expandedArg1 = F.evalExpandAll(arg1);
        try {
            IExpr result2;
            if (expandedArg1.isPlus()) {
                IAST result3 = ((IAST)expandedArg1).mapAt(F.Cancel(null), 1);
                if (result3 != null) {
                    return result3;
                }
            } else if ((expandedArg1.isTimes() || expandedArg1.isPower()) && (result2 = Cancel.cancelPowerTimes(expandedArg1)) != null) {
                return result2;
            }
        }
        catch (JASConversionException jce) {
            // empty catch block
        }
        return arg1;
    }

    public static IExpr cancelPowerTimes(IExpr powerTimesAST) throws JASConversionException {
        IExpr[] parts = Apart.getFractionalParts(powerTimesAST);
        if (parts != null && parts[0].isPlus() && parts[1].isPlus()) {
            IExpr[] result;
            IAST[] numParts = ((IAST)parts[0]).filter(new PolynomialPredicate());
            IAST[] denParts = ((IAST)parts[1]).filter(new PolynomialPredicate());
            IExpr denParts0 = F.eval(denParts[0]);
            if (!denParts0.equals(F.C1) && (result = Cancel.cancelGCD(numParts[0], denParts0)) != null) {
                return F.Times(result[0], result[1], numParts[1], F.Power((IExpr)F.Times(result[2], (IExpr)denParts[1]), F.CN1));
            }
        }
        return null;
    }

    public static IExpr[] cancelGCD(IExpr poly1, IExpr poly2) throws JASConversionException {
        try {
            ExprVariables eVar = new ExprVariables(poly1);
            eVar.addVarList(poly2);
            if (eVar.size() == 0) {
                return null;
            }
            Polynomial pol1 = new Polynomial(poly1, eVar.getVarList(), false);
            Polynomial pol2 = new Polynomial(poly2, eVar.getVarList(), false);
            if (pol1.createPolynomial(poly1, true, false) && pol2.createPolynomial(poly2, true, false)) {
                ASTRange r = new ASTRange(eVar.getVarList(), 1);
                JASIExpr jas = new JASIExpr(r.toList(), true);
                GenPolynomial<IExpr> p1 = jas.expr2IExprJAS(pol1);
                GenPolynomial<IExpr> p2 = jas.expr2IExprJAS(pol2);
                GreatestCommonDivisorAbstract<IExpr> engine = GCDFactory.getImplementation(new ExprRingFactory());
                GenPolynomial<IExpr> gcd = engine.gcd(p1, p2);
                IExpr[] result = new IExpr[3];
                if (gcd.isONE()) {
                    result[0] = jas.exprPoly2Expr(gcd);
                    result[1] = jas.exprPoly2Expr(p1);
                    result[2] = jas.exprPoly2Expr(p2);
                } else {
                    result[0] = F.C1;
                    result[1] = F.eval(jas.exprPoly2Expr(p1.divide(gcd)));
                    result[2] = F.eval(jas.exprPoly2Expr(p2.divide(gcd)));
                }
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(128);
        super.setUp(symbol);
    }

    private static final class PolynomialPredicate
    implements Predicate<IExpr> {
        private PolynomialPredicate() {
        }

        @Override
        public boolean apply(IExpr expr) {
            return expr.isPolynomial(F.List());
        }
    }
}

