/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.math.BigInteger;
import org.apache.commons.math3.fraction.BigFraction;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.NumberUtil;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.Binomial;
import org.matheclipse.parser.client.SyntaxError;

public class BernoulliB
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        BigFraction bernoulli;
        Validate.checkRange(ast, 2, 3);
        if (ast.size() == 2 && ast.arg1().isInteger() && (bernoulli = BernoulliB.bernoulliNumber(((IInteger)ast.arg1()).getBigNumerator())) != null) {
            return F.fraction(bernoulli);
        }
        return null;
    }

    public static BigFraction bernoulliNumber(BigInteger biggi) {
        int N2 = 0;
        try {
            N2 = NumberUtil.toInt(biggi);
            return BernoulliB.bernoulliNumber(N2);
        }
        catch (ArithmeticException arithmeticException) {
            return null;
        }
    }

    public static BigFraction bernoulliNumber(int n) {
        if (n == 0) {
            return BigFraction.ONE;
        }
        if (n == 1) {
            return new BigFraction(-1, 2);
        }
        if (n % 2 != 0) {
            return BigFraction.ZERO;
        }
        BigFraction[] bernoulli = new BigFraction[n + 1];
        bernoulli[0] = BigFraction.ONE;
        bernoulli[1] = new BigFraction(-1, 2);
        for (int k = 2; k <= n; ++k) {
            bernoulli[k] = BigFraction.ZERO;
            for (int i = 0; i < k; ++i) {
                if (bernoulli[i].equals(BigFraction.ZERO)) continue;
                BigFraction bin = new BigFraction(Binomial.binomial(k + 1, k + 1 - i));
                bernoulli[k] = bernoulli[k].subtract(bin.multiply(bernoulli[i]));
            }
            bernoulli[k] = bernoulli[k].divide(new BigFraction(k + 1));
        }
        return bernoulli[n];
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(1152);
    }
}

