/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import com.google.common.base.Predicate;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.Predicates;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.PatternMatcher;

public class ArrayQ
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        int depth;
        Validate.checkRange(ast, 2, 4);
        Predicate<IExpr> pred = null;
        if (ast.size() >= 4) {
            pred = Predicates.isTrue(ast.arg3());
        }
        if ((depth = ArrayQ.determineDepth(ast.arg1(), 0, pred)) >= 0) {
            PatternMatcher matcher;
            if (ast.size() >= 3 && !(matcher = new PatternMatcher(ast.arg2())).apply(F.integer(depth))) {
                return F.False;
            }
            return F.True;
        }
        return F.False;
    }

    private static int determineDepth(IExpr expr, int depth, Predicate<IExpr> predicate) {
        int resultDepth = depth;
        if (expr.isList()) {
            IAST ast = (IAST)expr;
            int size = ast.size();
            IExpr arg1AST = ast.arg1();
            boolean isList = arg1AST.isList();
            int arg1Size = 0;
            if (isList) {
                arg1Size = ((IAST)ast.arg1()).size();
            }
            if ((resultDepth = ArrayQ.determineDepth(arg1AST, depth + 1, predicate)) < 0) {
                return -1;
            }
            for (int i = 2; i < size; ++i) {
                if (isList) {
                    if (!((IExpr)ast.get(i)).isList()) {
                        return -1;
                    }
                    if (arg1Size != ((IAST)ast.get(i)).size()) {
                        return -1;
                    }
                    int tempDepth = ArrayQ.determineDepth((IExpr)ast.get(i), depth + 1, predicate);
                    if (tempDepth >= 0 && tempDepth == resultDepth) continue;
                    return -1;
                }
                if (((IExpr)ast.get(i)).isList()) {
                    return -1;
                }
                if (predicate == null || predicate.apply((IExpr)ast.get(i))) continue;
                return -1;
            }
            return resultDepth;
        }
        if (predicate != null && !predicate.apply(expr)) {
            return -1;
        }
        return resultDepth;
    }

    @Override
    public IExpr numericEval(IAST ast) {
        return this.evaluate(ast);
    }

    @Override
    public void setUp(ISymbol symbol) {
    }
}

