/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.apfloat.Apcomplex;
import org.apfloat.ApcomplexMath;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatMath;
import org.matheclipse.core.eval.interfaces.AbstractArg12;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.ComplexUtils;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.rules.ArcTanRules;
import org.matheclipse.parser.client.SyntaxError;

public class ArcTan
extends AbstractArg12
implements INumeric,
ArcTanRules {
    @Override
    public IAST getRuleAST() {
        return RULES;
    }

    @Override
    public IExpr e1ObjArg(IExpr arg1) {
        IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
        if (negExpr != null) {
            return F.Times((IExpr)F.CN1, (IExpr)F.ArcTan(negExpr));
        }
        IExpr imPart = AbstractFunctionEvaluator.getPureImaginaryPart(arg1);
        if (imPart != null) {
            return F.Times((IExpr)F.CI, (IExpr)F.ArcTanh(imPart));
        }
        return null;
    }

    @Override
    public IExpr e1DblArg(INum arg1) {
        return F.num(Math.atan(arg1.getRealPart()));
    }

    @Override
    public IExpr e1DblComArg(IComplexNum c) {
        return ComplexUtils.atan((ComplexNum)c);
    }

    @Override
    public IExpr e2DblArg(INum d0, INum d1) {
        return F.num(Math.atan2(d0.getRealPart(), d1.getRealPart()));
    }

    @Override
    public IExpr e1ApfloatArg(Apfloat arg1) {
        return F.num(ApfloatMath.atan(arg1));
    }

    @Override
    public IExpr e1ApcomplexArg(Apcomplex arg1) {
        return F.complexNum(ApcomplexMath.atan(arg1));
    }

    @Override
    public double evalReal(double[] stack, int top, int size) {
        if (size != 1 && size != 2) {
            throw new UnsupportedOperationException();
        }
        if (size == 2) {
            return Math.atan2(stack[top - 1], stack[top]);
        }
        return Math.atan(stack[top]);
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(1152);
        super.setUp(symbol);
    }
}

