/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.apache.commons.math3.complex.Complex;
import org.apfloat.Apcomplex;
import org.apfloat.ApcomplexMath;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatMath;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractTrigArg1;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.rules.ArcCotRules;
import org.matheclipse.parser.client.SyntaxError;

public class ArcCot
extends AbstractTrigArg1
implements ArcCotRules {
    @Override
    public IAST getRuleAST() {
        return RULES;
    }

    @Override
    public IExpr e1DblArg(double arg1) {
        if (F.isZero(arg1)) {
            return F.num(1.5707963267948966);
        }
        return F.num(Math.atan(1.0 / arg1));
    }

    @Override
    public IExpr e1ComplexArg(Complex arg1) {
        Complex c = Complex.I.divide(arg1);
        Complex result = Complex.I.divide(new Complex(2.0)).multiply(Complex.ONE.subtract(c).log().subtract(Complex.ONE.add(c).log()));
        return F.complexNum(result);
    }

    @Override
    public IExpr e1ApfloatArg(Apfloat arg1) {
        if (arg1.equals(Apfloat.ZERO)) {
            return F.num(ApfloatMath.pi(arg1.precision()).divide(new Apfloat(2L)));
        }
        return F.num(ApfloatMath.atan(arg1.inverse()));
    }

    @Override
    public IExpr e1ApcomplexArg(Apcomplex arg1) {
        Apcomplex ac = Apcomplex.I.divide(arg1);
        Apcomplex result = Apcomplex.I.divide(new Apfloat(2L)).multiply(ApcomplexMath.log(Apcomplex.ONE.subtract(ac)).subtract(ApcomplexMath.log(Apcomplex.ONE.add(ac))));
        return F.complexNum(result);
    }

    @Override
    public IExpr evaluateArg1(IExpr arg1) {
        IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
        if (negExpr != null) {
            return F.Plus((IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Pi), (IExpr)F.ArcCot(negExpr));
        }
        IExpr imPart = AbstractFunctionEvaluator.getPureImaginaryPart(arg1);
        if (imPart != null) {
            return F.Times((IExpr)F.CNI, (IExpr)F.ArcCoth(imPart));
        }
        return null;
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(1152);
        super.setUp(symbol);
    }
}

