/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomial;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import org.matheclipse.core.convert.ExprVariables;
import org.matheclipse.core.convert.JASConvert;
import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.ASTRange;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.polynomials.IPartialFractionGenerator;
import org.matheclipse.core.polynomials.PartialFractionGenerator;
import org.matheclipse.core.reflection.system.Denominator;

public class Apart
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 2, 3);
        IAST variableList = null;
        if (ast.size() == 3) {
            variableList = Validate.checkSymbolOrSymbolList(ast, 2);
        } else {
            ExprVariables eVar = new ExprVariables(ast.arg1());
            if (!eVar.isSize(1)) {
                return null;
            }
            variableList = eVar.getVarList();
        }
        IExpr arg = ast.arg1();
        if (arg.isTimes() || arg.isPower()) {
            IAST plusResult;
            IExpr[] parts = Apart.getFractionalParts(ast.arg1());
            if (parts != null && (plusResult = Apart.partialFractionDecompositionRational(new PartialFractionGenerator(), parts, (ISymbol)variableList.arg1())) != null) {
                return plusResult.getOneIdentity(F.C0);
            }
        } else {
            return ast.arg1();
        }
        return null;
    }

    public static IAST partialFractionDecompositionInteger(IExpr[] parts, IAST variableList) {
        try {
            IExpr exprNumerator = F.evalExpandAll(parts[0]);
            IExpr exprDenominator = F.evalExpandAll(parts[1]);
            ASTRange r = new ASTRange(variableList, 1);
            List<IExpr> varList = r.toList();
            String[] varListStr = new String[]{variableList.arg1().toString()};
            JASConvert<BigInteger> jas = new JASConvert<BigInteger>(varList, BigInteger.ZERO);
            GenPolynomial<BigInteger> numerator = jas.expr2JAS(exprNumerator, false);
            GenPolynomial<BigInteger> denominator = jas.expr2JAS(exprDenominator, false);
            FactorAbstract<BigInteger> factorAbstract = FactorFactory.getImplementation(BigInteger.ZERO);
            SortedMap sfactors = factorAbstract.baseFactors(denominator);
            ArrayList<GenPolynomial<BigInteger>> D2 = new ArrayList<GenPolynomial<BigInteger>>(sfactors.keySet());
            SquarefreeAbstract<BigInteger> sqf = SquarefreeFactory.getImplementation(BigInteger.ZERO);
            List<List<GenPolynomial<BigInteger>>> Ai = sqf.basePartialFraction(numerator, sfactors);
            if (Ai.size() > 0) {
                IExpr temp;
                IAST result = F.Plus();
                if (!Ai.get(0).get(0).isZERO()) {
                    temp = F.eval(jas.integerPoly2Expr(Ai.get(0).get(0)));
                    if (temp.isAST()) {
                        ((IAST)temp).addEvalFlags(128);
                    }
                    result.add(temp);
                }
                for (int i = 1; i < Ai.size(); ++i) {
                    List<GenPolynomial<BigInteger>> list = Ai.get(i);
                    long j = 0L;
                    for (GenPolynomial<BigInteger> genPolynomial : list) {
                        if (!genPolynomial.isZERO() && !(temp = F.eval(F.Times(jas.integerPoly2Expr(genPolynomial), (IExpr)F.Power(jas.integerPoly2Expr((GenPolynomial)D2.get(i - 1)), F.integer(j * -1L))))).equals(F.C0)) {
                            if (temp.isAST()) {
                                ((IAST)temp).addEvalFlags(128);
                            }
                            result.add(temp);
                        }
                        ++j;
                    }
                }
                return result;
            }
        }
        catch (JASConversionException jASConversionException) {
            // empty catch block
        }
        return null;
    }

    public static IAST partialFractionDecompositionRational(IPartialFractionGenerator pf, IExpr[] parts, ISymbol x) {
        try {
            IAST variableList = F.List((IExpr)x);
            IExpr exprNumerator = F.evalExpandAll(parts[0]);
            IExpr exprDenominator = F.evalExpandAll(parts[1]);
            ASTRange r = new ASTRange(variableList, 1);
            List<IExpr> varList = r.toList();
            String[] varListStr = new String[]{variableList.arg1().toString()};
            JASConvert<BigRational> jas = new JASConvert<BigRational>(varList, BigRational.ZERO);
            GenPolynomial<BigRational> numerator = jas.expr2JAS(exprNumerator, false);
            GenPolynomial<BigRational> denominator = jas.expr2JAS(exprDenominator, false);
            FactorAbstract<BigRational> factorAbstract = FactorFactory.getImplementation(BigRational.ZERO);
            SortedMap sfactors = factorAbstract.baseFactors(denominator);
            ArrayList<GenPolynomial<BigRational>> D2 = new ArrayList<GenPolynomial<BigRational>>(sfactors.keySet());
            SquarefreeAbstract<BigRational> sqf = SquarefreeFactory.getImplementation(BigRational.ZERO);
            List<List<GenPolynomial<BigRational>>> Ai = sqf.basePartialFraction(numerator, sfactors);
            if (Ai.size() > 0) {
                pf.setJAS(jas);
                if (!Ai.get(0).get(0).isZERO()) {
                    pf.addNonFractionalPart(Ai.get(0).get(0));
                }
                for (int i = 1; i < Ai.size(); ++i) {
                    List<GenPolynomial<BigRational>> list = Ai.get(i);
                    int j = 0;
                    for (GenPolynomial<BigRational> genPolynomial : list) {
                        if (!genPolynomial.isZERO()) {
                            GenPolynomial Di_1 = (GenPolynomial)D2.get(i - 1);
                            pf.addSinglePartialFraction(genPolynomial, Di_1, j);
                        }
                        ++j;
                    }
                }
                return pf.getResult();
            }
        }
        catch (JASConversionException jASConversionException) {
            // empty catch block
        }
        return null;
    }

    public static IExpr[] getFractionalPartsRational(IExpr arg) {
        if (arg.isFraction()) {
            IFraction fr = (IFraction)arg;
            IExpr[] parts = new IExpr[]{fr.getNumerator(), fr.getDenominator()};
            return parts;
        }
        return Apart.getFractionalParts(arg);
    }

    public static IExpr[] getFractionalParts(IExpr arg) {
        IAST denomForm;
        IExpr[] parts = null;
        if (arg.isTimes()) {
            parts = Apart.getFractionalPartsTimes((IAST)arg, true);
        } else if (arg.isPower()) {
            parts = new IExpr[2];
            IExpr denom = Apart.getFractionalPartsPower((IAST)arg);
            if (denom == null) {
                return null;
            }
            parts[0] = F.C1;
            parts[1] = denom;
        } else if (arg.isAST() && (denomForm = Denominator.getDenominatorForm((IAST)arg)) != null) {
            parts = new IExpr[]{F.C1, denomForm};
            return parts;
        }
        return parts;
    }

    public static IExpr[] getFractionalPartsTimes(IAST timesAST, boolean splitFractionalNumbers) {
        IExpr[] result = new IExpr[2];
        IAST numerator = F.Times();
        IAST denominator = F.Times();
        boolean evaled = false;
        for (int i = 1; i < timesAST.size(); ++i) {
            IExpr arg = (IExpr)timesAST.get(i);
            if (arg.isAST()) {
                IExpr denom;
                IAST argAST = (IAST)arg;
                if (argAST.size() == 2) {
                    IAST denomForm = Denominator.getDenominatorForm(argAST);
                    if (denomForm != null) {
                        denominator.add(denomForm);
                        evaled = true;
                        continue;
                    }
                } else if (arg.isPower() && (denom = Apart.getFractionalPartsPower((IAST)arg)) != null) {
                    denominator.add(denom);
                    evaled = true;
                    continue;
                }
            } else if (splitFractionalNumbers && arg.isFraction()) {
                IFraction fr = (IFraction)arg;
                numerator.add(fr.getNumerator());
                denominator.add(fr.getDenominator());
                evaled = true;
                continue;
            }
            numerator.add(arg);
        }
        if (evaled) {
            result[0] = numerator.getOneIdentity(F.C1);
            result[1] = denominator.getOneIdentity(F.C1);
            return result;
        }
        return null;
    }

    public static IExpr getFractionalPartsPower(IAST powerAST) {
        IExpr negExpr;
        IExpr arg2 = powerAST.arg2();
        if (arg2.isSignedNumber()) {
            IAST function;
            IAST denomForm;
            ISignedNumber sn = (ISignedNumber)arg2;
            if (sn.isMinusOne()) {
                return powerAST.arg1();
            }
            if (sn.isNegative()) {
                return F.Power(powerAST.arg1(), sn.negate());
            }
            if (sn.isInteger() && powerAST.arg1().isAST() && (denomForm = Denominator.getDenominatorForm(function = (IAST)powerAST.arg1())) != null) {
                return F.Power((IExpr)denomForm, sn);
            }
        }
        if ((negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg2)) != null) {
            return F.Power(powerAST.arg1(), negExpr);
        }
        return null;
    }
}

