/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import com.google.common.base.Function;
import org.apache.commons.math3.complex.Complex;
import org.apfloat.Apcomplex;
import org.apfloat.ApcomplexMath;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatMath;
import org.matheclipse.core.eval.interfaces.AbstractTrigArg1;
import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.interfaces.INumericFunction;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.rules.AbsRules;
import org.matheclipse.parser.client.SyntaxError;

public class Abs
extends AbstractTrigArg1
implements INumeric,
AbsRules {
    @Override
    public IAST getRuleAST() {
        return RULES;
    }

    @Override
    public double evalReal(double[] stack, int top, int size) {
        if (size != 1) {
            throw new UnsupportedOperationException();
        }
        return Math.abs(stack[top]);
    }

    @Override
    public IExpr evaluateArg1(IExpr arg1) {
        IAST[] result;
        if (arg1.isNumber()) {
            return ((INumber)arg1).eabs();
        }
        if (arg1.isSymbol()) {
            ISymbol sym = (ISymbol)arg1;
            return sym.mapConstantDouble(new AbsNumericFunction(sym));
        }
        if (arg1.isTimes() && (result = ((IAST)arg1).filter(new AbsTimesFunction()))[0].size() > 1) {
            if (result[1].size() > 1) {
                result[0].add(F.Abs(result[1]));
            }
            return result[0];
        }
        return null;
    }

    @Override
    public IExpr e1DblArg(double arg1) {
        return F.num(Math.abs(arg1));
    }

    @Override
    public IExpr e1ComplexArg(Complex arg1) {
        return F.num(ComplexNum.dabs(arg1));
    }

    @Override
    public IExpr e1ApfloatArg(Apfloat arg1) {
        return F.num(ApfloatMath.abs(arg1));
    }

    @Override
    public IExpr e1ApcomplexArg(Apcomplex arg1) {
        return F.num(ApcomplexMath.abs(arg1));
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(1152);
        super.setUp(symbol);
    }

    private final class AbsNumericFunction
    implements INumericFunction<IExpr> {
        final ISymbol symbol;

        public AbsNumericFunction(ISymbol symbol) {
            this.symbol = symbol;
        }

        @Override
        public IExpr apply(double value) {
            double result;
            if (value < 2.147483647E9 && value > -2.147483648E9 && (result = Math.abs(value)) > 0.0) {
                return this.symbol;
            }
            return null;
        }
    }

    private final class AbsTimesFunction
    implements Function<IExpr, IExpr> {
        private AbsTimesFunction() {
        }

        @Override
        public IExpr apply(IExpr expr) {
            if (expr.isNumber()) {
                return ((INumber)expr).eabs();
            }
            IExpr temp = F.eval(F.Abs(expr));
            if (!temp.topHead().equals(F.Abs)) {
                return temp;
            }
            return null;
        }
    }
}

