/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.polynomials;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.fraction.BigFraction;
import org.apache.commons.math3.util.FastMath;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class PolynomialsUtils {
    private static final List<BigFraction> CHEBYSHEV_COEFFICIENTS = new ArrayList<BigFraction>();
    private static final List<BigFraction> HERMITE_COEFFICIENTS;
    private static final List<BigFraction> LAGUERRE_COEFFICIENTS;
    private static final List<BigFraction> LEGENDRE_COEFFICIENTS;

    private PolynomialsUtils() {
    }

    public static IAST createChebyshevPolynomial(int degree, IExpr x) {
        return PolynomialsUtils.buildPolynomial(degree, x, CHEBYSHEV_COEFFICIENTS, new RecurrenceCoefficientsGenerator(){
            private final BigFraction[] coeffs = new BigFraction[]{BigFraction.ZERO, BigFraction.TWO, BigFraction.ONE};

            @Override
            public BigFraction[] generate(int k) {
                return this.coeffs;
            }
        });
    }

    public static IAST createHermitePolynomial(int degree, IExpr x) {
        return PolynomialsUtils.buildPolynomial(degree, x, HERMITE_COEFFICIENTS, new RecurrenceCoefficientsGenerator(){

            @Override
            public BigFraction[] generate(int k) {
                return new BigFraction[]{BigFraction.ZERO, BigFraction.TWO, new BigFraction(2 * k)};
            }
        });
    }

    public static IAST createLaguerrePolynomial(int degree, IExpr x) {
        return PolynomialsUtils.buildPolynomial(degree, x, LAGUERRE_COEFFICIENTS, new RecurrenceCoefficientsGenerator(){

            @Override
            public BigFraction[] generate(int k) {
                int kP1 = k + 1;
                return new BigFraction[]{new BigFraction(2 * k + 1, kP1), new BigFraction(-1, kP1), new BigFraction(k, kP1)};
            }
        });
    }

    public static IAST createLegendrePolynomial(int degree, IExpr x) {
        return PolynomialsUtils.buildPolynomial(degree, x, LEGENDRE_COEFFICIENTS, new RecurrenceCoefficientsGenerator(){

            @Override
            public BigFraction[] generate(int k) {
                int kP1 = k + 1;
                return new BigFraction[]{BigFraction.ZERO, new BigFraction(k + kP1, kP1), new BigFraction(k, kP1)};
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IAST buildPolynomial(int degree, IExpr x, List<BigFraction> coefficients, RecurrenceCoefficientsGenerator generator) {
        int maxDegree = (int)FastMath.floor(FastMath.sqrt(2 * coefficients.size())) - 1;
        Class<PolynomialsUtils> clazz = PolynomialsUtils.class;
        synchronized (PolynomialsUtils.class) {
            if (degree > maxDegree) {
                PolynomialsUtils.computeUpToDegree(degree, maxDegree, generator, coefficients);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            int start = degree * (degree + 1) / 2;
            IAST result = F.Plus();
            for (int i = 0; i <= degree; ++i) {
                result.add(F.Times((IExpr)F.fraction(coefficients.get(start + i)), (IExpr)F.Power(x, F.integer(i))));
            }
            return result;
        }
    }

    private static void computeUpToDegree(int degree, int maxDegree, RecurrenceCoefficientsGenerator generator, List<BigFraction> coefficients) {
        int startK = (maxDegree - 1) * maxDegree / 2;
        for (int k = maxDegree; k < degree; ++k) {
            int startKm1 = startK;
            BigFraction[] ai = generator.generate(k);
            BigFraction ck = coefficients.get(startK += k);
            BigFraction ckm1 = coefficients.get(startKm1);
            coefficients.add(ck.multiply(ai[0]).subtract(ckm1.multiply(ai[2])));
            for (int i = 1; i < k; ++i) {
                BigFraction ckPrev = ck;
                ck = coefficients.get(startK + i);
                ckm1 = coefficients.get(startKm1 + i);
                coefficients.add(ck.multiply(ai[0]).add(ckPrev.multiply(ai[1])).subtract(ckm1.multiply(ai[2])));
            }
            BigFraction ckPrev = ck;
            ck = coefficients.get(startK + k);
            coefficients.add(ck.multiply(ai[0]).add(ckPrev.multiply(ai[1])));
            coefficients.add(ck.multiply(ai[1]));
        }
    }

    static {
        CHEBYSHEV_COEFFICIENTS.add(BigFraction.ONE);
        CHEBYSHEV_COEFFICIENTS.add(BigFraction.ZERO);
        CHEBYSHEV_COEFFICIENTS.add(BigFraction.ONE);
        HERMITE_COEFFICIENTS = new ArrayList<BigFraction>();
        HERMITE_COEFFICIENTS.add(BigFraction.ONE);
        HERMITE_COEFFICIENTS.add(BigFraction.ZERO);
        HERMITE_COEFFICIENTS.add(BigFraction.TWO);
        LAGUERRE_COEFFICIENTS = new ArrayList<BigFraction>();
        LAGUERRE_COEFFICIENTS.add(BigFraction.ONE);
        LAGUERRE_COEFFICIENTS.add(BigFraction.ONE);
        LAGUERRE_COEFFICIENTS.add(BigFraction.MINUS_ONE);
        LEGENDRE_COEFFICIENTS = new ArrayList<BigFraction>();
        LEGENDRE_COEFFICIENTS.add(BigFraction.ONE);
        LEGENDRE_COEFFICIENTS.add(BigFraction.ZERO);
        LEGENDRE_COEFFICIENTS.add(BigFraction.ONE);
    }

    public static interface RecurrenceCoefficientsGenerator {
        public BigFraction[] generate(int var1);
    }
}

