/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.polynomials;

import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.matheclipse.core.convert.ExprVariables;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.Predicates;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.polynomials.ExponentArray;
import org.matheclipse.core.polynomials.Monomial;

public class Polynomial {
    private polyType fPolynomialType = polyType.Undefined;
    SortedMap<ExponentArray, Monomial> fMonomials;
    final IAST fVariables;
    IExpr fExpr = null;
    final int fLength;
    boolean fIsPolynomial = true;

    public Polynomial(IExpr polynomialExpr, IAST variables, Comparator<ExponentArray> comparator) {
        this(polynomialExpr, variables, comparator, true);
    }

    public Polynomial(IExpr polynomialExpr, IAST variables, Comparator<ExponentArray> comparator, boolean convertPolynomial) {
        this.fVariables = variables;
        this.fExpr = polynomialExpr;
        this.fLength = variables.size() - 1;
        this.fMonomials = comparator == null ? new TreeMap<ExponentArray, Monomial>() : new TreeMap<ExponentArray, Monomial>(comparator);
        if (convertPolynomial) {
            this.fIsPolynomial = this.createPolynomial(polynomialExpr);
        }
    }

    public Polynomial(IExpr polynomialExpr, ISymbol variable) {
        this(polynomialExpr, variable, true);
    }

    public Polynomial(IExpr polynomialExpr, IAST variables) {
        this(polynomialExpr, variables, true);
    }

    public Polynomial(IExpr polynomialExpr, ExprVariables variables) {
        this(polynomialExpr, variables.getVarList(), true);
    }

    public Polynomial(IExpr polynomialExpr, ISymbol variable, boolean convertPolynomial) {
        this(polynomialExpr, F.List((IExpr)variable), convertPolynomial);
    }

    public Polynomial(IExpr polynomialExpr, IAST variables, boolean convertPolynomial) {
        this.fVariables = variables;
        this.fExpr = polynomialExpr;
        this.fLength = this.fVariables.size() - 1;
        this.fMonomials = new TreeMap<ExponentArray, Monomial>();
        if (convertPolynomial) {
            this.fIsPolynomial = this.createPolynomial(polynomialExpr);
        }
    }

    private void addMonomial(Monomial m) {
        ExponentArray a1 = m.getExponents();
        Monomial monom = (Monomial)this.fMonomials.get(m.getExponents());
        if (monom != null) {
            monom.setCoefficient(monom.getCoefficient().plus(m.getCoefficient()));
            return;
        }
        this.fMonomials.put(a1, m);
    }

    private void addMonomial(IExpr coefficient, ExponentArray expArray) {
        Monomial monom = (Monomial)this.fMonomials.get(expArray);
        if (monom != null) {
            monom.setCoefficient(monom.getCoefficient().plus(coefficient));
            return;
        }
        this.fMonomials.put(expArray, new Monomial(coefficient, expArray));
    }

    public boolean createPolynomial(IExpr polynomialExpr) {
        return this.createPolynomial(polynomialExpr, false, false);
    }

    public boolean createPolynomial(IExpr polynomialExpr, boolean isFree, boolean numericFunction) {
        if (polynomialExpr.isZero()) {
            return true;
        }
        int exp = this.isVariable(polynomialExpr);
        if (exp >= 0) {
            this.addMonomial(F.C1, new ExponentArray(this.fLength, exp));
            return true;
        }
        if (polynomialExpr.isAST()) {
            try {
                IAST ast = (IAST)polynomialExpr;
                if (ast.isPlus()) {
                    for (int i = 1; i < ast.size(); ++i) {
                        Monomial monom;
                        IExpr temp = (IExpr)ast.get(i);
                        exp = this.isVariable(temp);
                        if (exp >= 0) {
                            this.addMonomial(F.C1, new ExponentArray(this.fLength, exp));
                            continue;
                        }
                        if (this.isCoefficient(temp, numericFunction)) {
                            this.addMonomial(temp, new ExponentArray(this.fLength));
                            continue;
                        }
                        if (temp.isTimes()) {
                            monom = this.createMonomial((IAST)temp, isFree, numericFunction);
                            if (monom != null) {
                                this.addMonomial(monom);
                                continue;
                            }
                        } else if (temp.isPower() && (monom = this.createPowerExponent((IAST)temp, isFree, numericFunction)) != null) {
                            this.addMonomial(monom);
                            continue;
                        }
                        return false;
                    }
                    return true;
                }
                if (ast.isTimes()) {
                    Monomial monom = this.createMonomial(ast, isFree, numericFunction);
                    if (monom != null) {
                        this.addMonomial(monom);
                        return true;
                    }
                    return false;
                }
                if (ast.isPower()) {
                    Monomial monom = this.createPowerExponent(ast, isFree, numericFunction);
                    if (monom == null) {
                        return false;
                    }
                    this.addMonomial(monom);
                    return true;
                }
            }
            catch (WrongArgumentType e) {
                return false;
            }
        }
        if (this.isCoefficient(polynomialExpr, numericFunction)) {
            this.addMonomial(polynomialExpr, new ExponentArray(this.fLength));
            return true;
        }
        return false;
    }

    private Monomial createMonomial(IAST timesAST, boolean isFree, boolean numericFunction) throws WrongArgumentType {
        ExponentArray exponents = new ExponentArray(this.fLength);
        Monomial result = new Monomial(F.C1, exponents);
        for (int i = 1; i < timesAST.size(); ++i) {
            IExpr temp = (IExpr)timesAST.get(i);
            int exp = this.isVariable(temp);
            if (exp >= 0) {
                result.timesByMonomial(exp);
                continue;
            }
            if (this.isCoefficient(temp, numericFunction)) {
                result.timesByMonomial(temp);
                continue;
            }
            if (temp.isPower()) {
                Monomial monom = this.createPowerExponent((IAST)temp, isFree, numericFunction);
                if (monom != null) {
                    result.timesByMonomial(monom);
                    continue;
                }
                return null;
            }
            if (isFree) {
                return null;
            }
            result.timesByMonomial(temp);
        }
        return result;
    }

    private Monomial createPowerExponent(IAST powerAST, boolean isFree, boolean numericFunction) throws WrongArgumentType {
        IExpr arg1 = powerAST.arg1();
        int position = this.isVariable(arg1);
        if (position >= 0) {
            long exponent = Validate.checkLongPowerExponent(powerAST);
            if (exponent < 0L) {
                return new Monomial(powerAST, new ExponentArray(this.fLength));
            }
            return new Monomial(F.C1, new ExponentArray(this.fLength, position, exponent));
        }
        if (isFree) {
            if (this.isCoefficient(powerAST, numericFunction)) {
                return new Monomial(powerAST, new ExponentArray(this.fLength));
            }
            return null;
        }
        return new Monomial(powerAST, new ExponentArray(this.fLength));
    }

    public boolean isPolynomial(IExpr polynomialExpr) {
        if (this.isVariable(polynomialExpr) >= 0) {
            return true;
        }
        if (polynomialExpr.isAST()) {
            IAST ast = (IAST)polynomialExpr;
            if (ast.isPlus()) {
                for (int i = 1; i < ast.size(); ++i) {
                    IExpr temp = (IExpr)ast.get(i);
                    if (this.isVariable(temp) >= 0 || this.isCoefficient(temp, false) || (temp.isTimes() ? this.isMonomial((IAST)temp) : temp.isPower() && this.isPowerExponent((IAST)temp))) continue;
                    return false;
                }
                return true;
            }
            if (ast.isTimes()) {
                if (this.isMonomial(ast)) {
                    return true;
                }
            } else if (ast.isPower()) {
                return this.isPowerExponent(ast);
            }
        }
        return this.isCoefficient(polynomialExpr, false);
    }

    public boolean isPolynomial() {
        return this.fIsPolynomial;
    }

    private boolean isPowerExponent(IAST powerAST) {
        IExpr expr = (IExpr)powerAST.get(1);
        if (this.isVariable(expr) >= 0) {
            long exponent = -1L;
            try {
                exponent = Validate.checkLongPowerExponent(powerAST);
            }
            catch (WrongArgumentType e) {
                return false;
            }
            return exponent >= 0L;
        }
        return this.isCoefficient(powerAST, false);
    }

    private boolean isMonomial(IAST timesAST) {
        for (int i = 1; i < timesAST.size(); ++i) {
            IExpr temp = (IExpr)timesAST.get(i);
            if (this.isVariable(temp) >= 0 || this.isCoefficient(temp, false) || temp.isPower() && this.isPowerExponent((IAST)temp)) continue;
            return false;
        }
        return true;
    }

    public boolean isCoefficient(IExpr polynomialExpr, boolean numericFunction) {
        if (polynomialExpr.isInteger()) {
            if (this.fPolynomialType.compareTo(polyType.Integer) < 0) {
                this.fPolynomialType = polyType.Integer;
            }
            return true;
        }
        if (polynomialExpr.isFraction()) {
            if (this.fPolynomialType.compareTo(polyType.Rational) < 0) {
                this.fPolynomialType = polyType.Rational;
            }
            return true;
        }
        if (polynomialExpr.isComplex()) {
            if (this.fPolynomialType.compareTo(polyType.Complex) < 0) {
                this.fPolynomialType = polyType.Complex;
            }
            return true;
        }
        if (polynomialExpr.isNumeric()) {
            if (polynomialExpr instanceof IComplexNum) {
                if (this.fPolynomialType.compareTo(polyType.ComplexNumeric) < 0) {
                    this.fPolynomialType = polyType.ComplexNumeric;
                }
            } else if (this.fPolynomialType.compareTo(polyType.Numeric) < 0) {
                this.fPolynomialType = polyType.Numeric;
            }
            return true;
        }
        if (polynomialExpr.isComplexNumeric()) {
            if (this.fPolynomialType.compareTo(polyType.ComplexNumeric) < 0) {
                this.fPolynomialType = polyType.ComplexNumeric;
            }
            return true;
        }
        if (polynomialExpr.isFree(Predicates.in(this.fVariables), true)) {
            if (numericFunction && !polynomialExpr.isNumericFunction()) {
                return false;
            }
            if (this.fPolynomialType.compareTo(polyType.Expr) < 0) {
                this.fPolynomialType = polyType.Expr;
            }
            return true;
        }
        return false;
    }

    private int isVariable(IExpr expr) {
        for (int i = 1; i < this.fVariables.size(); ++i) {
            if (!((IExpr)this.fVariables.get(i)).equals(expr)) continue;
            return i - 1;
        }
        return -1;
    }

    public long maximumDegree() {
        if (this.fMonomials.size() == 0) {
            return 0L;
        }
        long maximum = 0L;
        for (ExponentArray monom : this.fMonomials.keySet()) {
            long monomialDegree = monom.maximumDegree();
            if (monomialDegree <= maximum) continue;
            maximum = monomialDegree;
        }
        return maximum;
    }

    public IExpr coefficient(long exponent) {
        ExponentArray expArray = new ExponentArray(1, 0, exponent);
        Monomial monom = (Monomial)this.fMonomials.get(expArray);
        if (monom != null) {
            return monom.getCoefficient();
        }
        return F.C0;
    }

    public IAST coefficientList() {
        IAST result = F.List();
        long lastDegree = 0L;
        for (ExponentArray expArray : this.fMonomials.keySet()) {
            long exp = expArray.getExponent(0);
            while (lastDegree < exp) {
                result.add(F.C0);
                ++lastDegree;
            }
            if (lastDegree != exp) continue;
            Monomial monom = (Monomial)this.fMonomials.get(expArray);
            result.add(monom.getCoefficient());
            ++lastDegree;
        }
        return result;
    }

    public Polynomial derivative() {
        Polynomial result = new Polynomial(null, this.fVariables, null, false);
        Validate.checkSize(this.fVariables, 2);
        for (Monomial monom : this.fMonomials.values()) {
            Monomial clone = monom.clone();
            long exp = clone.fExpArray.fExponents[0];
            if (exp == 0L) continue;
            clone.fExpArray.fExponents[0] = exp - 1L;
            clone.fCoefficient = clone.fCoefficient.times(F.integer(exp));
            result.fMonomials.put(clone.fExpArray, clone);
        }
        return result;
    }

    public IAST monomialList() {
        IAST result = F.List();
        for (ExponentArray expArray : this.fMonomials.keySet()) {
            Monomial monom = (Monomial)this.fMonomials.get(expArray);
            IAST temp = F.Times();
            monom.appendToExpr(temp, this.fVariables);
            result.add(temp);
        }
        return result;
    }

    public boolean isZero() {
        return this.fMonomials.size() == 0;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        boolean initialized = false;
        for (ExponentArray expArray : this.fMonomials.keySet()) {
            Monomial monom = (Monomial)this.fMonomials.get(expArray);
            if (initialized) {
                buf.append("+");
            }
            monom.appendToString(buf, this.fVariables);
            initialized = true;
        }
        return buf.toString();
    }

    public IExpr getExpr() {
        if (this.fExpr == null) {
            IAST result = F.Plus();
            for (Monomial monom : this.fMonomials.values()) {
                IExpr coeff = monom.getCoefficient();
                if (coeff.isZero()) continue;
                IAST times = F.Times(coeff);
                long[] exponents = monom.fExpArray.fExponents;
                for (int i = 0; i < exponents.length; ++i) {
                    if (exponents[i] == 0L) continue;
                    times.add(F.Power((IExpr)this.fVariables.get(i + 1), exponents[i]));
                }
                result.add(times);
            }
            this.fExpr = result.getOneIdentity(F.C0);
        }
        return this.fExpr;
    }

    public SortedMap<ExponentArray, Monomial> getMonomials() {
        return this.fMonomials;
    }

    private static enum polyType {
        Undefined,
        Integer,
        Rational,
        Complex,
        Numeric,
        ComplexNumeric,
        Expr;

    }
}

