/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.polynomials;

import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.polynomials.ExponentArray;

public class Monomial
implements Comparable<Monomial>,
Cloneable {
    ExponentArray fExpArray;
    IExpr fCoefficient;

    public Monomial(IExpr coefficient, ExponentArray array) {
        this.fCoefficient = coefficient;
        this.fExpArray = array;
    }

    protected void appendToExpr(IAST list, IAST variables) {
        long[] arr = this.fExpArray.getExponents();
        list.add(this.fCoefficient);
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == 0L) continue;
            if (arr[i] == 1L) {
                list.add(variables.get(i + 1));
                continue;
            }
            list.add(F.Power((IExpr)variables.get(i + 1), arr[i]));
        }
    }

    protected void appendToString(StringBuilder buf, IAST variables) {
        long[] arr = this.fExpArray.getExponents();
        buf.append(this.fCoefficient.toString());
        buf.append("*");
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == 0L) continue;
            buf.append(variables.get(i + 1));
            if (arr[i] == 1L) continue;
            buf.append("^");
            buf.append(arr[i]);
        }
    }

    protected Monomial clone() {
        try {
            Monomial m = (Monomial)super.clone();
            m.fExpArray = this.fExpArray.clone();
            return m;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int compareTo(Monomial o) {
        int c = this.fExpArray.compareTo(o.fExpArray);
        if (c != 0) {
            return c;
        }
        return this.fCoefficient.compareTo(o.fCoefficient);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Monomial) {
            Monomial other = (Monomial)obj;
            return this.fCoefficient.equals(other.fCoefficient) && this.fExpArray.equals(other.fExpArray);
        }
        return false;
    }

    public IExpr getCoefficient() {
        return this.fCoefficient;
    }

    public ExponentArray getExponents() {
        return this.fExpArray;
    }

    public int hashCode() {
        return this.fCoefficient.hashCode() * this.fExpArray.hashCode();
    }

    public void setCoefficient(IExpr fCoefficient) {
        this.fCoefficient = fCoefficient;
    }

    protected void timesByMonomial(IExpr coefficient) {
        this.setCoefficient(this.getCoefficient().times(coefficient));
    }

    protected void timesByMonomial(int position) {
        this.getExponents().timesBy(position);
    }

    protected void timesByMonomial(Monomial rhs) {
        this.setCoefficient(this.getCoefficient().times(rhs.getCoefficient()));
        this.getExponents().timesBy(rhs.getExponents());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        long[] arr = this.fExpArray.getExponents();
        buf.append(this.fCoefficient.toString());
        buf.append("*");
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == 0L) continue;
            buf.append("v[" + i + "]");
            if (arr[i] == 1L) continue;
            buf.append("^");
            buf.append(arr[i]);
        }
        return buf.toString();
    }
}

