/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.polynomials;

import java.util.Arrays;
import java.util.Comparator;

public class ExponentArray
implements Comparable<ExponentArray>,
Cloneable {
    long sum = -1L;
    long[] fExponents;

    public static Comparator<ExponentArray> degreeLexicographic() {
        return new Comparator<ExponentArray>(){

            @Override
            public int compare(ExponentArray o1, ExponentArray o2) {
                int i;
                if (o1.sum < 0L) {
                    o1.sum = 0L;
                    for (i = 0; i < o1.fExponents.length; ++i) {
                        o1.sum += o1.fExponents[i];
                    }
                }
                if (o2.sum < 0L) {
                    o2.sum = 0L;
                    for (i = 0; i < o2.fExponents.length; ++i) {
                        o2.sum += o2.fExponents[i];
                    }
                }
                if (o1.sum > o2.sum) {
                    return -1;
                }
                if (o1.sum < o2.sum) {
                    return 1;
                }
                for (i = 0; i < o1.fExponents.length; ++i) {
                    if (o1.fExponents[i] < o2.fExponents[i]) {
                        return -1;
                    }
                    if (o1.fExponents[i] <= o2.fExponents[i]) continue;
                    return 1;
                }
                return 0;
            }
        };
    }

    public static Comparator<ExponentArray> lexicographic() {
        return new Comparator<ExponentArray>(){

            @Override
            public int compare(ExponentArray o1, ExponentArray o2) {
                for (int i = 0; i < o1.fExponents.length; ++i) {
                    if (o1.fExponents[i] > o2.fExponents[i]) {
                        return -1;
                    }
                    if (o1.fExponents[i] >= o2.fExponents[i]) continue;
                    return 1;
                }
                return 0;
            }
        };
    }

    public ExponentArray(int length) {
        this(length, 0, 0L);
    }

    public ExponentArray(int length, int position) {
        this(length, position, 1L);
    }

    public ExponentArray(int length, int position, long value) {
        this.fExponents = new long[length];
        this.fExponents[position] = value;
    }

    protected ExponentArray clone() throws CloneNotSupportedException {
        ExponentArray e = (ExponentArray)super.clone();
        e.fExponents = new long[this.fExponents.length];
        for (int i = 0; i < this.fExponents.length; ++i) {
            e.fExponents[i] = this.fExponents[i];
        }
        return e;
    }

    @Override
    public int compareTo(ExponentArray o) {
        for (int i = 0; i < this.fExponents.length; ++i) {
            if (this.fExponents[i] < o.fExponents[i]) {
                return -1;
            }
            if (this.fExponents[i] <= o.fExponents[i]) continue;
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ExponentArray) {
            ExponentArray other = (ExponentArray)obj;
            return Arrays.equals(this.fExponents, other.fExponents);
        }
        return false;
    }

    public final long getExponent(int position) {
        return this.fExponents[position];
    }

    public long[] getExponents() {
        return this.fExponents;
    }

    public int hashCode() {
        return Arrays.hashCode(this.fExponents);
    }

    public long maximumDegree() {
        long maximum = 0L;
        for (int i = 0; i < this.fExponents.length; ++i) {
            if (this.fExponents[i] <= maximum) continue;
            maximum = this.fExponents[i];
        }
        return maximum;
    }

    protected void timesBy(ExponentArray exponents) {
        for (int i = 0; i < this.fExponents.length; ++i) {
            int n = i;
            this.fExponents[n] = this.fExponents[n] + exponents.fExponents[i];
        }
    }

    protected void timesBy(int position) {
        int n = position;
        this.fExponents[n] = this.fExponents[n] + 1L;
    }
}

