/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.patternmatching;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.Functors;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.IPatternObject;
import org.matheclipse.core.interfaces.IPatternSequence;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.ISymbol2IntMap;

public class PatternMap
implements ISymbol2IntMap,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5384429232269800438L;
    protected int fPriority = 0;
    private int fPatternCounter = 0;
    private boolean fRuleWithoutPattern = true;
    private ISymbol[] fSymbolsArray;
    private IExpr[] fPatternValuesArray;
    public static final int DEFAULT_RULE_PRIORITY = Integer.MAX_VALUE;

    protected PatternMap() {
        this(new IExpr[0]);
    }

    private PatternMap(IExpr[] exprArray) {
        this.fPatternValuesArray = exprArray;
    }

    protected void addPattern(Map<ISymbol, Integer> patternIndexMap, IPatternObject pattern) {
        this.fRuleWithoutPattern = false;
        ISymbol sym = pattern.getSymbol();
        if (sym != null) {
            Integer i = patternIndexMap.get(sym);
            if (i != null) {
                return;
            }
            patternIndexMap.put(sym, this.fPatternCounter++);
        }
    }

    protected void addSinglePattern(IPatternObject pattern) {
        this.fRuleWithoutPattern = false;
        ISymbol sym = pattern.getSymbol();
        if (sym != null) {
            this.fSymbolsArray = new ISymbol[1];
            this.fPatternValuesArray = new IExpr[1];
            this.fSymbolsArray[0] = sym;
        }
    }

    protected PatternMap clone() {
        PatternMap result = new PatternMap(null);
        result.fPatternValuesArray = new IExpr[this.fPatternValuesArray.length];
        System.arraycopy(this.fPatternValuesArray, 0, result.fPatternValuesArray, 0, this.fPatternValuesArray.length);
        result.fPriority = this.fPriority;
        result.fSymbolsArray = this.fSymbolsArray;
        result.fPatternCounter = this.fPatternCounter;
        result.fRuleWithoutPattern = this.fRuleWithoutPattern;
        return result;
    }

    protected IExpr[] copyPattern() {
        IExpr[] patternValuesArray = new IExpr[this.fPatternValuesArray.length];
        System.arraycopy(this.fPatternValuesArray, 0, patternValuesArray, 0, this.fPatternValuesArray.length);
        return patternValuesArray;
    }

    protected void copyPatternValuesFromPatternMatcher(PatternMap patternMap) {
        ISymbol[] symbolsArray = patternMap.fSymbolsArray;
        for (int i = 0; i < symbolsArray.length; ++i) {
            for (int j = 0; j < this.fSymbolsArray.length; ++j) {
                if (this.fSymbolsArray[j] != symbolsArray[i]) continue;
                this.fPatternValuesArray[j] = patternMap.fPatternValuesArray[i];
            }
        }
    }

    protected int determinePatterns(IExpr lhsPatternExpr) {
        this.fPriority = Integer.MAX_VALUE;
        if (lhsPatternExpr instanceof IAST) {
            TreeMap<ISymbol, Integer> patternIndexMap = new TreeMap<ISymbol, Integer>();
            this.determinePatternsRecursive(patternIndexMap, (IAST)lhsPatternExpr, 1);
            this.fSymbolsArray = new ISymbol[this.fPatternCounter];
            this.fPatternValuesArray = new IExpr[this.fPatternCounter];
            for (ISymbol sym : patternIndexMap.keySet()) {
                Integer indx = (Integer)patternIndexMap.get(sym);
                this.fSymbolsArray[indx.intValue()] = sym;
            }
        } else if (lhsPatternExpr instanceof IPatternObject) {
            this.addSinglePattern((IPatternObject)((Object)lhsPatternExpr));
        }
        return this.fPriority;
    }

    private int determinePatternsRecursive(Map<ISymbol, Integer> patternIndexMap, IAST lhsPatternExpr, int treeLevel) {
        IAST ast = lhsPatternExpr;
        int listEvalFlags = 0;
        for (int i = 0; i < ast.size(); ++i) {
            IExpr temp = (IExpr)ast.get(i);
            if (temp.isAST()) {
                listEvalFlags |= this.determinePatternsRecursive(patternIndexMap, (IAST)temp, treeLevel + 1);
                this.fPriority -= 11;
                continue;
            }
            if (temp instanceof IPatternObject) {
                if (temp.isPattern()) {
                    IPattern pat = (IPattern)temp;
                    this.addPattern(patternIndexMap, pat);
                    if (pat.isPatternDefault()) {
                        listEvalFlags |= 4;
                        this.fPriority -= 2;
                        continue;
                    }
                    listEvalFlags |= 1;
                    this.fPriority -= 5;
                    continue;
                }
                if (!temp.isPatternSequence()) continue;
                this.addPattern(patternIndexMap, (IPatternSequence)temp);
                listEvalFlags |= 2;
                --this.fPriority;
                continue;
            }
            this.fPriority -= 50 - treeLevel;
        }
        ast.setEvalFlags(listEvalFlags);
        return listEvalFlags &= 0xFFFB;
    }

    @Override
    public int get(ISymbol key) {
        if (key != null) {
            for (int i = 0; i < this.fSymbolsArray.length; ++i) {
                if (!this.fSymbolsArray[i].equals(key)) continue;
                return i;
            }
        }
        return -1;
    }

    public int getPriority() {
        return this.fPriority;
    }

    private Map<ISymbol, IExpr> getRulesMap() {
        IdentityHashMap<ISymbol, IExpr> rulesMap = new IdentityHashMap<ISymbol, IExpr>(this.fSymbolsArray.length * 2);
        for (int i = 0; i < this.fSymbolsArray.length; ++i) {
            if (this.fPatternValuesArray[i] == null) continue;
            rulesMap.put(this.fSymbolsArray[i], this.fPatternValuesArray[i]);
        }
        return rulesMap;
    }

    protected IExpr getValue(int index) {
        if (index < this.fPatternValuesArray.length) {
            return this.fPatternValuesArray[index];
        }
        return null;
    }

    protected IExpr getValue(IPatternObject pattern) {
        int indx = this.get(pattern.getSymbol());
        return indx >= 0 ? this.fPatternValuesArray[indx] : null;
    }

    protected List<IExpr> getValuesAsList() {
        ArrayList<IExpr> args = new ArrayList<IExpr>(this.fPatternValuesArray.length);
        for (int i = 0; i < this.fPatternValuesArray.length; ++i) {
            IExpr arg = this.fPatternValuesArray[i];
            if (arg == null) {
                return null;
            }
            args.add(arg);
        }
        return args;
    }

    protected void initPattern() {
        Arrays.fill(this.fPatternValuesArray, null);
    }

    protected boolean isAllPatternsAssigned() {
        if (this.fPatternValuesArray != null) {
            for (int i = 0; i < this.fPatternValuesArray.length; ++i) {
                if (this.fPatternValuesArray[i] != null) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.fSymbolsArray.length > 0;
    }

    protected boolean isRuleWithoutPatterns() {
        return this.fRuleWithoutPattern;
    }

    protected void resetPattern(IExpr[] patternValuesArray) {
        System.arraycopy(patternValuesArray, 0, this.fPatternValuesArray, 0, this.fPatternValuesArray.length);
    }

    protected void setValue(IPatternObject pattern, IExpr expr) {
        int indx = this.get(pattern.getSymbol());
        if (indx >= 0) {
            this.fPatternValuesArray[indx] = expr;
        }
    }

    @Override
    public int size() {
        return this.fSymbolsArray.length;
    }

    protected IExpr substitutePatternSymbols(IExpr expression) {
        if (this.fPatternValuesArray != null) {
            return F.subst(expression, Functors.rules(this.getRulesMap()));
        }
        return expression;
    }
}

