/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.patternmatching;

import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.patternmatching.AbstractHashedPatternRules;
import org.matheclipse.core.patternmatching.DownRulesData;

public class HashedPatternRules
extends AbstractHashedPatternRules {
    final IExpr fCondition;
    final IExpr fRHS;

    public HashedPatternRules(IExpr lhsPattern1, IExpr lhsPattern2, IExpr rhsResult, boolean defaultHashCode) {
        this(lhsPattern1, lhsPattern2, rhsResult, null, defaultHashCode);
    }

    public HashedPatternRules(IExpr lhsPattern1, IExpr lhsPattern2, IExpr rhsResult, IExpr condition, boolean defaultHashCode) {
        super(lhsPattern1, lhsPattern2, defaultHashCode);
        this.fCondition = condition;
        this.fRHS = rhsResult;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HashedPatternRules) {
            HashedPatternRules other = (HashedPatternRules)obj;
            if (this.hash1 != other.hash1) {
                return false;
            }
            if (this.hash2 != other.hash2) {
                return false;
            }
            if (this.fLHSPattern1 == null ? other.fLHSPattern1 != null : !this.fLHSPattern1.equals(other.fLHSPattern1)) {
                return false;
            }
            if (this.fLHSPattern2 == null ? other.fLHSPattern2 != null : !this.fLHSPattern2.equals(other.fLHSPattern2)) {
                return false;
            }
            if (this.fCondition == null ? other.fCondition != null : !this.fCondition.equals(other.fCondition)) {
                return false;
            }
            return !(this.fRHS == null ? other.fRHS != null : !this.fRHS.equals(other.fRHS));
        }
        return false;
    }

    public IExpr getRHS() {
        return this.fRHS;
    }

    public IExpr getCondition() {
        return this.fCondition;
    }

    public DownRulesData getRulesData() {
        if (this.fRulesData == null) {
            this.fRulesData = new DownRulesData();
            if (this.fCondition != null) {
                this.fRulesData.putDownRule(F.SetDelayed, false, F.List(this.fLHSPattern1, this.fLHSPattern2), F.Condition(this.fRHS, this.fCondition));
            } else {
                this.fRulesData.putDownRule(F.SetDelayed, false, F.List(this.fLHSPattern1, this.fLHSPattern2), this.fRHS);
            }
        }
        return this.fRulesData;
    }

    @Override
    public IExpr evalDownRule(IExpr e1, IExpr e2) {
        return this.getRulesData().evalDownRule(F.List(e1, e2));
    }
}

