/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.patternmatching;

import org.matheclipse.core.generic.BinaryFunctorImpl;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.patternmatching.AbstractHashedPatternRules;
import org.matheclipse.core.patternmatching.PatternMatcher;

public class HashedPatternFunction
extends AbstractHashedPatternRules {
    final BinaryFunctorImpl<IExpr> function;

    public HashedPatternFunction(IExpr lhsPattern1, IExpr lhsPattern2, BinaryFunctorImpl<IExpr> function, boolean defaultHashCode) {
        super(lhsPattern1, lhsPattern2, defaultHashCode);
        this.function = function;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HashedPatternFunction) {
            HashedPatternFunction other = (HashedPatternFunction)obj;
            if (this.hash1 != other.hash1) {
                return false;
            }
            if (this.hash2 != other.hash2) {
                return false;
            }
            if (this.fLHSPattern1 == null ? other.fLHSPattern1 != null : !this.fLHSPattern1.equals(other.fLHSPattern1)) {
                return false;
            }
            return !(this.fLHSPattern2 == null ? other.fLHSPattern2 != null : !this.fLHSPattern2.equals(other.fLHSPattern2));
        }
        return false;
    }

    public BinaryFunctorImpl<IExpr> getFunction() {
        return this.function;
    }

    @Override
    public IExpr evalDownRule(IExpr e1, IExpr e2) {
        PatternMatcher pm1 = new PatternMatcher(this.fLHSPattern1);
        PatternMatcher pm2 = new PatternMatcher(this.fLHSPattern2);
        if (pm1.apply(e1) && pm2.apply(e2)) {
            IExpr v1 = pm1.getPatternValue0();
            IExpr v2 = pm2.getPatternValue0();
            return this.function.apply(v1, v2);
        }
        return null;
    }
}

