/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.patternmatching;

import com.google.common.collect.ArrayListMultimap;
import java.util.List;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.generic.BinaryFunctorImpl;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.patternmatching.AbstractHashedPatternRules;
import org.matheclipse.core.patternmatching.HashedPatternFunction;
import org.matheclipse.core.patternmatching.HashedPatternRules;
import org.matheclipse.core.visit.HashValueVisitor;
import org.matheclipse.parser.client.Parser;
import org.matheclipse.parser.client.SyntaxError;
import org.matheclipse.parser.client.ast.ASTNode;

public class HashedOrderlessMatcher {
    private ArrayListMultimap<Integer, AbstractHashedPatternRules> fHashRuleMap = ArrayListMultimap.create();
    private ArrayListMultimap<Integer, AbstractHashedPatternRules> fPatternHashRuleMap = ArrayListMultimap.create();

    public void defineHashRule(String lhs1Str, String lhs2Str, String rhsStr) throws SyntaxError {
        this.defineHashRule(lhs1Str, lhs2Str, rhsStr, null);
    }

    public void defineHashRule(String lhs1Str, String lhs2Str, BinaryFunctorImpl<IExpr> function) throws SyntaxError {
        Parser parser = new Parser();
        ASTNode parsedAST = parser.parse(lhs1Str);
        IExpr lhs1 = AST2Expr.CONST.convert(parsedAST);
        parsedAST = parser.parse(lhs2Str);
        IExpr lhs2 = AST2Expr.CONST.convert(parsedAST);
        this.defineHashRule(lhs1, lhs2, function);
    }

    public void defineHashRule(String lhs1Str, String lhs2Str, String rhsStr, String conditionStr) throws SyntaxError {
        Parser parser = new Parser();
        ASTNode parsedAST = parser.parse(lhs1Str);
        IExpr lhs1 = AST2Expr.CONST.convert(parsedAST);
        parsedAST = parser.parse(lhs2Str);
        IExpr lhs2 = AST2Expr.CONST.convert(parsedAST);
        parsedAST = parser.parse(rhsStr);
        IExpr rhs = AST2Expr.CONST.convert(parsedAST);
        IExpr condition = null;
        if (conditionStr != null) {
            parsedAST = parser.parse(conditionStr);
            condition = AST2Expr.CONST.convert(parsedAST);
        }
        this.defineHashRule(lhs1, lhs2, rhs, condition);
    }

    public void defineHashRule(IExpr lhs1, IExpr lhs2, IExpr rhs) {
        this.defineHashRule(lhs1, lhs2, rhs, null);
    }

    public void defineHashRule(IExpr lhs1, IExpr lhs2, IExpr rhs, IExpr condition) {
        HashedPatternRules hashRule = new HashedPatternRules(lhs1, lhs2, rhs, condition, true);
        this.fHashRuleMap.put((Object)hashRule.hashCode(), (Object)hashRule);
    }

    public void defineHashRule(IExpr lhs1, IExpr lhs2, BinaryFunctorImpl<IExpr> function) {
        HashedPatternFunction hashRule = new HashedPatternFunction(lhs1, lhs2, function, true);
        this.fHashRuleMap.put((Object)hashRule.hashCode(), (Object)hashRule);
    }

    public void definePatternHashRule(IExpr lhs1, IExpr lhs2, IExpr rhs) {
        this.definePatternHashRule(lhs1, lhs2, rhs, null);
    }

    public void definePatternHashRule(IExpr lhs1, IExpr lhs2, IExpr rhs, IExpr condition) {
        HashedPatternRules hashRule = new HashedPatternRules(lhs1, lhs2, rhs, condition, false);
        this.fPatternHashRuleMap.put((Object)hashRule.hashCode(), (Object)hashRule);
    }

    public IAST evaluate(IAST orderlessAST) {
        int[] hashValues = new int[orderlessAST.size() - 1];
        if (!this.fPatternHashRuleMap.isEmpty()) {
            HashValueVisitor v = new HashValueVisitor();
            for (int i = 0; i < hashValues.length; ++i) {
                hashValues[i] = ((IExpr)orderlessAST.get(i + 1)).accept(v);
                v.setUp();
            }
            IAST result = HashedOrderlessMatcher.evaluateHashedValues(orderlessAST, this.fPatternHashRuleMap, hashValues);
            if (result != null) {
                return result;
            }
        }
        if (!this.fHashRuleMap.isEmpty()) {
            for (int i = 0; i < hashValues.length; ++i) {
                hashValues[i] = ((IExpr)orderlessAST.get(i + 1)).head().hashCode();
            }
            return HashedOrderlessMatcher.evaluateHashedValues(orderlessAST, this.fHashRuleMap, hashValues);
        }
        return null;
    }

    private static IAST evaluateHashedValues(IAST orderlessAST, ArrayListMultimap<Integer, AbstractHashedPatternRules> hashRuleMap, int[] hashValues) {
        int i;
        boolean evaled = false;
        IAST result = orderlessAST.copyHead();
        block0: for (i = 0; i < hashValues.length - 1; ++i) {
            if (hashValues[i] == 0) continue;
            for (int j = i + 1; j < hashValues.length; ++j) {
                List hashRuleList;
                if (hashValues[j] == 0 || (hashRuleList = hashRuleMap.get((Object)AbstractHashedPatternRules.calculateHashcode(hashValues[i], hashValues[j]))) == null) continue;
                for (AbstractHashedPatternRules hashRule : hashRuleList) {
                    if (!hashRule.isPattern1() && !hashRule.isPattern2()) {
                        if (hashValues[i] != hashRule.getHash1() || hashValues[j] != hashRule.getHash2()) {
                            if (hashValues[i] != hashRule.getHash2() || hashValues[j] != hashRule.getHash1() || !HashedOrderlessMatcher.updateHashValues(result, orderlessAST, hashRule, hashValues, j, i)) continue;
                            evaled = true;
                            continue block0;
                        }
                        if (HashedOrderlessMatcher.updateHashValues(result, orderlessAST, hashRule, hashValues, i, j)) {
                            evaled = true;
                            continue block0;
                        }
                        if (hashValues[i] != hashRule.getHash2() || hashValues[j] != hashRule.getHash1() || !HashedOrderlessMatcher.updateHashValues(result, orderlessAST, hashRule, hashValues, j, i)) continue;
                        evaled = true;
                        continue block0;
                    }
                    if (HashedOrderlessMatcher.updateHashValues(result, orderlessAST, hashRule, hashValues, i, j)) {
                        evaled = true;
                        continue block0;
                    }
                    if (!HashedOrderlessMatcher.updateHashValues(result, orderlessAST, hashRule, hashValues, j, i)) continue;
                    evaled = true;
                    continue block0;
                }
            }
        }
        if (evaled) {
            for (i = 0; i < hashValues.length; ++i) {
                if (hashValues[i] == 0) continue;
                result.add(orderlessAST.get(i + 1));
            }
            return result;
        }
        return null;
    }

    private static boolean updateHashValues(IAST result, IAST orderlessAST, AbstractHashedPatternRules hashRule, int[] hashValues, int i, int j) {
        IExpr temp = hashRule.evalDownRule((IExpr)orderlessAST.get(i + 1), (IExpr)orderlessAST.get(j + 1));
        if (temp != null) {
            hashValues[i] = 0;
            hashValues[j] = 0;
            result.add(temp);
            return true;
        }
        return false;
    }
}

