/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.patternmatching;

import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.patternmatching.DownRulesData;
import org.matheclipse.core.patternmatching.HashedPatternRules;
import org.matheclipse.core.visit.HashValueVisitor;

public abstract class AbstractHashedPatternRules {
    protected int hash1;
    protected int hash2;
    protected int hashSum;
    protected DownRulesData fRulesData = null;
    protected final IExpr fLHSPattern1;
    protected final IExpr fLHSPattern2;

    public AbstractHashedPatternRules(IExpr lhsPattern1, IExpr lhsPattern2, boolean defaultHashCode) {
        this.fLHSPattern1 = lhsPattern1;
        this.fLHSPattern2 = lhsPattern2;
        if (defaultHashCode) {
            this.hash1 = lhsPattern1.head().hashCode();
            this.hash2 = lhsPattern2.head().hashCode();
        } else {
            HashValueVisitor v = new HashValueVisitor();
            this.hash1 = lhsPattern1.accept(v);
            v.setUp();
            this.hash2 = lhsPattern2.accept(v);
            v.setUp();
        }
    }

    public int hashCode() {
        if (this.hashSum == 0) {
            this.hashSum = AbstractHashedPatternRules.calculateHashcode(this.hash1, this.hash2);
        }
        return this.hashSum;
    }

    public static int calculateHashcode(int h1, int h2) {
        return 31 * (h1 + h2);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HashedPatternRules) {
            HashedPatternRules other = (HashedPatternRules)obj;
            if (this.hash1 != other.hash1) {
                return false;
            }
            if (this.hash2 != other.hash2) {
                return false;
            }
            if (this.fLHSPattern1 == null ? other.fLHSPattern1 != null : !this.fLHSPattern1.equals(other.fLHSPattern1)) {
                return false;
            }
            return !(this.fLHSPattern2 == null ? other.fLHSPattern2 != null : !this.fLHSPattern2.equals(other.fLHSPattern2));
        }
        return false;
    }

    public int getHash1() {
        return this.hash1;
    }

    public int getHash2() {
        return this.hash2;
    }

    public boolean isPattern1() {
        return this.fLHSPattern1.isPattern();
    }

    public boolean isPattern2() {
        return this.fLHSPattern2.isPattern();
    }

    public abstract IExpr evalDownRule(IExpr var1, IExpr var2);
}

