/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.list.algorithms;

import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.ExprComparator;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class EvaluationSupport {
    public static IAST flatten(IAST ast) {
        IAST result;
        if ((ast.getEvalFlags() & 0x100) == 256) {
            return null;
        }
        ISymbol sym = ast.topHead();
        if (ast.isAST(sym) && EvaluationSupport.flatten(sym, ast, result = ast.copyHead())) {
            result.addEvalFlags(256);
            return result;
        }
        ast.setEvalFlags(256);
        return null;
    }

    public static boolean flatten(ISymbol head, IAST sublist, IAST result) {
        boolean isEvaled = false;
        int astSize = sublist.size();
        for (int i = 1; i < astSize; ++i) {
            IExpr expr = (IExpr)sublist.get(i);
            if (expr.isAST(head)) {
                isEvaled = true;
                EvaluationSupport.flatten(head, (IAST)expr, result);
                continue;
            }
            result.add(expr);
        }
        return isEvaled;
    }

    public static boolean flatten(ISymbol head, IAST sublist, IAST result, int recursionCounter, int level) {
        boolean isEvaled = false;
        int astSize = sublist.size();
        for (int i = 1; i < astSize; ++i) {
            IExpr expr = (IExpr)sublist.get(i);
            if (expr.isAST(head) && recursionCounter < level) {
                isEvaled = true;
                EvaluationSupport.flatten(head, (IAST)expr, result, recursionCounter + 1, level);
                continue;
            }
            result.add(expr);
        }
        return isEvaled;
    }

    public static final void sort(IAST ast) {
        if ((ast.getEvalFlags() & 0x200) == 512) {
            return;
        }
        int astSize = ast.size();
        if (astSize > 2) {
            switch (astSize) {
                case 3: {
                    if (ast.arg1().compareTo(ast.arg2()) <= 0) break;
                    IExpr temp = ast.arg2();
                    ast.set(2, ast.arg1());
                    ast.set(1, temp);
                    break;
                }
                case 4: {
                    IExpr temp;
                    if (((IExpr)ast.get(1)).compareTo(ast.arg2()) > 0) {
                        temp = ast.arg2();
                        ast.set(2, ast.arg1());
                        ast.set(1, temp);
                    }
                    if (ast.arg2().compareTo(ast.arg3()) <= 0) break;
                    temp = ast.arg3();
                    ast.set(3, ast.get(2));
                    ast.set(2, temp);
                    if (((IExpr)ast.get(1)).compareTo(ast.arg2()) <= 0) break;
                    temp = ast.arg2();
                    ast.set(2, ast.arg1());
                    ast.set(1, temp);
                    break;
                }
                default: {
                    ast.args().sort(ExprComparator.CONS);
                }
            }
        }
        ast.addEvalFlags(512);
    }

    public static final void sort(IAST list, ExprComparator comparator) {
        list.args().sort(comparator);
    }

    public static IAST threadList(IAST list, int listLength, int headOffset) {
        IAST res0 = F.ast(F.List, listLength, true);
        int listSize = list.size();
        for (int j = headOffset; j < listLength + headOffset; ++j) {
            IAST res1 = F.ast(list.head(), listSize - headOffset, true);
            for (int i = headOffset; i < listSize; ++i) {
                if (((IExpr)list.get(i)).isList()) {
                    IAST arg = (IAST)list.get(i);
                    res1.set(i, arg.get(j));
                    continue;
                }
                res1.set(i, list.get(i));
            }
            res0.set(j, res1);
        }
        return res0;
    }
}

