/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.interfaces;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import edu.jas.structure.GcdRingElem;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;
import org.matheclipse.core.visit.IVisitorLong;

public interface IExpr
extends Comparable<IExpr>,
GcdRingElem<IExpr>,
Serializable {
    public static final int ASTID = 512;
    public static final int COMPLEXID = 32;
    public static final int DOUBLECOMPLEXID = 4;
    public static final int DOUBLEID = 2;
    public static final int FRACTIONID = 16;
    public static final int INTEGERID = 8;
    public static final int METHODSYMBOLID = 1024;
    public static final int PATTERNID = 256;
    public static final int STRINGID = 64;
    public static final int SYMBOLID = 128;

    public <T> T accept(IVisitor<T> var1);

    public boolean accept(IVisitorBoolean var1);

    public int accept(IVisitorInt var1);

    public long accept(IVisitorLong var1);

    public IExpr and(IExpr var1);

    public IExpr apply(IExpr ... var1);

    public IExpr apply(List<? extends IExpr> var1);

    public Object asType(Class var1);

    @Override
    public int compareTo(IExpr var1);

    @Override
    public IExpr divide(IExpr var1);

    public IExpr evaluate(EvalEngine var1);

    public String fullFormString();

    public IExpr getAt(int var1);

    public IExpr head();

    public int hierarchy();

    public String internalFormString(boolean var1, int var2);

    @Override
    public IExpr inverse();

    public boolean isAnd();

    public boolean isArcCos();

    public boolean isArcCosh();

    public boolean isArcSin();

    public boolean isArcSinh();

    public boolean isArcTan();

    public boolean isArcTanh();

    public boolean isAST();

    public boolean isAST(IExpr var1);

    public boolean isAST(IExpr var1, int var2);

    public boolean isAST(IExpr var1, int var2, IExpr ... var3);

    public boolean isAST(String var1);

    public boolean isAST(String var1, int var2);

    public boolean isASTSizeGE(IExpr var1, int var2);

    public boolean isAtom();

    public boolean isComplex();

    public boolean isComplexInfinity();

    public boolean isComplexNumeric();

    public boolean isCondition();

    public boolean isConstant();

    public boolean isCos();

    public boolean isCosh();

    public boolean isDirectedInfinity();

    public boolean isE();

    public boolean isFalse();

    public boolean isFlatAST();

    public boolean isFraction();

    public boolean isFree(IExpr var1);

    public boolean isFree(IExpr var1, boolean var2);

    public boolean isFree(Predicate<IExpr> var1, boolean var2);

    public boolean isFunction();

    public boolean isGEOrdered(IExpr var1);

    public boolean isGTOrdered(IExpr var1);

    public boolean isIndeterminate();

    public boolean isInfinity();

    public boolean isInteger();

    public boolean isLEOrdered(IExpr var1);

    public boolean isList();

    public boolean isListOfLists();

    public boolean isLog();

    public boolean isLTOrdered(IExpr var1);

    public int[] isMatrix();

    public boolean isMember(IExpr var1, boolean var2);

    public boolean isMember(Predicate<IExpr> var1, boolean var2);

    public boolean isMinusOne();

    public boolean isModule();

    public boolean isNegative();

    public boolean isNegativeInfinity();

    public boolean isNot();

    public boolean isNumber();

    public boolean isNumEqualInteger(IInteger var1) throws ArithmeticException;

    public boolean isNumeric();

    public boolean isNumericFunction();

    public boolean isNumericMode();

    public boolean isNumIntValue();

    public boolean isOne();

    @Override
    public boolean isONE();

    public boolean isOr();

    public boolean isOrderlessAST();

    public boolean isPattern();

    public boolean isPatternDefault();

    public boolean isPatternExpr();

    public boolean isPatternSequence();

    public boolean isPi();

    public boolean isPlus();

    public boolean isPolynomial(ISymbol var1);

    public boolean isPolynomial(IAST var1);

    public boolean isPolynomialOfMaxDegree(ISymbol var1, long var2);

    public boolean isPositive();

    public boolean isPower();

    public boolean isRational();

    public boolean isRealFunction();

    public boolean isRuleAST();

    public boolean isSame(IExpr var1);

    public boolean isSame(IExpr var1, double var2);

    public boolean isSequence();

    public boolean isSignedNumber();

    public boolean isSin();

    public boolean isSinh();

    public boolean isSlot();

    public boolean isSlotSequence();

    public boolean isSymbol();

    public boolean isTan();

    public boolean isTanh();

    public boolean isTimes();

    public boolean isTrue();

    public boolean isValue();

    public int isVector();

    public boolean isZero();

    @Override
    public boolean isZERO();

    public long leafCount();

    public List<IExpr> leaves();

    public IExpr minus(IExpr var1);

    public IExpr mod(IExpr var1);

    @Override
    public IExpr multiply(IExpr var1);

    public IExpr negative();

    public IExpr opposite();

    public IExpr or(IExpr var1);

    public IExpr plus(IExpr var1);

    public IExpr power(IExpr var1);

    public IExpr power(int var1);

    @Nullable
    public IExpr replaceAll(Function<IExpr, IExpr> var1);

    @Nullable
    public IExpr replaceAll(IAST var1);

    public IExpr replacePart(IAST var1);

    public IExpr replaceRepeated(Function<IExpr, IExpr> var1);

    public IExpr replaceRepeated(IAST var1);

    public IExpr replaceSlots(IAST var1);

    @Override
    @Deprecated
    public int signum();

    public IExpr times(IExpr var1);

    public ISymbol topHead();

    public IExpr variables2Slots(Map<IExpr, IExpr> var1, List<IExpr> var2);
}

