/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.generic.combinatoric;

import java.util.Iterator;
import org.matheclipse.core.generic.combinatoric.KSubsetsIterable;
import org.matheclipse.core.interfaces.IAST;

public class KSubsetsList
implements Iterator<IAST>,
Iterable<IAST> {
    private final IAST fList;
    private final IAST fResultList;
    private final int fOffset;
    private final Iterator<int[]> fIterable;
    private final int fK;

    public KSubsetsList(Iterator<int[]> iterable, IAST list, int k, IAST resultList) {
        this(iterable, list, k, resultList, 0);
    }

    public KSubsetsList(Iterator<int[]> iterable, IAST list, int k, IAST resultList, int offset) {
        this.fIterable = iterable;
        this.fList = list;
        this.fK = k;
        this.fResultList = resultList;
        this.fOffset = offset;
    }

    public static KSubsetsList createKSubsets(IAST list, int k, IAST resultList, int offset) {
        return new KSubsetsList(new KSubsetsIterable(list.size() - offset, k), list, k, resultList, offset);
    }

    @Override
    public IAST next() {
        int[] j = this.fIterable.next();
        if (j == null) {
            return null;
        }
        IAST temp = this.fResultList.clone();
        for (int i = 0; i < this.fK; ++i) {
            temp.add(this.fList.get(j[i] + this.fOffset));
        }
        return temp;
    }

    @Override
    public boolean hasNext() {
        return this.fIterable.hasNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<IAST> iterator() {
        return this;
    }
}

