/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.generic.combinatoric;

import java.util.Iterator;

public class KSubsetsIterable
implements Iterator<int[]>,
Iterable<int[]> {
    private final int n;
    private final int k;
    private final int[] x;
    private long bin;
    private boolean first;

    public KSubsetsIterable(int len, int parts) {
        this.n = len;
        this.k = parts;
        this.x = new int[this.n];
        for (int a = 0; a < this.n; ++a) {
            this.x[a] = a;
        }
        this.bin = KSubsetsIterable.binomial(this.n, this.k);
        this.first = true;
    }

    @Override
    public int[] next() {
        if (this.bin-- == 0L) {
            return null;
        }
        if (this.first) {
            this.first = false;
            return this.x;
        }
        int i = this.k - 1;
        while (this.x[i] == this.n - this.k + i) {
            --i;
        }
        this.x[i] = this.x[i] + 1;
        for (int j = i + 1; j < this.n; ++j) {
            this.x[j] = this.x[j - 1] + 1;
        }
        return this.x;
    }

    public static long binomial(long n, long k) {
        long bin = 1L;
        long kSub = k;
        if (kSub > n / 2L) {
            kSub = n - kSub;
        }
        for (long i = 1L; i <= kSub; ++i) {
            bin = bin * (n - i + 1L) / i;
        }
        return bin;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<int[]> iterator() {
        return this;
    }
}

