/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.generic;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IEvaluator;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.ISymbol;

public class Predicates {
    private Predicates() {
    }

    public static Predicate<IExpr> isTrue(IExpr expr) {
        return new IsUnaryTrue<IExpr>(EvalEngine.get(), expr);
    }

    public static Predicate<IExpr> isTrue(EvalEngine engine, IExpr head) {
        IEvaluator eval;
        if (head.isSymbol() && (eval = ((ISymbol)head).getEvaluator()) != null && eval instanceof Predicate) {
            return (Predicate)((Object)eval);
        }
        return new IsUnaryTrue<IExpr>(engine, head);
    }

    public static Predicate<IExpr> in(IAST ast) {
        return new InASTPredicate(ast);
    }

    public static Predicate<IExpr> in(IExpr expr) {
        return new InASTPredicate(F.List(expr));
    }

    public static Predicate<IExpr> isPattern() {
        return new Predicate<IExpr>(){

            @Override
            public boolean apply(IExpr input) {
                return input instanceof IPattern;
            }
        };
    }

    public static Predicate<IExpr> isNumber() {
        return new Predicate<IExpr>(){

            @Override
            public boolean apply(IExpr input) {
                return input.isNumber();
            }
        };
    }

    public static Predicate<IExpr> isNumeric() {
        return new Predicate<IExpr>(){

            @Override
            public boolean apply(IExpr input) {
                return input.isNumeric();
            }
        };
    }

    public static Predicate<IExpr> isSignedNumber() {
        return new Predicate<IExpr>(){

            @Override
            public boolean apply(IExpr input) {
                return input.isSignedNumber();
            }
        };
    }

    public static Predicate<IExpr> isAST(final ISymbol[] heads) {
        return new Predicate<IExpr>(){

            @Override
            public boolean apply(IExpr input) {
                for (int i = 0; i < heads.length; ++i) {
                    if (!input.isAST(heads[i])) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private static class IsUnaryTrue<E extends IExpr>
    implements Predicate<E> {
        protected final EvalEngine fEngine;
        protected final IAST fAST;

        public IsUnaryTrue(EvalEngine engine, IExpr head) {
            this.fEngine = engine;
            this.fAST = F.ast(head, 1, false);
        }

        @Override
        public boolean apply(IExpr arg) {
            IAST ast = this.fAST.clone();
            ast.add(arg);
            return this.fEngine.evalTrue(ast);
        }
    }

    private static class InASTPredicate
    implements Predicate<IExpr>,
    Serializable {
        private final IAST target;
        private static final long serialVersionUID = 0L;

        private InASTPredicate(IAST target) {
            this.target = Preconditions.checkNotNull(target);
        }

        @Override
        public boolean apply(IExpr t) {
            for (IExpr expr : this.target) {
                if (!expr.equals(t)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof InASTPredicate) {
                InASTPredicate that = (InASTPredicate)obj;
                return this.target.equals(that.target);
            }
            return false;
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        public String toString() {
            return "In(" + this.target + ")";
        }
    }
}

