/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.generic;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.patternmatching.PatternMatcherAndEvaluator;
import org.matheclipse.parser.client.Parser;
import org.matheclipse.parser.client.ast.ASTNode;

public class Functors {
    private static Predicate<IExpr> PATTERNQ_PREDICATE = new Predicate<IExpr>(){

        @Override
        public boolean apply(IExpr input) {
            return input.isPattern();
        }
    };

    public static Function<IExpr, IExpr> scan(@Nonnull IAST ast, @Nonnull Collection<? super IExpr> resultCollection) {
        return new ScanFunctor(ast, resultCollection);
    }

    public static Function<IExpr, IExpr> append(@Nonnull IAST ast) {
        return new AppendFunctor(ast);
    }

    public static Function<IExpr, IExpr> evalArg(@Nonnull IAST ast, int position, @Nonnull EvalEngine engine) {
        return new EvalArgFunctor(ast, position, engine);
    }

    public static Function<IExpr, IExpr> apply(@Nonnull IExpr expr) {
        return new ApplyFunctor(expr);
    }

    public static Function<IExpr, IExpr> collect(@Nonnull Collection<? super IExpr> resultCollection) {
        return new CollectFunctor(resultCollection);
    }

    public static Function<IExpr, IExpr> constant(@Nonnull IExpr expr) {
        return new ConstantFunctor(expr);
    }

    public static Function<IExpr, IExpr> replaceAll(@Nonnull IAST ast, @Nonnull IExpr lhs) {
        return new ReplaceAllFunctor(ast, lhs);
    }

    public static Function<IExpr, IExpr> replace1st(@Nonnull IAST ast) {
        return new ReplaceArgFunctor(ast, 1);
    }

    public static Function<IExpr, IExpr> replace2nd(@Nonnull IAST ast) {
        return new ReplaceArgFunctor(ast, 2);
    }

    public static Function<IExpr, IExpr> replaceArg(@Nonnull IAST ast, int position) {
        return new ReplaceArgFunctor(ast, position);
    }

    public static Function<IExpr, IExpr> rules(Map<? extends IExpr, ? extends IExpr> rulesMap) {
        return new RulesFunctor(rulesMap);
    }

    public static Function<IExpr, IExpr> rules(@Nonnull String[] strRules) throws WrongArgumentType {
        IAST astRules = F.List();
        Parser parser = new Parser();
        EvalEngine engine = EvalEngine.get();
        for (String str : strRules) {
            ASTNode parsedAST = parser.parse(str);
            IExpr expr = AST2Expr.CONST.convert(parsedAST, engine);
            expr = engine.evaluate(expr);
            astRules.add(expr);
        }
        return Functors.rules(astRules);
    }

    public static Function<IExpr, IExpr> rules(@Nonnull IAST astRules) throws WrongArgumentType {
        HashMap<IExpr, IExpr> equalRules = new HashMap<IExpr, IExpr>();
        ArrayList<PatternMatcherAndEvaluator> matchers = new ArrayList<PatternMatcherAndEvaluator>();
        if (astRules.isList()) {
            for (IExpr expr : astRules) {
                if (expr.isRuleAST()) {
                    IAST rule = (IAST)expr;
                    Functors.addRuleToCollection(equalRules, matchers, rule);
                    continue;
                }
                throw new WrongArgumentType(astRules, astRules, -1, "Rule expression (x->y) expected: ");
            }
        } else if (astRules.isRuleAST()) {
            Functors.addRuleToCollection(equalRules, matchers, astRules);
        } else {
            throw new WrongArgumentType(astRules, astRules, -1, "Rule expression (x->y) expected: ");
        }
        if (matchers.size() > 0) {
            return new RulesPatternFunctor(equalRules, matchers);
        }
        return Functors.rules(equalRules);
    }

    private static void addRuleToCollection(Map<IExpr, IExpr> equalRules, List<PatternMatcherAndEvaluator> matchers, IAST rule) {
        if (((IExpr)rule.get(1)).isFree(PATTERNQ_PREDICATE, true)) {
            if (((IExpr)rule.get(1)).isOrderlessAST() || ((IExpr)rule.get(1)).isFlatAST()) {
                matchers.add(new PatternMatcherAndEvaluator(F.SetDelayed, (IExpr)rule.get(1), (IExpr)rule.get(2)));
                return;
            }
            equalRules.put((IExpr)rule.get(1), (IExpr)rule.get(2));
        } else {
            matchers.add(new PatternMatcherAndEvaluator(F.SetDelayed, (IExpr)rule.get(1), (IExpr)rule.get(2)));
        }
    }

    private Functors() {
    }

    private static class ScanFunctor
    implements Function<IExpr, IExpr> {
        protected final IAST fAST;
        protected Collection<? super IExpr> resultCollection;

        public ScanFunctor(IAST ast, Collection<? super IExpr> resultCollection) {
            this.fAST = ast;
            this.resultCollection = resultCollection;
        }

        @Override
        public IExpr apply(IExpr arg) {
            IAST ast = this.fAST.clone();
            ast.add(arg);
            this.resultCollection.add(ast);
            return null;
        }
    }

    private static class RulesPatternFunctor
    implements Function<IExpr, IExpr> {
        private final Map<IExpr, IExpr> fEqualRules;
        private final List<PatternMatcherAndEvaluator> fMatchers;

        public RulesPatternFunctor(Map<IExpr, IExpr> equalRules, List<PatternMatcherAndEvaluator> matchers) {
            this.fEqualRules = equalRules;
            this.fMatchers = matchers;
        }

        @Override
        public IExpr apply(IExpr arg) {
            IExpr temp = this.fEqualRules.get(arg);
            if (temp != null) {
                return temp;
            }
            for (int i = 0; i < this.fMatchers.size(); ++i) {
                temp = this.fMatchers.get(i).eval(arg);
                if (temp == null) continue;
                return temp;
            }
            return null;
        }
    }

    private static class RulesFunctor
    implements Function<IExpr, IExpr> {
        private final Map<? extends IExpr, ? extends IExpr> fEqualRules;

        public RulesFunctor(Map<? extends IExpr, ? extends IExpr> rulesMap) {
            this.fEqualRules = rulesMap;
        }

        @Override
        public IExpr apply(IExpr arg) {
            return this.fEqualRules.get(arg);
        }
    }

    private static class ReplaceAllFunctor
    implements Function<IExpr, IExpr> {
        private final IAST fConstant;
        private final IExpr fLHS;

        public ReplaceAllFunctor(IAST ast, IExpr lhs) {
            this.fConstant = ast;
            this.fLHS = lhs;
        }

        @Override
        public IExpr apply(IExpr arg) {
            return this.fConstant.replaceAll(F.Rule(this.fLHS, arg));
        }
    }

    private static class ReplaceArgFunctor
    implements Function<IExpr, IExpr> {
        private final IAST fConstant;
        private final int fPosition;

        public ReplaceArgFunctor(IAST ast, int position) {
            this.fConstant = ast;
            this.fPosition = position;
        }

        @Override
        public IExpr apply(IExpr arg) {
            IAST ast = this.fConstant.clone();
            ast.set(this.fPosition, arg);
            return ast;
        }
    }

    private static class ConstantFunctor
    implements Function<IExpr, IExpr> {
        final IExpr fConstant;

        public ConstantFunctor(IExpr expr) {
            this.fConstant = expr;
        }

        @Override
        public IExpr apply(IExpr arg) {
            return this.fConstant;
        }
    }

    private static class CollectFunctor
    implements Function<IExpr, IExpr> {
        protected Collection<? super IExpr> resultCollection;

        public CollectFunctor(Collection<? super IExpr> resultCollection) {
            this.resultCollection = resultCollection;
        }

        @Override
        public IExpr apply(IExpr arg) {
            this.resultCollection.add(arg);
            return null;
        }
    }

    private static class EvalArgFunctor
    implements Function<IExpr, IExpr> {
        EvalEngine fEngine;
        IAST fAST;
        int fPosition;

        public EvalArgFunctor(IAST ast, int position, EvalEngine engine) {
            this.fEngine = engine;
            this.fAST = ast;
            this.fPosition = position;
        }

        @Override
        public IExpr apply(IExpr arg) {
            IAST ast = this.fAST.clone();
            ast.set(this.fPosition, arg);
            return this.fEngine.evaluate(ast);
        }
    }

    private static class ApplyFunctor
    implements Function<IExpr, IExpr> {
        final IExpr fConstant;

        public ApplyFunctor(IExpr constant) {
            this.fConstant = constant;
        }

        @Override
        public IExpr apply(IExpr arg) {
            IAST result = null;
            if (arg.isAST()) {
                result = ((IAST)arg).clone();
                result.set(0, this.fConstant);
            }
            return result;
        }
    }

    private static class AppendFunctor
    implements Function<IExpr, IExpr> {
        protected final IAST fAST;

        public AppendFunctor(IAST ast) {
            this.fAST = ast;
        }

        @Override
        public IExpr apply(IExpr arg) {
            IAST ast = this.fAST.clone();
            ast.add(arg);
            return ast;
        }
    }
}

