/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form.tex.reflection;

import org.matheclipse.core.form.tex.AbstractOperator;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.reflection.system.Apart;
import org.matheclipse.parser.client.operator.ASTNodeFactory;

public class Times
extends AbstractOperator {
    public static final int NO_SPECIAL_CALL = 0;
    public static final int PLUS_CALL = 1;
    public static Times CONST = new Times();

    public Times() {
        super(ASTNodeFactory.MMA_STYLE_FACTORY.get("Times").getPrecedence(), "\\,");
    }

    @Override
    public boolean convert(StringBuffer buf, IAST f, int precedence) {
        return this.convert(buf, f, precedence, 0);
    }

    public boolean convert(StringBuffer buf, IAST f, int precedence, int caller) {
        IExpr[] parts = Apart.getFractionalPartsTimes(f, true);
        if (parts == null) {
            this.convertMultiply(buf, f, precedence, caller);
            return true;
        }
        IExpr numerator = parts[0];
        IExpr denominator = parts[1];
        if (!denominator.isOne()) {
            if (caller == 1) {
                buf.append('+');
            }
            buf.append("\\frac{");
            if (numerator.isTimes()) {
                this.convertMultiply(buf, (IAST)numerator, this.fPrecedence, 0);
            } else {
                this.fFactory.convert(buf, numerator, precedence);
            }
            buf.append("}{");
            if (denominator.isTimes()) {
                this.convertMultiply(buf, (IAST)denominator, this.fPrecedence, 0);
            } else {
                this.fFactory.convert(buf, denominator, precedence);
            }
            buf.append('}');
        } else if (numerator.isTimes()) {
            this.convertMultiply(buf, (IAST)numerator, this.fPrecedence, 0);
        } else {
            this.fFactory.convert(buf, numerator, precedence);
        }
        return true;
    }

    private boolean convertMultiply(StringBuffer buf, IAST f, int precedence, int caller) {
        int size = f.size();
        if (size > 1) {
            IExpr arg1 = f.arg1();
            if (arg1.isMinusOne()) {
                if (size == 2) {
                    this.precedenceOpen(buf, precedence);
                    this.fFactory.convert(buf, arg1, this.fPrecedence);
                } else if (caller == 1) {
                    buf.append(" - ");
                    if (size == 3) {
                        this.fFactory.convert(buf, f.arg2(), this.fPrecedence);
                        return true;
                    }
                } else {
                    this.precedenceOpen(buf, precedence);
                    buf.append(" - ");
                }
            } else if (arg1.isOne()) {
                if (size == 2) {
                    this.precedenceOpen(buf, precedence);
                    this.fFactory.convert(buf, arg1, this.fPrecedence);
                } else if (caller == 1) {
                    if (size == 3) {
                        this.fFactory.convert(buf, f.arg2(), this.fPrecedence);
                        return true;
                    }
                } else {
                    this.precedenceOpen(buf, precedence);
                }
            } else {
                if (caller == 1) {
                    if (arg1.isSignedNumber() && ((ISignedNumber)arg1).isNegative()) {
                        buf.append(" - ");
                        arg1 = ((ISignedNumber)arg1).negate();
                    } else {
                        buf.append(" + ");
                    }
                } else {
                    this.precedenceOpen(buf, precedence);
                }
                this.fFactory.convert(buf, arg1, this.fPrecedence);
                if (this.fOperator.compareTo("") != 0) {
                    buf.append("\\,");
                }
            }
        }
        for (int i = 2; i < size; ++i) {
            this.fFactory.convert(buf, f.get(i), this.fPrecedence);
            if (i >= f.size() - 1 || this.fOperator.compareTo("") == 0) continue;
            buf.append("\\,");
        }
        this.precedenceClose(buf, precedence);
        return true;
    }
}

