/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form.tex;

import java.math.BigInteger;
import java.util.Hashtable;
import org.apache.commons.math3.fraction.BigFraction;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.form.tex.AbstractConverter;
import org.matheclipse.core.form.tex.AbstractTeXFormFactory;
import org.matheclipse.core.form.tex.IConverter;
import org.matheclipse.core.form.tex.TeXFunction;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.operator.ASTNodeFactory;

public class TeXFormFactory
extends AbstractTeXFormFactory {
    public final Hashtable<String, Object> CONSTANT_SYMBOLS = new Hashtable(199);
    public final Hashtable<String, AbstractConverter> operTab = new Hashtable(199);
    private int plusPrec;
    private int timesPrec;

    public TeXFormFactory() {
        this("");
    }

    public TeXFormFactory(String tagPrefix) {
        this.init();
    }

    @Override
    public void convertDouble(StringBuffer buf, INum d, int precedence) {
        if (d.isNegative() && precedence > this.plusPrec) {
            buf.append("\\left( ");
        }
        buf.append(d.toString());
        if (d.isNegative() && precedence > this.plusPrec) {
            buf.append("\\right) ");
        }
    }

    @Override
    public void convertDoubleComplex(StringBuffer buf, IComplexNum dc, int precedence) {
        if (precedence > this.plusPrec) {
            buf.append("\\left( ");
        }
        this.convert(buf, dc.getRealPart(), 0);
        buf.append(" + ");
        this.convert(buf, dc.getImaginaryPart(), 0);
        buf.append("\\,");
        buf.append("\\imag");
        if (precedence > this.plusPrec) {
            buf.append("\\right) ");
        }
    }

    @Override
    public void convertInteger(StringBuffer buf, IInteger i, int precedence) {
        if (i.isNegative() && precedence > this.plusPrec) {
            buf.append("\\left( ");
        }
        buf.append(i.getBigNumerator().toString());
        if (i.isNegative() && precedence > this.plusPrec) {
            buf.append("\\right) ");
        }
    }

    @Override
    public void convertFraction(StringBuffer buf, IFraction f, int precedence) {
        if (f.isNegative() && precedence > this.plusPrec) {
            buf.append("\\left( ");
        }
        buf.append("\\frac{");
        buf.append(f.getBigNumerator().toString());
        buf.append("}{");
        buf.append(f.getBigDenominator().toString());
        buf.append('}');
        if (f.isNegative() && precedence > this.plusPrec) {
            buf.append("\\right) ");
        }
    }

    public void convertFraction(StringBuffer buf, BigFraction f, int precedence) {
        boolean negative;
        boolean bl = negative = f.compareTo(BigFraction.ZERO) < 0;
        if (negative && precedence > this.plusPrec) {
            buf.append("\\left( ");
        }
        if (f.getDenominator().equals(BigInteger.ONE)) {
            buf.append(f.getNumerator().toString());
        } else {
            buf.append("\\frac{");
            buf.append(f.getNumerator().toString());
            buf.append("}{");
            buf.append(f.getDenominator().toString());
            buf.append('}');
        }
        if (negative && precedence > this.plusPrec) {
            buf.append("\\right) ");
        }
    }

    @Override
    public void convertComplex(StringBuffer buf, IComplex c, int precedence) {
        if (c.equals(F.CI)) {
            buf.append("\\imag");
            return;
        }
        if (precedence > this.plusPrec) {
            buf.append("\\left( ");
        }
        BigFraction re = c.getRealPart();
        BigFraction im = c.getImaginaryPart();
        if (!re.equals(BigFraction.ZERO)) {
            this.convert(buf, c.getRealPart(), 0);
            if (im.compareTo(BigFraction.ZERO) >= 0) {
                buf.append(" + ");
            } else {
                buf.append(" - ");
                im = im.negate();
            }
        }
        this.convert(buf, im, 0);
        buf.append("\\,");
        buf.append("\\imag");
        if (precedence > this.plusPrec) {
            buf.append("\\right) ");
        }
    }

    @Override
    public void convertString(StringBuffer buf, String str) {
        buf.append(str);
    }

    @Override
    public void convertSymbol(StringBuffer buf, ISymbol sym) {
        Object convertedSymbol;
        String str;
        String headStr = sym.getSymbolName();
        if (Config.PARSER_USE_LOWERCASE_SYMBOLS && (str = AST2Expr.PREDEFINED_SYMBOLS_MAP.get(headStr)) != null) {
            headStr = str;
        }
        if ((convertedSymbol = this.CONSTANT_SYMBOLS.get(headStr)) == null) {
            buf.append(sym.getSymbolName());
        } else if (convertedSymbol.equals(AST2Expr.TRUE_STRING)) {
            buf.append('\\');
            buf.append(sym.getSymbolName());
        } else if (convertedSymbol instanceof Operator) {
            ((Operator)convertedSymbol).convert(buf);
        } else {
            buf.append(convertedSymbol.toString());
        }
    }

    @Override
    public void convertHead(StringBuffer buf, Object obj) {
        if (obj instanceof ISymbol) {
            Object ho = this.CONSTANT_SYMBOLS.get(((ISymbol)obj).getSymbolName());
            if (ho != null && ho.equals(AST2Expr.TRUE_STRING)) {
                buf.append('\\');
            }
            buf.append(((ISymbol)obj).getSymbolName());
            return;
        }
        this.convert(buf, obj, 0);
    }

    @Override
    public void convert(StringBuffer buf, Object o, int precedence) {
        if (o instanceof IAST) {
            IAST f = (IAST)o;
            IConverter converter = null;
            IExpr h = f.head();
            if (h.isSymbol()) {
                converter = this.reflection(((ISymbol)h).getSymbolName());
            }
            if (converter == null || !converter.convert(buf, f, precedence)) {
                this.convertAST(buf, f);
            }
            return;
        }
        if (o instanceof INum) {
            this.convertDouble(buf, (INum)o, precedence);
            return;
        }
        if (o instanceof IComplexNum) {
            this.convertDoubleComplex(buf, (IComplexNum)o, precedence);
            return;
        }
        if (o instanceof IInteger) {
            this.convertInteger(buf, (IInteger)o, precedence);
            return;
        }
        if (o instanceof IFraction) {
            this.convertFraction(buf, (IFraction)o, precedence);
            return;
        }
        if (o instanceof IComplex) {
            this.convertComplex(buf, (IComplex)o, precedence);
            return;
        }
        if (o instanceof ISymbol) {
            this.convertSymbol(buf, (ISymbol)o);
            return;
        }
        if (o instanceof BigFraction) {
            this.convertFraction(buf, (BigFraction)o, precedence);
            return;
        }
        this.convertString(buf, o.toString());
    }

    private void convertAST(StringBuffer buf, IAST f) {
        this.convertHead(buf, f.head());
        buf.append("\\left( ");
        for (int i = 1; i < f.size(); ++i) {
            this.convert(buf, f.get(i), 0);
            if (i >= f.size() - 1) continue;
            buf.append(',');
        }
        buf.append(" \\right)");
    }

    @Override
    public String getReflectionNamespace() {
        return "org.matheclipse.core.form.tex.reflection.";
    }

    @Override
    public IConverter reflection(String headString) {
        IConverter converter;
        String headStr = headString;
        if (Config.PARSER_USE_LOWERCASE_SYMBOLS) {
            String str = AST2Expr.PREDEFINED_SYMBOLS_MAP.get(headStr);
            if (str != null) {
                headStr = str;
            } else {
                return null;
            }
        }
        if ((converter = (IConverter)this.operTab.get(headStr)) != null) {
            return converter;
        }
        String namespace = this.getReflectionNamespace() + headStr;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(namespace);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        try {
            AbstractConverter module = (AbstractConverter)clazz.newInstance();
            module.setFactory(this);
            this.operTab.put(headString, module);
            return module;
        }
        catch (Throwable se) {
            return null;
        }
    }

    public void init() {
        this.plusPrec = ASTNodeFactory.MMA_STYLE_FACTORY.get("Plus").getPrecedence();
        this.timesPrec = ASTNodeFactory.MMA_STYLE_FACTORY.get("Times").getPrecedence();
        this.operTab.put("Sin", new TeXFunction(this, "sin"));
        this.operTab.put("Cos", new TeXFunction(this, "cos"));
        this.operTab.put("Tan", new TeXFunction(this, "tan"));
        this.operTab.put("Cot", new TeXFunction(this, "cot"));
        this.operTab.put("ArcSin", new TeXFunction(this, "arcsin"));
        this.operTab.put("ArcCos", new TeXFunction(this, "arccos"));
        this.operTab.put("ArcTan", new TeXFunction(this, "arctan"));
        this.operTab.put("ArcCot", new TeXFunction(this, "arccot"));
        this.operTab.put("ArcSinh", new TeXFunction(this, "arcsinh"));
        this.operTab.put("ArcCosh", new TeXFunction(this, "arccosh"));
        this.operTab.put("ArcTanh", new TeXFunction(this, "arctanh"));
        this.operTab.put("ArcCoth", new TeXFunction(this, "arccoth"));
        this.operTab.put("Log", new TeXFunction(this, "log"));
        this.CONSTANT_SYMBOLS.put("Pi", "\\pi");
        this.CONSTANT_SYMBOLS.put("Alpha", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("Beta", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("Chi", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("Delta", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("Epsilon", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("Phi", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("Gamma", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("Eta", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("Iota", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("varTheta", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("Kappa", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("Lambda", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("Mu", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("Nu", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("Omicron", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("Theta", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("Rho", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("Sigma", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("Tau", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("Upsilon", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("Omega", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("Xi", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("Psi", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("Zeta", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("alpha", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("beta", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("chi", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("selta", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("epsilon", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("phi", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("gamma", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("eta", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("iota", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("varphi", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("kappa", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("lambda", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("mu", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("nu", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("omicron", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("theta", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("rho", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("sigma", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("tau", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("upsilon", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("varomega", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("omega", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("xi", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("psi", AST2Expr.TRUE_STRING);
        this.CONSTANT_SYMBOLS.put("zeta", AST2Expr.TRUE_STRING);
    }

    static class Operator {
        String fOperator;

        Operator(String oper) {
            this.fOperator = oper;
        }

        public void convert(StringBuffer buf) {
            buf.append(this.fOperator);
        }

        public String toString() {
            return this.fOperator;
        }
    }
}

