/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form.output;

import java.io.IOException;
import java.math.BigInteger;
import org.apache.commons.math3.fraction.BigFraction;
import org.apfloat.Apcomplex;
import org.apfloat.Apfloat;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.expression.ApcomplexNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.NumberUtil;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IPatternObject;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.operator.ASTNodeFactory;
import org.matheclipse.parser.client.operator.InfixOperator;
import org.matheclipse.parser.client.operator.Operator;
import org.matheclipse.parser.client.operator.PostfixOperator;
import org.matheclipse.parser.client.operator.PrefixOperator;

public class OutputFormFactory {
    private final boolean fRelaxedSyntax;
    private boolean fIgnoreNewLine = false;
    private boolean fEmpty = true;
    private int fColumnCounter;

    private OutputFormFactory(boolean relaxedSyntax) {
        this.fRelaxedSyntax = relaxedSyntax;
    }

    public static OutputFormFactory get(boolean relaxedSyntax) {
        return new OutputFormFactory(relaxedSyntax);
    }

    public static OutputFormFactory get() {
        return OutputFormFactory.get(false);
    }

    public void convertDouble(Appendable buf, INum d, int precedence) throws IOException {
        if (d.isZero()) {
            this.convertDoubleValue(buf, "0.0", precedence, false);
            return;
        }
        boolean isNegative = d.isNegative();
        this.convertDoubleValue(buf, d.toString(), precedence, isNegative);
    }

    private void convertDoubleValue(Appendable buf, String d, int precedence, boolean isNegative) throws IOException {
        if (isNegative && 2900 < precedence) {
            this.append(buf, "(");
        }
        this.append(buf, d);
        if (isNegative && 2900 < precedence) {
            this.append(buf, ")");
        }
    }

    public void convertDoubleComplex(Appendable buf, IComplexNum dc, int precedence) throws IOException {
        if (dc instanceof ApcomplexNum) {
            this.convertApcomplex(buf, ((ApcomplexNum)dc).apcomplexValue(), precedence);
            return;
        }
        if (2900 < precedence) {
            this.append(buf, "(");
        }
        double realPart = dc.getRealPart();
        double imaginaryPart = dc.getImaginaryPart();
        boolean realZero = F.isZero(realPart);
        boolean imaginaryZero = F.isZero(imaginaryPart);
        if (realZero && imaginaryZero) {
            this.convertDoubleValue(buf, "0.0", 2900, false);
        } else if (!realZero) {
            this.append(buf, String.valueOf(realPart));
            if (!imaginaryZero) {
                this.append(buf, "+I*");
                boolean isNegative = dc.getImaginaryPart() < 0.0;
                this.convertDoubleValue(buf, String.valueOf(imaginaryPart), 3800, isNegative);
            }
        } else {
            this.append(buf, "I*");
            boolean isNegative = dc.getImaginaryPart() < 0.0;
            this.convertDoubleValue(buf, String.valueOf(imaginaryPart), 3800, isNegative);
        }
        if (2900 < precedence) {
            this.append(buf, ")");
        }
    }

    public void convertApcomplex(Appendable buf, Apcomplex dc, int precedence) throws IOException {
        if (2900 < precedence) {
            this.append(buf, "(");
        }
        Apfloat realPart = dc.real();
        Apfloat imaginaryPart = dc.imag();
        boolean realZero = realPart.equals(Apfloat.ZERO);
        boolean imaginaryZero = imaginaryPart.equals(Apfloat.ZERO);
        if (realZero && imaginaryZero) {
            this.convertDoubleValue(buf, "0.0", 2900, false);
        } else if (!realZero) {
            this.append(buf, String.valueOf(realPart));
            if (!imaginaryZero) {
                this.append(buf, "+I*");
                boolean isNegative = imaginaryPart.compareTo(Apfloat.ZERO) < 0;
                this.convertDoubleValue(buf, String.valueOf(imaginaryPart), 3800, isNegative);
            }
        } else {
            this.append(buf, "I*");
            boolean isNegative = imaginaryPart.compareTo(Apfloat.ZERO) < 0;
            this.convertDoubleValue(buf, String.valueOf(imaginaryPart), 3800, isNegative);
        }
        if (2900 < precedence) {
            this.append(buf, ")");
        }
    }

    public void convertInteger(Appendable buf, IInteger i, int precedence) throws IOException {
        String str;
        boolean isNegative = i.isNegative();
        if (isNegative && 2900 < precedence) {
            this.append(buf, "(");
        }
        if ((str = i.getBigNumerator().toString()).length() + this.getColumnCounter() > 80) {
            if (this.getColumnCounter() > 40) {
                this.newLine(buf);
            }
            int len = str.length();
            for (int j = 0; j < len; j += 79) {
                if (j + 79 < len) {
                    this.append(buf, str.substring(j, j + 79));
                    this.append(buf, '\\');
                    this.newLine(buf);
                    continue;
                }
                this.append(buf, str.substring(j, len));
            }
        } else {
            this.append(buf, str);
        }
        if (isNegative && 2900 < precedence) {
            this.append(buf, ")");
        }
    }

    public void convertFraction(Appendable buf, BigFraction f, int precedence) throws IOException {
        int j;
        int len;
        String str;
        int prec;
        boolean isInteger = f.getDenominator().compareTo(BigInteger.ONE) == 0;
        boolean isNegative = f.getNumerator().compareTo(BigInteger.ZERO) < 0;
        int n = prec = isNegative ? 2900 : 3800;
        if (prec < precedence) {
            this.append(buf, "(");
        }
        if ((str = f.getNumerator().toString()).length() + this.getColumnCounter() > 80) {
            if (this.getColumnCounter() > 40) {
                this.newLine(buf);
            }
            len = str.length();
            for (j = 0; j < len; j += 79) {
                if (j + 79 < len) {
                    this.append(buf, str.substring(j, j + 79));
                    this.append(buf, '\\');
                    this.newLine(buf);
                    continue;
                }
                this.append(buf, str.substring(j, len));
            }
        } else {
            this.append(buf, str);
        }
        if (!isInteger) {
            this.append(buf, "/");
            str = f.getDenominator().toString();
            if (str.length() + this.getColumnCounter() > 80) {
                if (this.getColumnCounter() > 40) {
                    this.newLine(buf);
                }
                len = str.length();
                for (j = 0; j < len; j += 79) {
                    if (j + 79 < len) {
                        this.append(buf, str.substring(j, j + 79));
                        this.append(buf, '\\');
                        this.newLine(buf);
                        continue;
                    }
                    this.append(buf, str.substring(j, len));
                }
            } else {
                this.append(buf, str);
            }
        }
        if (prec < precedence) {
            this.append(buf, ")");
        }
    }

    public void convertComplex(Appendable buf, IComplex c, int precedence) throws IOException {
        boolean isReZero = c.getRealPart().compareTo(BigFraction.ZERO) == 0;
        boolean isImOne = c.getImaginaryPart().compareTo(BigFraction.ONE) == 0;
        boolean isImMinusOne = c.getImaginaryPart().equals(BigFraction.MINUS_ONE);
        if (!isReZero && 2900 < precedence) {
            this.append(buf, "(");
        }
        if (!isReZero) {
            this.convertFraction(buf, c.getRealPart(), 2900);
        }
        if (isImOne) {
            if (isReZero) {
                this.append(buf, "I");
                return;
            }
            this.append(buf, "+I");
        } else if (isImMinusOne) {
            this.append(buf, "-I");
        } else {
            BigFraction im;
            if (isReZero && 3800 < precedence) {
                this.append(buf, "(");
            }
            if (NumberUtil.isNegative(im = c.getImaginaryPart())) {
                this.append(buf, "-I*");
                this.convertFraction(buf, c.getImaginaryPart().negate(), 3800);
            } else {
                if (isReZero) {
                    this.append(buf, "I*");
                } else {
                    this.append(buf, "+I*");
                }
                this.convertFraction(buf, c.getImaginaryPart(), 3800);
            }
            if (isReZero && 3800 < precedence) {
                this.append(buf, ")");
            }
        }
        if (!isReZero && 2900 < precedence) {
            this.append(buf, ")");
        }
    }

    public void convertString(Appendable buf, String str) throws IOException {
        this.append(buf, "\"");
        this.append(buf, str);
        this.append(buf, "\"");
    }

    public void convertSymbol(Appendable buf, ISymbol symbol) throws IOException {
        String str;
        if (Config.PARSER_USE_LOWERCASE_SYMBOLS && (str = AST2Expr.PREDEFINED_SYMBOLS_MAP.get(symbol.getSymbolName())) != null) {
            this.append(buf, str);
            return;
        }
        this.append(buf, symbol.getSymbolName());
    }

    public void convertPattern(Appendable buf, IPatternObject pattern) throws IOException {
        this.append(buf, pattern.toString());
    }

    public void convertHead(Appendable buf, IExpr obj) throws IOException {
        this.convert(buf, obj);
    }

    private void convertPlusOperator(Appendable buf, IAST plusAST, InfixOperator oper, int precedence) throws IOException {
        int size;
        if (oper.getPrecedence() < precedence) {
            this.append(buf, "(");
        }
        for (int i = size = plusAST.size() - 1; i > 0; --i) {
            IExpr plusArg = (IExpr)plusAST.get(i);
            if (plusArg.isTimes()) {
                String multCh = ASTNodeFactory.MMA_STYLE_FACTORY.get("Times").getOperatorString();
                boolean showOperator = true;
                IAST timesAST = (IAST)plusArg;
                IExpr arg1 = timesAST.arg1();
                if (arg1.isNumber() && ((INumber)arg1).complexSign() < 0) {
                    if (((INumber)arg1).isOne()) {
                        showOperator = false;
                    } else if (((INumber)arg1).isMinusOne()) {
                        this.append(buf, "-");
                        showOperator = false;
                    } else {
                        this.convertNumber(buf, (INumber)arg1, oper.getPrecedence());
                    }
                } else {
                    if (i < size) {
                        this.append(buf, oper.getOperatorString());
                    }
                    this.convert(buf, arg1, 3800);
                }
                for (int j = 2; j < timesAST.size(); ++j) {
                    IExpr timesArg = (IExpr)timesAST.get(j);
                    if (showOperator) {
                        this.append(buf, multCh);
                    } else {
                        showOperator = true;
                    }
                    this.convert(buf, timesArg, 3800);
                }
                continue;
            }
            if (plusArg.isNumber() && ((INumber)plusArg).complexSign() < 0) {
                this.convert(buf, plusArg);
                continue;
            }
            if (i < size) {
                this.append(buf, oper.getOperatorString());
            }
            this.convert(buf, plusArg, 2900);
        }
        if (oper.getPrecedence() < precedence) {
            this.append(buf, ")");
        }
    }

    private void convertTimesOperator(Appendable buf, IAST timesAST, InfixOperator oper, int precedence) throws IOException {
        boolean showOperator = true;
        int currPrecedence = oper.getPrecedence();
        if (currPrecedence < precedence) {
            this.append(buf, "(");
        }
        if (timesAST.size() > 1) {
            if (((IExpr)timesAST.get(1)).isSignedNumber() && timesAST.size() > 2 && !((IExpr)timesAST.get(2)).isNumber()) {
                if (((IExpr)timesAST.get(1)).equals(F.CN1)) {
                    this.append(buf, "-");
                    showOperator = false;
                } else if (((ISignedNumber)timesAST.get(1)).isNegative()) {
                    this.convertNumber(buf, (INumber)timesAST.get(1), oper.getPrecedence());
                } else {
                    this.convert(buf, (IExpr)timesAST.get(1), oper.getPrecedence());
                }
            } else {
                this.convert(buf, (IExpr)timesAST.get(1), oper.getPrecedence());
            }
        }
        for (int i = 2; i < timesAST.size(); ++i) {
            if (showOperator) {
                this.append(buf, oper.getOperatorString());
            } else {
                showOperator = true;
            }
            this.convert(buf, (IExpr)timesAST.get(i), oper.getPrecedence());
        }
        if (currPrecedence < precedence) {
            this.append(buf, ")");
        }
    }

    public void convertBinaryOperator(Appendable buf, IAST list, InfixOperator oper, int precedence) throws IOException {
        if (oper.getPrecedence() < precedence) {
            this.append(buf, "(");
        }
        if (list.size() > 1) {
            this.convert(buf, (IExpr)list.get(1), oper.getPrecedence());
        }
        for (int i = 2; i < list.size(); ++i) {
            this.append(buf, oper.getOperatorString());
            this.convert(buf, (IExpr)list.get(i), oper.getPrecedence());
        }
        if (oper.getPrecedence() < precedence) {
            this.append(buf, ")");
        }
    }

    public void convertPrefixOperator(Appendable buf, IAST list, PrefixOperator oper, int precedence) throws IOException {
        if (oper.getPrecedence() < precedence) {
            this.append(buf, "(");
        }
        this.append(buf, oper.getOperatorString());
        this.convert(buf, (IExpr)list.get(1), oper.getPrecedence());
        if (oper.getPrecedence() < precedence) {
            this.append(buf, ")");
        }
    }

    public void convertPostfixOperator(Appendable buf, IAST list, PostfixOperator oper, int precedence) throws IOException {
        if (oper.getPrecedence() < precedence) {
            this.append(buf, "(");
        }
        this.convert(buf, (IExpr)list.get(1), oper.getPrecedence());
        this.append(buf, oper.getOperatorString());
        if (oper.getPrecedence() < precedence) {
            this.append(buf, ")");
        }
    }

    public void convert(Appendable buf, IExpr o) throws IOException {
        this.convert(buf, o, Integer.MIN_VALUE);
    }

    public void convertNumber(Appendable buf, INumber o, int precedence) throws IOException {
        if (o instanceof INum) {
            this.convertDouble(buf, (INum)o, precedence);
            return;
        }
        if (o instanceof IComplexNum) {
            this.convertDoubleComplex(buf, (IComplexNum)o, precedence);
            return;
        }
        if (o instanceof IInteger) {
            this.convertInteger(buf, (IInteger)o, precedence);
            return;
        }
        if (o instanceof IFraction) {
            this.convertFraction(buf, ((IFraction)o).getRational(), precedence);
            return;
        }
        if (o instanceof IComplex) {
            this.convertComplex(buf, (IComplex)o, precedence);
            return;
        }
    }

    public void convert(Appendable buf, IExpr o, int precedence) throws IOException {
        if (o instanceof IAST) {
            Operator operator;
            String str;
            IAST list = (IAST)o;
            ISymbol head = list.topHead();
            String header = head.getSymbolName();
            if (Config.PARSER_USE_LOWERCASE_SYMBOLS && (str = AST2Expr.PREDEFINED_SYMBOLS_MAP.get(header)) != null) {
                header = str;
            }
            if ((operator = ASTNodeFactory.MMA_STYLE_FACTORY.get(header)) != null) {
                if (operator instanceof PrefixOperator && list.size() == 2) {
                    this.convertPrefixOperator(buf, list, (PrefixOperator)operator, precedence);
                    return;
                }
                if (operator instanceof InfixOperator && list.size() > 2) {
                    if (head.equals(F.Plus)) {
                        this.convertPlusOperator(buf, list, (InfixOperator)operator, precedence);
                        return;
                    }
                    if (head.equals(F.Times)) {
                        this.convertTimesOperator(buf, list, (InfixOperator)operator, precedence);
                        return;
                    }
                    this.convertBinaryOperator(buf, list, (InfixOperator)operator, precedence);
                    return;
                }
                if (operator instanceof PostfixOperator && list.size() == 2) {
                    this.convertPostfixOperator(buf, list, (PostfixOperator)operator, precedence);
                    return;
                }
            }
            if (list.isList()) {
                this.convertList(buf, list);
                return;
            }
            if (head.equals(F.Part) && list.size() >= 3) {
                this.convertPart(buf, list);
                return;
            }
            if (head.equals(F.Slot) && list.size() == 2 && list.get(1) instanceof IInteger) {
                this.convertSlot(buf, list);
                return;
            }
            if (head.equals(F.Hold) && list.size() == 2) {
                this.convert(buf, (IExpr)list.get(1));
                return;
            }
            if (list.isDirectedInfinity()) {
                if (list.size() == 1) {
                    this.append(buf, "ComplexInfinity");
                    return;
                }
                if (list.size() == 2) {
                    if (((IExpr)list.get(1)).equals(F.C1)) {
                        this.append(buf, "Infinity");
                        return;
                    }
                    if (((IExpr)list.get(1)).equals(F.CN1)) {
                        if (2900 < precedence) {
                            this.append(buf, "(");
                        }
                        this.append(buf, "-Infinity");
                        if (2900 < precedence) {
                            this.append(buf, ")");
                        }
                        return;
                    }
                }
            }
            this.convertAST(buf, list);
            return;
        }
        if (o instanceof ISignedNumber) {
            this.convertNumber(buf, (ISignedNumber)o, precedence);
            return;
        }
        if (o instanceof IComplexNum) {
            this.convertDoubleComplex(buf, (IComplexNum)o, precedence);
            return;
        }
        if (o instanceof IComplex) {
            this.convertComplex(buf, (IComplex)o, precedence);
            return;
        }
        if (o instanceof ISymbol) {
            this.convertSymbol(buf, (ISymbol)o);
            return;
        }
        if (o instanceof IPatternObject) {
            this.convertPattern(buf, (IPatternObject)((Object)o));
            return;
        }
        this.convertString(buf, o.toString());
    }

    public void convertSlot(Appendable buf, IAST list) throws IOException {
        try {
            int slot = ((ISignedNumber)list.get(1)).toInt();
            this.append(buf, "#" + slot);
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    public void convertList(Appendable buf, IAST list) throws IOException {
        if (list.isEvalFlagOn(32) && !this.fEmpty) {
            this.newLine(buf);
        }
        this.append(buf, "{");
        int listSize = list.size();
        if (listSize > 1) {
            this.convert(buf, (IExpr)list.get(1));
        }
        for (int i = 2; i < listSize; ++i) {
            this.append(buf, ",");
            if (list.isEvalFlagOn(32)) {
                this.newLine(buf);
                this.append(buf, ' ');
            }
            this.convert(buf, (IExpr)list.get(i));
        }
        this.append(buf, "}");
    }

    public void convertPart(Appendable buf, IAST list) throws IOException {
        IExpr arg1 = (IExpr)list.get(1);
        if (!(arg1 instanceof IAST)) {
            this.append(buf, "(");
        }
        this.convert(buf, (IExpr)list.get(1));
        this.append(buf, "[[");
        for (int i = 2; i < list.size(); ++i) {
            this.convert(buf, (IExpr)list.get(i));
            if (i >= list.size() - 1) continue;
            this.append(buf, ",");
        }
        this.append(buf, "]]");
        if (!(arg1 instanceof IAST)) {
            this.append(buf, ")");
        }
    }

    public void convertAST(Appendable buf, IAST function) throws IOException {
        IExpr head = function.head();
        this.convert(buf, function.head());
        if (head.isAST()) {
            this.append(buf, "[");
        } else if (this.fRelaxedSyntax) {
            this.append(buf, "(");
        } else {
            this.append(buf, "[");
        }
        int functionSize = function.size();
        if (functionSize > 1) {
            this.convert(buf, (IExpr)function.get(1));
        }
        for (int i = 2; i < functionSize; ++i) {
            this.append(buf, ",");
            this.convert(buf, (IExpr)function.get(i));
        }
        if (head.isAST()) {
            this.append(buf, "]");
        } else if (this.fRelaxedSyntax) {
            this.append(buf, ")");
        } else {
            this.append(buf, "]");
        }
    }

    private void newLine(Appendable buf) throws IOException {
        if (!this.fIgnoreNewLine) {
            this.append(buf, '\n');
        }
        this.fColumnCounter = 0;
        this.fEmpty = false;
    }

    private void append(Appendable buf, String str) throws IOException {
        buf.append(str);
        this.fColumnCounter += str.length();
        this.fEmpty = false;
    }

    private void append(Appendable buf, char c) throws IOException {
        buf.append(c);
        ++this.fColumnCounter;
        this.fEmpty = false;
    }

    public void setIgnoreNewLine(boolean ignoreNewLine) {
        this.fIgnoreNewLine = ignoreNewLine;
    }

    public void setEmpty(boolean empty) {
        this.fEmpty = empty;
    }

    public int getColumnCounter() {
        return this.fColumnCounter;
    }

    public void setColumnCounter(int columnCounter) {
        this.fColumnCounter = columnCounter;
    }
}

