/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form.mathml.reflection;

import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.NumberUtil;
import org.matheclipse.core.form.mathml.AbstractOperator;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.parser.client.operator.ASTNodeFactory;

public class Times
extends AbstractOperator {
    public static final int NO_SPECIAL_CALL = 0;
    public static final int PLUS_CALL = 1;

    public Times() {
        super(ASTNodeFactory.MMA_STYLE_FACTORY.get("Times").getPrecedence(), "mrow", "&#x2062;");
    }

    @Override
    public boolean convert(StringBuffer buf, IAST f, int precedence) {
        return this.convert(buf, f, precedence, 0);
    }

    public boolean convert(StringBuffer buf, IAST f, int precedence, int caller) {
        IAST numerator = F.Times();
        IAST denominator = F.Times();
        boolean flag = false;
        for (int i = 1; i < f.size(); ++i) {
            IAST p;
            IExpr expr = (IExpr)f.get(i);
            if (expr instanceof IRational) {
                IInteger num = ((IRational)expr).getNumerator();
                IInteger den = ((IRational)expr).getDenominator();
                if (!NumberUtil.isOne(num)) {
                    numerator.add(num);
                }
                if (!NumberUtil.isOne(den)) {
                    denominator.add(den);
                }
                flag = true;
                continue;
            }
            if (f.get(i) instanceof IAST && ((IExpr)f.get(i)).isPower() && (p = (IAST)f.get(i)).get(2) instanceof ISignedNumber && ((ISignedNumber)p.get(2)).isNegative()) {
                if (NumberUtil.isMinusOne(p.arg2())) {
                    denominator.add(p.get(1));
                    flag = true;
                    continue;
                }
                denominator.add(F.Power(p.arg1(), F.Times((IExpr)F.integer(-1L), (IExpr)p.get(2))));
                flag = true;
                continue;
            }
            if (NumberUtil.isOne((IExpr)f.get(i))) continue;
            numerator.add(f.get(i));
        }
        if (denominator.size() > 1 && flag) {
            if (caller == 1) {
                this.fFactory.tag(buf, "mo", "+");
            }
            this.fFactory.tagStart(buf, "mfrac");
            if (numerator.size() > 1) {
                if (numerator.size() == 2) {
                    this.fFactory.convert(buf, (IExpr)numerator.get(1), 0);
                } else {
                    this.fFactory.convert(buf, numerator, this.fPrecedence);
                }
            } else {
                this.fFactory.tag(buf, "mn", "1");
            }
            if (denominator.size() == 2) {
                this.fFactory.convert(buf, (IExpr)denominator.get(1), 0);
            } else {
                this.fFactory.convert(buf, denominator, this.fPrecedence);
            }
            this.fFactory.tagEnd(buf, "mfrac");
        } else if (numerator.size() <= 2) {
            this.convertMultiply(buf, f, precedence, caller);
        } else {
            this.convertMultiply(buf, numerator, precedence, caller);
        }
        return true;
    }

    private boolean convertMultiply(StringBuffer buf, IAST f, int precedence, int caller) {
        int size = f.size();
        if (size > 1) {
            IExpr arg1 = f.arg1();
            if (arg1.isMinusOne()) {
                if (size == 2) {
                    this.fFactory.tagStart(buf, this.fFirstTag);
                    this.precedenceOpen(buf, precedence);
                    this.fFactory.convert(buf, arg1, this.fPrecedence);
                } else if (caller == 1) {
                    this.fFactory.tag(buf, "mo", "-");
                    if (size == 3) {
                        this.fFactory.convert(buf, f.arg2(), this.fPrecedence);
                        return true;
                    }
                    this.fFactory.tagStart(buf, this.fFirstTag);
                } else {
                    this.fFactory.tagStart(buf, this.fFirstTag);
                    this.precedenceOpen(buf, precedence);
                    this.fFactory.tag(buf, "mo", "-");
                }
            } else if (arg1.isOne()) {
                if (size == 2) {
                    this.fFactory.tagStart(buf, this.fFirstTag);
                    this.precedenceOpen(buf, precedence);
                    this.fFactory.convert(buf, arg1, this.fPrecedence);
                } else if (caller == 1) {
                    if (size == 3) {
                        this.fFactory.convert(buf, f.arg2(), this.fPrecedence);
                        return true;
                    }
                    this.fFactory.tagStart(buf, this.fFirstTag);
                } else {
                    this.fFactory.tagStart(buf, this.fFirstTag);
                    this.precedenceOpen(buf, precedence);
                }
            } else {
                if (caller == 1) {
                    if (arg1 instanceof ISignedNumber && ((ISignedNumber)arg1).isNegative()) {
                        this.fFactory.tag(buf, "mo", "-");
                        this.fFactory.tagStart(buf, this.fFirstTag);
                        arg1 = ((ISignedNumber)arg1).negate();
                    } else {
                        this.fFactory.tag(buf, "mo", "+");
                        this.fFactory.tagStart(buf, this.fFirstTag);
                    }
                } else {
                    this.fFactory.tagStart(buf, this.fFirstTag);
                    this.precedenceOpen(buf, precedence);
                }
                this.fFactory.convert(buf, arg1, this.fPrecedence);
                if (this.fOperator.compareTo("") != 0) {
                    this.fFactory.tag(buf, "mo", this.fOperator);
                }
            }
        }
        for (int i = 2; i < size; ++i) {
            this.fFactory.convert(buf, (IExpr)f.get(i), this.fPrecedence);
            if (i >= f.size() - 1 || this.fOperator.compareTo("") == 0) continue;
            this.fFactory.tag(buf, "mo", this.fOperator);
        }
        this.precedenceClose(buf, precedence);
        this.fFactory.tagEnd(buf, this.fFirstTag);
        return true;
    }
}

