/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form.mathml;

import java.util.Hashtable;
import org.apache.commons.math3.fraction.BigFraction;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.expression.NumberUtil;
import org.matheclipse.core.form.mathml.AbstractConverter;
import org.matheclipse.core.form.mathml.AbstractMathMLFormFactory;
import org.matheclipse.core.form.mathml.IConverter;
import org.matheclipse.core.form.mathml.MMLFunction;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.list.algorithms.EvaluationSupport;
import org.matheclipse.parser.client.operator.ASTNodeFactory;

public class MathMLFormFactory
extends AbstractMathMLFormFactory {
    public static final Hashtable<String, Object> CONSTANT_SYMBOLS = new Hashtable(199);
    public static final Hashtable<String, AbstractConverter> operTab = new Hashtable(199);
    private int plusPrec;

    public MathMLFormFactory() {
        this("");
    }

    public MathMLFormFactory(String tagPrefix) {
        super(tagPrefix);
        this.init();
    }

    @Override
    public void convertDouble(StringBuffer buf, INum d, int precedence) {
        if (d.isNegative() && precedence > this.plusPrec) {
            this.tagStart(buf, "mrow");
            this.tag(buf, "mo", "(");
        }
        this.tagStart(buf, "mn");
        buf.append(d.toString());
        this.tagEnd(buf, "mn");
        if (d.isNegative() && precedence > this.plusPrec) {
            this.tag(buf, "mo", ")");
            this.tagEnd(buf, "mrow");
        }
    }

    @Override
    public void convertDoubleComplex(StringBuffer buf, IComplexNum dc, int precedence) {
        this.tagStart(buf, "mrow");
        buf.append(String.valueOf(dc.getRealPart()));
        this.tag(buf, "mo", "+");
        this.tagStart(buf, "mrow");
        buf.append(String.valueOf(dc.getImaginaryPart()));
        this.tag(buf, "mo", "&#x2062;");
        this.tag(buf, "mi", "&ImaginaryI;");
        this.tagEnd(buf, "mrow");
        this.tagEnd(buf, "mrow");
    }

    @Override
    public void convertInteger(StringBuffer buf, IInteger i, int precedence) {
        if (i.isNegative() && precedence > this.plusPrec) {
            this.tagStart(buf, "mrow");
            this.tag(buf, "mo", "(");
        }
        this.tagStart(buf, "mn");
        buf.append(i.getBigNumerator().toString());
        this.tagEnd(buf, "mn");
        if (i.isNegative() && precedence > this.plusPrec) {
            this.tag(buf, "mo", ")");
            this.tagEnd(buf, "mrow");
        }
    }

    @Override
    public void convertFraction(StringBuffer buf, IFraction f, int precedence) {
        boolean isInteger = f.isOne();
        if (f.isNegative() && precedence > this.plusPrec) {
            this.tagStart(buf, "mrow");
            this.tag(buf, "mo", "(");
        }
        if (isInteger) {
            this.tagStart(buf, "mn");
            buf.append(f.getBigNumerator().toString());
            this.tagEnd(buf, "mn");
        } else {
            this.tagStart(buf, "mfrac");
            this.tagStart(buf, "mn");
            buf.append(f.getBigNumerator().toString());
            this.tagEnd(buf, "mn");
            this.tagStart(buf, "mn");
            buf.append(f.getBigDenominator().toString());
            this.tagEnd(buf, "mn");
            this.tagEnd(buf, "mfrac");
        }
        if (f.isNegative() && precedence > this.plusPrec) {
            this.tag(buf, "mo", ")");
            this.tagEnd(buf, "mrow");
        }
    }

    public void convertFraction(StringBuffer buf, BigFraction f, int precedence) {
        if (NumberUtil.isNegative(f) && precedence > this.plusPrec) {
            this.tagStart(buf, "mrow");
            this.tag(buf, "mo", "(");
        }
        if (f.equals(BigFraction.ONE)) {
            this.tagStart(buf, "mn");
            buf.append(f.getNumerator().toString());
            this.tagEnd(buf, "mn");
        } else {
            this.tagStart(buf, "mfrac");
            this.tagStart(buf, "mn");
            buf.append(f.getNumerator().toString());
            this.tagEnd(buf, "mn");
            this.tagStart(buf, "mn");
            buf.append(f.getDenominator().toString());
            this.tagEnd(buf, "mn");
            this.tagEnd(buf, "mfrac");
        }
        if (NumberUtil.isNegative(f) && precedence > this.plusPrec) {
            this.tag(buf, "mo", ")");
            this.tagEnd(buf, "mrow");
        }
    }

    @Override
    public void convertComplex(StringBuffer buf, IComplex c, int precedence) {
        boolean isReZero = c.getRealPart().compareTo(BigFraction.ZERO) == 0;
        boolean isImOne = c.getImaginaryPart().compareTo(BigFraction.ONE) == 0;
        boolean isImNegative = c.getImaginaryPart().compareTo(BigFraction.ZERO) < 0;
        boolean isImMinusOne = c.getImaginaryPart().equals(BigFraction.MINUS_ONE);
        this.tagStart(buf, "mrow");
        if (!isReZero) {
            this.convertFraction(buf, c.getRealPart(), precedence);
            if (isImNegative) {
                this.tag(buf, "mo", "-");
            } else {
                this.tag(buf, "mo", "+");
            }
        } else if (isImMinusOne) {
            this.tag(buf, "mo", "-");
        }
        if (!isImOne && !isImMinusOne) {
            this.tagStart(buf, "mrow");
            this.convertFraction(buf, c.getImaginaryPart(), 3800);
            this.tag(buf, "mo", "&InvisibleTimes;");
            this.tag(buf, "mi", "&ImaginaryI;");
            this.tagEnd(buf, "mrow");
        } else {
            this.tag(buf, "mi", "&ImaginaryI;");
        }
        this.tagEnd(buf, "mrow");
    }

    @Override
    public void convertString(StringBuffer buf, String str) {
        this.tagStart(buf, "mtext");
        buf.append(str);
        this.tagEnd(buf, "mtext");
    }

    @Override
    public void convertSymbol(StringBuffer buf, ISymbol sym) {
        Object convertedSymbol;
        String str;
        String headStr = sym.getSymbolName();
        if (Config.PARSER_USE_LOWERCASE_SYMBOLS && (str = AST2Expr.PREDEFINED_SYMBOLS_MAP.get(headStr)) != null) {
            headStr = str;
        }
        if ((convertedSymbol = CONSTANT_SYMBOLS.get(headStr)) == null) {
            this.tagStart(buf, "mi");
            buf.append(sym.toString());
            this.tagEnd(buf, "mi");
        } else if (convertedSymbol instanceof Operator) {
            ((Operator)convertedSymbol).convert(buf);
        } else {
            this.tagStart(buf, "mi");
            buf.append(convertedSymbol.toString());
            this.tagEnd(buf, "mi");
        }
    }

    @Override
    public void convertHead(StringBuffer buf, IExpr obj) {
        if (obj instanceof ISymbol) {
            this.tagStart(buf, "mi");
            buf.append(((ISymbol)obj).getSymbolName());
            this.tagEnd(buf, "mi");
            this.tag(buf, "mo", "&#x2061;");
            return;
        }
        this.convert(buf, obj, 0);
    }

    @Override
    public void convert(StringBuffer buf, IExpr o, int precedence) {
        if (o instanceof IAST) {
            IAST temp;
            IAST f = (IAST)o;
            ISymbol symbol = f.topHead();
            int attr = symbol.getAttributes();
            IAST ast = f;
            if ((8 & attr) == 8 && (temp = EvaluationSupport.flatten(f)) != null) {
                ast = temp;
            }
            IExpr h = ast.head();
            IConverter converter = null;
            if (h.isSymbol()) {
                converter = this.reflection(((ISymbol)h).getSymbolName());
            }
            if (converter == null || !converter.convert(buf, ast, precedence)) {
                this.convertAST(buf, ast);
            }
            return;
        }
        if (o instanceof INum) {
            this.convertDouble(buf, (INum)o, precedence);
            return;
        }
        if (o instanceof IComplexNum) {
            this.convertDoubleComplex(buf, (IComplexNum)o, precedence);
            return;
        }
        if (o instanceof IInteger) {
            this.convertInteger(buf, (IInteger)o, precedence);
            return;
        }
        if (o instanceof IFraction) {
            this.convertFraction(buf, (IFraction)o, precedence);
            return;
        }
        if (o instanceof IComplex) {
            this.convertComplex(buf, (IComplex)o, precedence);
            return;
        }
        if (o instanceof ISymbol) {
            this.convertSymbol(buf, (ISymbol)o);
            return;
        }
        this.convertString(buf, o.toString());
    }

    private void convertAST(StringBuffer buf, IAST ast) {
        this.tagStart(buf, "mrow");
        this.convertHead(buf, ast.head());
        this.tag(buf, "mo", "&#x2061;");
        this.tagStart(buf, "mrow");
        this.tag(buf, "mo", "(");
        this.tagStart(buf, "mrow");
        for (int i = 1; i < ast.size(); ++i) {
            this.convert(buf, (IExpr)ast.get(i), 0);
            if (i >= ast.size() - 1) continue;
            this.tag(buf, "mo", ",");
        }
        this.tagEnd(buf, "mrow");
        this.tag(buf, "mo", ")");
        this.tagEnd(buf, "mrow");
        this.tagEnd(buf, "mrow");
    }

    @Override
    public String getReflectionNamespace() {
        return "org.matheclipse.core.form.mathml.reflection.";
    }

    @Override
    public IConverter reflection(String headString) {
        AbstractConverter converter;
        String headStr = headString;
        if (Config.PARSER_USE_LOWERCASE_SYMBOLS) {
            String str = AST2Expr.PREDEFINED_SYMBOLS_MAP.get(headStr);
            if (str != null) {
                headStr = str;
            } else {
                return null;
            }
        }
        if ((converter = operTab.get(headStr)) != null) {
            converter.setFactory(this);
            return converter;
        }
        String namespace = this.getReflectionNamespace() + headStr;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(namespace);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        try {
            AbstractConverter module = (AbstractConverter)clazz.newInstance();
            module.setFactory(this);
            operTab.put(headStr, module);
            return module;
        }
        catch (Throwable se) {
            return null;
        }
    }

    public void init() {
        this.plusPrec = ASTNodeFactory.MMA_STYLE_FACTORY.get("Plus").getPrecedence();
        operTab.put("Sin", new MMLFunction(this, "sin"));
        operTab.put("Cos", new MMLFunction(this, "cos"));
        operTab.put("Tan", new MMLFunction(this, "tan"));
        operTab.put("Cot", new MMLFunction(this, "cot"));
        operTab.put("ArcSin", new MMLFunction(this, "arcsin"));
        operTab.put("ArcCos", new MMLFunction(this, "arccos"));
        operTab.put("ArcTan", new MMLFunction(this, "arctan"));
        operTab.put("ArcCot", new MMLFunction(this, "arccot"));
        operTab.put("ArcSinh", new MMLFunction(this, "arcsinh"));
        operTab.put("ArcCosh", new MMLFunction(this, "arccosh"));
        operTab.put("ArcTanh", new MMLFunction(this, "arctanh"));
        operTab.put("ArcCoth", new MMLFunction(this, "arccoth"));
        operTab.put("Log", new MMLFunction(this, "log"));
        CONSTANT_SYMBOLS.put("E", "\u2147");
        CONSTANT_SYMBOLS.put("HEllipsis", new Operator("&hellip;"));
        CONSTANT_SYMBOLS.put("Pi", "\u03a0");
        CONSTANT_SYMBOLS.put("pi", "\u03c0");
        CONSTANT_SYMBOLS.put("Alpha", "\u0391");
        CONSTANT_SYMBOLS.put("Beta", "\u0392");
        CONSTANT_SYMBOLS.put("Gamma", "\u0393");
        CONSTANT_SYMBOLS.put("Delta", "\u0394");
        CONSTANT_SYMBOLS.put("Epsilon", "\u0395");
        CONSTANT_SYMBOLS.put("Zeta", "\u0396");
        CONSTANT_SYMBOLS.put("Eta", "\u0397");
        CONSTANT_SYMBOLS.put("Theta", "\u0398");
        CONSTANT_SYMBOLS.put("Iota", "\u0399");
        CONSTANT_SYMBOLS.put("Kappa", "\u039a");
        CONSTANT_SYMBOLS.put("Lambda", "\u039b");
        CONSTANT_SYMBOLS.put("Mu", "\u039c");
        CONSTANT_SYMBOLS.put("Nu", "\u039d");
        CONSTANT_SYMBOLS.put("Xi", "\u039e");
        CONSTANT_SYMBOLS.put("Omicron", "\u039f");
        CONSTANT_SYMBOLS.put("Rho", "\u03a1");
        CONSTANT_SYMBOLS.put("Sigma", "\u03a3");
        CONSTANT_SYMBOLS.put("Tau", "\u03a4");
        CONSTANT_SYMBOLS.put("Upsilon", "\u03a5");
        CONSTANT_SYMBOLS.put("Phi", "\u03a6");
        CONSTANT_SYMBOLS.put("Chi", "\u03a7");
        CONSTANT_SYMBOLS.put("Psi", "\u03a8");
        CONSTANT_SYMBOLS.put("Omega", "\u03a9");
        CONSTANT_SYMBOLS.put("varTheta", "\u03d1");
        CONSTANT_SYMBOLS.put("alpha", "\u03b1");
        CONSTANT_SYMBOLS.put("beta", "\u03b2");
        CONSTANT_SYMBOLS.put("chi", "\u03c7");
        CONSTANT_SYMBOLS.put("selta", "\u03b4");
        CONSTANT_SYMBOLS.put("epsilon", "\u03b5");
        CONSTANT_SYMBOLS.put("phi", "\u03c7");
        CONSTANT_SYMBOLS.put("gamma", "\u03b3");
        CONSTANT_SYMBOLS.put("eta", "\u03b7");
        CONSTANT_SYMBOLS.put("iota", "\u03b9");
        CONSTANT_SYMBOLS.put("varphi", "\u03c6");
        CONSTANT_SYMBOLS.put("kappa", "\u03ba");
        CONSTANT_SYMBOLS.put("lambda", "\u03bb");
        CONSTANT_SYMBOLS.put("mu", "\u03bc");
        CONSTANT_SYMBOLS.put("nu", "\u03bd");
        CONSTANT_SYMBOLS.put("omicron", "\u03bf");
        CONSTANT_SYMBOLS.put("theta", "\u03b8");
        CONSTANT_SYMBOLS.put("rho", "\u03c1");
        CONSTANT_SYMBOLS.put("sigma", "\u03c3");
        CONSTANT_SYMBOLS.put("tau", "\u03c4");
        CONSTANT_SYMBOLS.put("upsilon", "\u03c5");
        CONSTANT_SYMBOLS.put("varsigma", "\u03c2");
        CONSTANT_SYMBOLS.put("omega", "\u03c9");
        CONSTANT_SYMBOLS.put("xi", "\u03be");
        CONSTANT_SYMBOLS.put("psi", "\u03c8");
        CONSTANT_SYMBOLS.put("zeta", "\u03b6");
        ENTITY_TABLE.put("&af;", "\ue8a0");
        ENTITY_TABLE.put("&dd;", "\uf74c");
        ENTITY_TABLE.put("&ImaginaryI;", "i");
        ENTITY_TABLE.put("&InvisibleTimes;", "\ue89e");
        ENTITY_TABLE.put("&Integral;", "\u222b");
        ENTITY_TABLE.put("&PartialD;", "\u2202");
        ENTITY_TABLE.put("&Product;", "\u220f");
    }

    class Operator {
        String fOperator;

        Operator(String oper) {
            this.fOperator = oper;
        }

        public void convert(StringBuffer buf) {
            MathMLFormFactory.this.tagStart(buf, "mo");
            buf.append(this.fOperator);
            MathMLFormFactory.this.tagEnd(buf, "mo");
        }

        public String toString() {
            return this.fOperator;
        }
    }
}

