/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import com.google.common.base.Function;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.SystemNamespace;
import org.matheclipse.core.eval.exception.RuleCreationError;
import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.eval.interfaces.ISignedNumberConstant;
import org.matheclipse.core.eval.interfaces.ISymbolEvaluator;
import org.matheclipse.core.expression.AST;
import org.matheclipse.core.expression.ExprImpl;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.form.output.OutputFormFactory;
import org.matheclipse.core.generic.UnaryVariable2Slot;
import org.matheclipse.core.generic.interfaces.INumericFunction;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IEvaluationEngine;
import org.matheclipse.core.interfaces.IEvaluator;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.DownRulesData;
import org.matheclipse.core.patternmatching.IPatternMatcher;
import org.matheclipse.core.patternmatching.PatternMatcher;
import org.matheclipse.core.patternmatching.PatternMatcherAndInvoker;
import org.matheclipse.core.patternmatching.PatternMatcherEquals;
import org.matheclipse.core.patternmatching.UpRulesData;
import org.matheclipse.core.util.OpenIntToIExprHashMap;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;
import org.matheclipse.core.visit.IVisitorLong;

public class Symbol
extends ExprImpl
implements ISymbol {
    private static final long serialVersionUID = -4991038487281911261L;
    private static final int DEFAULT_VALUE_INDEX = Integer.MIN_VALUE;
    private int fAttributes = 0;
    private transient IEvaluator fEvaluator;
    private transient DownRulesData fDownRulesData = new DownRulesData();
    private transient UpRulesData fUpRulesData = new UpRulesData();
    private OpenIntToIExprHashMap fDefaultValues = null;
    protected static final DummyEvaluator DUMMY_EVALUATOR = new DummyEvaluator();
    String fSymbolName;
    final int fHashValue;

    @Override
    public IExpr[] reassignSymbolValue(Function<IExpr, IExpr> function, ISymbol functionSymbol) {
        IExpr symbolValue;
        PatternMatcherEquals pme;
        IExpr[] result = new IExpr[2];
        if (this.hasLocalVariableStack()) {
            IExpr symbolValue2;
            result[0] = symbolValue2 = this.get();
            IExpr calculatedResult = function.apply(symbolValue2);
            if (calculatedResult != null) {
                this.set(calculatedResult);
                result[1] = calculatedResult;
                return result;
            }
        } else if (this.fDownRulesData != null && (pme = this.fDownRulesData.getEqualDownRules().get(this)) != null && (symbolValue = pme.getRHS()) != null) {
            result[0] = symbolValue;
            IExpr calculatedResult = function.apply(symbolValue);
            if (calculatedResult != null) {
                pme.setRHS(calculatedResult);
                result[1] = calculatedResult;
                return result;
            }
        }
        throw new WrongArgumentType(this, functionSymbol.toString() + " - Symbol: " + this.toString() + " has no value! Reassignment with a new value is not possible");
    }

    @Override
    public boolean hasAssignedSymbolValue() {
        PatternMatcherEquals pme;
        if (this.hasLocalVariableStack()) {
            return this.get() != null;
        }
        if (this.fDownRulesData != null && (pme = this.fDownRulesData.getEqualDownRules().get(this)) != null) {
            return pme.getRHS() != null;
        }
        return false;
    }

    @Override
    public IExpr getAssignedValue() {
        PatternMatcherEquals pme;
        if (this.hasLocalVariableStack()) {
            return this.get();
        }
        if (this.fDownRulesData != null && (pme = this.fDownRulesData.getEqualDownRules().get(this)) != null) {
            return pme.getRHS();
        }
        return null;
    }

    public Symbol(String symbolName) {
        this(symbolName, null);
    }

    public Symbol(String symbolName, IEvaluator evaluator) {
        this.fHashValue = symbolName == null ? 197 : 7 * symbolName.hashCode();
        this.fSymbolName = symbolName;
        this.fEvaluator = evaluator;
    }

    @Override
    public IExpr apply(IExpr ... expressions) {
        return F.ast(expressions, this);
    }

    @Override
    public void pushLocalVariable() {
        this.pushLocalVariable(null);
    }

    @Override
    public void pushLocalVariable(IExpr expression) {
        Stack<IExpr> localVariableStack = EvalEngine.localStackCreate(this);
        localVariableStack.push(expression);
    }

    @Override
    public void popLocalVariable() {
        Stack<IExpr> localVariableStack = EvalEngine.localStack(this);
        localVariableStack.pop();
    }

    @Override
    public void clear(EvalEngine engine) {
        if (!engine.isPackageMode() && Config.SERVER_MODE && this.fSymbolName.charAt(0) != '$') {
            throw new RuleCreationError(null);
        }
        if (this.fDownRulesData != null) {
            this.fDownRulesData.clear();
        }
    }

    @Override
    public void clearAll(EvalEngine engine) {
        this.clear(engine);
        this.fAttributes = 0;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public boolean isSymbolName(String name) {
        if (Config.PARSER_USE_LOWERCASE_SYMBOLS) {
            if (this.fSymbolName.length() == 1) {
                return this.fSymbolName.equals(name);
            }
            return this.fSymbolName.equalsIgnoreCase(name);
        }
        return this.fSymbolName.equals(name);
    }

    @Override
    public IExpr evaluate(EvalEngine engine) {
        if (this.hasLocalVariableStack()) {
            return this.get();
        }
        IExpr result = this.evalDownRule(engine, this);
        if (result != null) {
            return result;
        }
        IEvaluator module = this.getEvaluator();
        if (module instanceof ISymbolEvaluator) {
            if (engine.isNumericMode()) {
                if (engine.isApfloat()) {
                    return ((ISymbolEvaluator)module).apfloatEval(this, engine);
                }
                return ((ISymbolEvaluator)module).numericEval(this);
            }
            return ((ISymbolEvaluator)module).evaluate(this);
        }
        return null;
    }

    @Override
    public IExpr evalDownRule(IEvaluationEngine ee, IExpr expression) {
        if (this.fDownRulesData == null) {
            return null;
        }
        return this.fDownRulesData.evalDownRule(ee, expression);
    }

    @Override
    public IExpr evalUpRule(IEvaluationEngine ee, IExpr expression) {
        if (this.fUpRulesData == null) {
            return null;
        }
        return this.fUpRulesData.evalUpRule(ee, expression);
    }

    @Override
    public final int getAttributes() {
        return this.fAttributes;
    }

    @Override
    public IEvaluator getEvaluator() {
        if (this.fEvaluator == null) {
            this.fEvaluator = DUMMY_EVALUATOR;
            if (Config.PARSER_USE_LOWERCASE_SYMBOLS) {
                SystemNamespace.DEFAULT.setEvaluator(this);
            } else if (Character.isUpperCase(this.fSymbolName.charAt(0))) {
                SystemNamespace.DEFAULT.setEvaluator(this);
            }
        }
        return this.fEvaluator;
    }

    @Override
    public boolean hasLocalVariableStack() {
        Stack<IExpr> localVariableStack = EvalEngine.localStack(this);
        return localVariableStack != null && !localVariableStack.isEmpty();
    }

    @Override
    public IExpr get() {
        Stack<IExpr> localVariableStack = EvalEngine.localStack(this);
        if (localVariableStack == null) {
            return null;
        }
        return localVariableStack.peek();
    }

    @Override
    public void set(IExpr value) {
        Stack<IExpr> localVariableStack = EvalEngine.localStack(this);
        localVariableStack.set(localVariableStack.size() - 1, value);
    }

    @Override
    public int hashCode() {
        return this.fHashValue;
    }

    @Override
    public int hierarchy() {
        return 128;
    }

    @Override
    public final boolean isString(String str) {
        return this.fSymbolName.equals(str);
    }

    @Override
    public IPatternMatcher putDownRule(ISymbol symbol, boolean equalRule, IExpr leftHandSide, IExpr rightHandSide, boolean packageMode) {
        return this.putDownRule(symbol, equalRule, leftHandSide, rightHandSide, Integer.MAX_VALUE, packageMode);
    }

    @Override
    public IPatternMatcher putDownRule(ISymbol setSymbol, boolean equalRule, IExpr leftHandSide, IExpr rightHandSide, int priority, boolean packageMode) {
        if (!packageMode) {
            if (Config.SERVER_MODE && this.fSymbolName.charAt(0) != '$') {
                throw new RuleCreationError(leftHandSide);
            }
            EvalEngine.get().addModifiedVariable(this);
        }
        if (this.fDownRulesData == null) {
            this.fDownRulesData = new DownRulesData();
        }
        return this.fDownRulesData.putDownRule(setSymbol, equalRule, leftHandSide, rightHandSide);
    }

    @Override
    public PatternMatcher putDownRule(PatternMatcherAndInvoker pmEvaluator) {
        if (this.fDownRulesData == null) {
            this.fDownRulesData = new DownRulesData();
        }
        return this.fDownRulesData.putDownRule(pmEvaluator);
    }

    @Override
    public IPatternMatcher putUpRule(ISymbol symbol, boolean equalRule, IAST leftHandSide, IExpr rightHandSide) {
        return this.putUpRule(symbol, equalRule, leftHandSide, rightHandSide, Integer.MAX_VALUE);
    }

    @Override
    public IPatternMatcher putUpRule(ISymbol setSymbol, boolean equalRule, IAST leftHandSide, IExpr rightHandSide, int priority) {
        EvalEngine engine = EvalEngine.get();
        if (!engine.isPackageMode()) {
            if (Config.SERVER_MODE && this.fSymbolName.charAt(0) != '$') {
                throw new RuleCreationError(leftHandSide);
            }
            engine.addModifiedVariable(this);
        }
        if (this.fUpRulesData == null) {
            this.fUpRulesData = new UpRulesData();
        }
        return this.fUpRulesData.putUpRule(setSymbol, equalRule, leftHandSide, rightHandSide);
    }

    @Override
    public void setAttributes(int attributes) {
        this.fAttributes = attributes;
        if (this.fSymbolName.charAt(0) == '$' && Config.SERVER_MODE) {
            EvalEngine engine = EvalEngine.get();
            engine.addModifiedVariable(this);
        }
    }

    @Override
    public final void setEvaluator(IEvaluator evaluator) {
        this.fEvaluator = evaluator;
        evaluator.setUp(this);
    }

    @Override
    public int compareTo(IExpr expr) {
        if (expr instanceof Symbol) {
            if (this == expr) {
                return 0;
            }
            return this.fSymbolName.compareTo(((Symbol)expr).fSymbolName);
        }
        if (expr instanceof AST) {
            AST ast = (AST)expr;
            if (ast.size() > 1) {
                if (ast.isPower()) {
                    if (ast.arg1() instanceof ISymbol) {
                        int cp = this.fSymbolName.compareTo(((Symbol)ast.arg1()).fSymbolName);
                        if (cp != 0) {
                            return cp;
                        }
                        if (EvalEngine.get().isNumericMode()) {
                            return F.CD1.compareTo((IExpr)ast.get(2));
                        }
                        return F.C1.compareTo((IExpr)ast.get(2));
                    }
                } else if (ast.isTimes()) {
                    IExpr lastTimesHeader;
                    IExpr lastTimes = ast.last();
                    if (lastTimes instanceof AST && (lastTimesHeader = ((IAST)lastTimes).head()) == F.Power && ((IAST)lastTimes).size() == 3) {
                        int cp = this.compareTo(((IAST)lastTimes).arg1());
                        if (cp != 0) {
                            return cp;
                        }
                        return F.C1.compareTo(((IAST)lastTimes).arg2());
                    }
                    int cp = this.compareTo(lastTimes);
                    if (cp != 0) {
                        return cp;
                    }
                }
            }
            return -1;
        }
        return super.compareTo(expr);
    }

    @Override
    public final boolean isAtom() {
        return true;
    }

    @Override
    public boolean isConstant() {
        return (this.fAttributes & 2) == 2;
    }

    @Override
    public boolean isE() {
        return this.equals(F.E);
    }

    @Override
    public boolean isTrue() {
        return this.equals(F.True);
    }

    @Override
    public final boolean isValue() {
        return this.evaluate(EvalEngine.get()) != null;
    }

    @Override
    public boolean isFalse() {
        return this.equals(F.False);
    }

    @Override
    public boolean isIndeterminate() {
        return this.equals(F.Indeterminate);
    }

    @Override
    public boolean isNegative() {
        IExpr temp;
        return this.isNumericFunction() && (temp = F.evaln(this)).isSignedNumber() && temp.isNegative();
    }

    @Override
    public boolean isPi() {
        return this.equals(F.Pi);
    }

    @Override
    public boolean isPolynomial(ISymbol variable) {
        return true;
    }

    @Override
    public boolean isPolynomial(IAST variables) {
        return true;
    }

    @Override
    public boolean isPolynomialOfMaxDegree(ISymbol variable, long maxDegree) {
        return maxDegree != 0L || !this.equals(variable);
    }

    @Override
    public boolean isPositive() {
        IExpr temp;
        return this.isNumericFunction() && (temp = F.evaln(this)).isSignedNumber() && temp.isPositive();
    }

    @Override
    public ISymbol head() {
        return F.SymbolHead;
    }

    @Override
    public final String getSymbolName() {
        return this.fSymbolName;
    }

    @Override
    public IExpr variables2Slots(Map<IExpr, IExpr> map, List<IExpr> variableList) {
        UnaryVariable2Slot uv2s = new UnaryVariable2Slot(map, variableList);
        return uv2s.apply(this);
    }

    @Override
    public String internalFormString(boolean symbolsAsFactoryMethod, int depth) {
        String name;
        if (symbolsAsFactoryMethod) {
            String alias;
            char ch;
            if (this.fSymbolName.length() == 1 && Character.isLowerCase(this.fSymbolName.charAt(0)) && 'a' <= (ch = this.fSymbolName.charAt(0)) && ch <= 'z') {
                return this.fSymbolName;
            }
            if (Config.RUBI_CONVERT_SYMBOLS && this.fSymbolName.length() == 2 && '\u00a7' == this.fSymbolName.charAt(0) && Character.isLowerCase(this.fSymbolName.charAt(1)) && 'a' <= (ch = this.fSymbolName.charAt(1)) && ch <= 'z') {
                return "p" + ch;
            }
            if (Character.isUpperCase(this.fSymbolName.charAt(0)) && (alias = F.PREDEFINED_INTERNAL_FORM_STRINGS.get(this.fSymbolName)) != null) {
                if (alias.contains("::")) {
                    return "$s(\"" + alias + "\")";
                }
                return alias;
            }
            return "$s(\"" + this.fSymbolName + "\")";
        }
        if (Config.PARSER_USE_LOWERCASE_SYMBOLS && (name = this.fSymbolName.length() == 1 ? AST2Expr.PREDEFINED_SYMBOLS_MAP.get(this.fSymbolName.toString()) : AST2Expr.PREDEFINED_SYMBOLS_MAP.get(this.fSymbolName.toString().toLowerCase())) != null) {
            return name;
        }
        return this.fSymbolName;
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            OutputFormFactory.get(EvalEngine.get().isRelaxedSyntax()).convertSymbol(sb, this);
            return sb.toString();
        }
        catch (Exception exception) {
            return this.fSymbolName;
        }
    }

    @Override
    public String fullFormString() {
        String str;
        if (Config.PARSER_USE_LOWERCASE_SYMBOLS && (str = AST2Expr.PREDEFINED_SYMBOLS_MAP.get(this.fSymbolName)) != null) {
            return str;
        }
        return this.fSymbolName;
    }

    @Override
    public List<IAST> definition() {
        ArrayList<IAST> result = new ArrayList<IAST>();
        if (this.fDownRulesData != null) {
            result.addAll(this.fDownRulesData.definition());
        }
        if (this.fUpRulesData == null) {
            return result;
        }
        result.addAll(this.fUpRulesData.definition());
        return result;
    }

    @Override
    public IExpr getDefaultValue() {
        if (this.fDefaultValues == null) {
            return null;
        }
        return this.fDefaultValues.get(Integer.MIN_VALUE);
    }

    @Override
    public IExpr getDefaultValue(int pos) {
        if (this.fDefaultValues == null) {
            return null;
        }
        return this.fDefaultValues.get(pos);
    }

    @Override
    public void setDefaultValue(IExpr expr) {
        if (this.fDefaultValues == null) {
            this.fDefaultValues = new OpenIntToIExprHashMap();
        }
        this.fDefaultValues.put(Integer.MIN_VALUE, expr);
    }

    @Override
    public void setDefaultValue(int pos, IExpr expr) {
        if (this.fDefaultValues == null) {
            this.fDefaultValues = new OpenIntToIExprHashMap();
        }
        this.fDefaultValues.put(pos, expr);
    }

    @Override
    public String definitionToString() throws IOException {
        this.getEvaluator();
        StringWriter buf = new StringWriter();
        OutputFormFactory off = OutputFormFactory.get();
        off.setIgnoreNewLine(true);
        List<IAST> list = this.definition();
        buf.append("{");
        for (int i = 0; i < list.size(); ++i) {
            off.convert(buf, list.get(i));
            if (i >= list.size() - 1) continue;
            buf.append(",\n ");
            off.setColumnCounter(0);
        }
        buf.append("}\n");
        return buf.toString();
    }

    @Override
    public void readSymbol(ObjectInputStream stream) throws IOException {
        boolean hasUpRulesData;
        this.fSymbolName = stream.readUTF();
        this.fAttributes = stream.read();
        boolean hasDownRulesData = stream.readBoolean();
        if (hasDownRulesData) {
            this.fDownRulesData.readSymbol(stream);
        }
        if (hasUpRulesData = stream.readBoolean()) {
            this.fUpRulesData.readSymbol(stream);
        }
    }

    @Override
    public void writeSymbol(ObjectOutputStream stream) throws IOException {
        stream.writeUTF(this.fSymbolName);
        stream.write(this.fAttributes);
        if (this.fDownRulesData == null) {
            stream.writeBoolean(false);
        } else {
            stream.writeBoolean(true);
            this.fDownRulesData.writeSymbol(stream);
        }
        if (this.fUpRulesData == null) {
            stream.writeBoolean(false);
        } else {
            stream.writeBoolean(true);
            this.fUpRulesData.writeSymbol(stream);
        }
    }

    @Override
    public <T> T accept(IVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }

    @Override
    public long accept(IVisitorLong visitor) {
        return visitor.visit(this);
    }

    @Override
    public IExpr mapConstantDouble(INumericFunction<IExpr> function) {
        ISignedNumberConstant numericConstant;
        double value;
        IEvaluator evaluator;
        if (this.isConstant() && (evaluator = this.getEvaluator()) instanceof ISignedNumberConstant && (value = (numericConstant = (ISignedNumberConstant)((Object)evaluator)).evalReal()) < 2.147483647E9 && value > -2.147483648E9) {
            return function.apply(value);
        }
        return null;
    }

    @Override
    public IExpr negate() {
        return F.Times((IExpr)F.CN1, (IExpr)this);
    }

    static class DummyEvaluator
    implements IEvaluator {
        DummyEvaluator() {
        }

        @Override
        public void setUp(ISymbol symbol) {
        }
    }
}

