/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Map;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.ExprImpl;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.Predicates;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.IPatternMatcher;
import org.matheclipse.core.patternmatching.PatternMap;
import org.matheclipse.core.patternmatching.PatternMatcher;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;
import org.matheclipse.core.visit.IVisitorLong;

public class Pattern
extends ExprImpl
implements IPattern {
    private static final long serialVersionUID = 7617138748475243L;
    private static Pattern NULL_PATTERN = new Pattern(null);
    final IExpr fCondition;
    final int fHashValue;
    final ISymbol fSymbol;
    final boolean fDefault;

    public static IPattern valueOf(ISymbol symbol, IExpr check, boolean def) {
        return new Pattern(symbol, check, def);
    }

    public static IPattern valueOf(ISymbol symbol, IExpr check) {
        return new Pattern(symbol, check);
    }

    public static IPattern valueOf(ISymbol symbol) {
        if (symbol == null) {
            return NULL_PATTERN;
        }
        IPattern value = F.PREDEFINED_PATTERN_MAP.get(symbol.toString());
        if (value != null) {
            return value;
        }
        return new Pattern(symbol);
    }

    private Pattern() {
        this(null, null, false);
    }

    Pattern(ISymbol symbol) {
        this(symbol, null, false);
    }

    Pattern(ISymbol symbol, IExpr condition) {
        this(symbol, condition, false);
    }

    public Pattern(ISymbol symbol, IExpr condition, boolean def) {
        this.fHashValue = symbol == null ? 199 : 19 + symbol.hashCode();
        this.fSymbol = symbol;
        this.fCondition = condition;
        this.fDefault = def;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Pattern) {
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            Pattern pattern = (Pattern)obj;
            if (this.fSymbol == pattern.fSymbol) {
                if (this.fCondition != null && pattern.fCondition != null) {
                    return this.fCondition.equals(pattern.fCondition);
                }
                return this.fCondition == pattern.fCondition;
            }
        }
        return false;
    }

    @Override
    public IExpr getCondition() {
        return this.fCondition;
    }

    @Override
    public int getIndex(PatternMap pm) {
        if (pm != null) {
            return pm.get(this.fSymbol);
        }
        return -1;
    }

    @Override
    public ISymbol getSymbol() {
        return this.fSymbol;
    }

    @Override
    public int hashCode() {
        return this.fHashValue;
    }

    @Override
    public int hierarchy() {
        return 256;
    }

    @Override
    public String internalFormString(boolean symbolsAsFactoryMethod, int depth) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("$p(");
        if (this.fSymbol == null) {
            buffer.append("(ISymbol)null");
            if (this.fCondition != null) {
                buffer.append("," + this.fCondition.internalFormString(symbolsAsFactoryMethod, 0));
            }
            if (this.fDefault) {
                if (this.fCondition == null) {
                    buffer.append(",null");
                }
                buffer.append(",true");
            }
        } else {
            char ch2;
            String symbolStr = this.fSymbol.toString();
            char ch = symbolStr.charAt(0);
            if (symbolStr.length() == 1 && 'a' <= ch && ch <= 'z') {
                if (!this.fDefault) {
                    if (this.fCondition == null) {
                        if (ch == 'd' || ch == 'e' || ch == 'i') {
                            return "$p(" + symbolStr + ")";
                        }
                        return symbolStr + "_";
                    }
                    if (this.fCondition == F.SymbolHead) {
                        if (ch == 'x') {
                            return "x_Symbol";
                        }
                        if (ch == 'y') {
                            return "y_Symbol";
                        }
                        if (ch == 'z') {
                            return "z_Symbol";
                        }
                    }
                } else if (this.fCondition == null && ch != 'd' && ch != 'e' && ch != 'i') {
                    return symbolStr + "_DEFAULT";
                }
            }
            if (Config.RUBI_CONVERT_SYMBOLS && ch == '\u00a7' && symbolStr.length() == 2 && 'a' <= (ch2 = symbolStr.charAt(1)) && ch2 <= 'z') {
                if (!this.fDefault) {
                    if (this.fCondition == null) {
                        return "p" + ch2 + "_";
                    }
                } else if (this.fCondition == null) {
                    return "p" + ch2 + "_DEFAULT";
                }
            }
            if (symbolStr.length() == 1 && 'a' <= ch && ch <= 'z') {
                buffer.append(symbolStr);
            } else {
                buffer.append("\"" + symbolStr + "\"");
            }
            if (this.fCondition != null) {
                if (this.fCondition == F.SymbolHead) {
                    buffer.append(", SymbolHead");
                } else {
                    buffer.append("," + this.fCondition.internalFormString(symbolsAsFactoryMethod, 0));
                }
            }
            if (this.fDefault) {
                buffer.append(",true");
            }
        }
        buffer.append(')');
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.fSymbol == null) {
            buffer.append('_');
            if (this.fDefault) {
                buffer.append('.');
            }
            if (this.fCondition != null) {
                buffer.append(this.fCondition.toString());
            }
        } else if (this.fCondition == null) {
            buffer.append(this.fSymbol.toString());
            buffer.append('_');
            if (this.fDefault) {
                buffer.append('.');
            }
        } else {
            buffer.append(this.fSymbol.toString());
            buffer.append('_');
            if (this.fDefault) {
                buffer.append('.');
            }
            buffer.append(this.fCondition.toString());
        }
        return buffer.toString();
    }

    @Override
    public String fullFormString() {
        StringBuffer buf = new StringBuffer();
        if (this.fSymbol == null) {
            buf.append("Blank");
            if (Config.PARSER_USE_LOWERCASE_SYMBOLS) {
                buf.append('(');
            } else {
                buf.append('[');
            }
            if (this.fCondition != null) {
                buf.append(this.fCondition.fullFormString());
            }
            if (Config.PARSER_USE_LOWERCASE_SYMBOLS) {
                buf.append(')');
            } else {
                buf.append(']');
            }
        } else {
            buf.append("Pattern");
            if (Config.PARSER_USE_LOWERCASE_SYMBOLS) {
                buf.append('(');
            } else {
                buf.append('[');
            }
            buf.append(this.fSymbol.toString());
            buf.append(", ");
            buf.append("Blank");
            if (Config.PARSER_USE_LOWERCASE_SYMBOLS) {
                buf.append('(');
            } else {
                buf.append('[');
            }
            if (this.fCondition != null) {
                buf.append(this.fCondition.fullFormString());
            }
            if (Config.PARSER_USE_LOWERCASE_SYMBOLS) {
                buf.append("))");
            } else {
                buf.append("]]");
            }
        }
        return buf.toString();
    }

    @Override
    public int compareTo(IExpr expr) {
        if (expr instanceof Pattern) {
            int cp = this.fSymbol == null ? (((Pattern)expr).fSymbol == null ? -1 : 0) : (((Pattern)expr).fSymbol == null ? 1 : this.fSymbol.compareTo(((Pattern)expr).fSymbol));
            if (cp != 0) {
                return cp;
            }
            if (this.fCondition == null) {
                if (((Pattern)expr).fCondition != null) {
                    return -1;
                }
                return 0;
            }
            if (((Pattern)expr).fCondition == null) {
                return 1;
            }
            return this.fCondition.compareTo(((Pattern)expr).fCondition);
        }
        return super.compareTo(expr);
    }

    @Override
    public ISymbol head() {
        return F.PatternHead;
    }

    @Override
    public boolean isBlank() {
        return this.fSymbol == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConditionMatched(IExpr expr) {
        if (this.fCondition == null) {
            return true;
        }
        if (expr.head().equals(this.fCondition)) {
            return true;
        }
        EvalEngine engine = EvalEngine.get();
        boolean traceMode = false;
        try {
            traceMode = engine.isTraceMode();
            engine.setTraceMode(false);
            Predicate<IExpr> matcher = Predicates.isTrue(engine, this.fCondition);
            boolean bl = matcher.apply(expr);
            return bl;
        }
        finally {
            if (traceMode) {
                engine.setTraceMode(true);
            }
        }
    }

    @Override
    public IExpr variables2Slots(Map<IExpr, IExpr> map, List<IExpr> variableList) {
        return null;
    }

    @Override
    public <T> T accept(IVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }

    @Override
    public long accept(IVisitorLong visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean isPatternDefault() {
        return this.fDefault;
    }

    @Override
    public final boolean isPattern() {
        return true;
    }

    @Override
    public final boolean isPatternExpr() {
        return true;
    }

    public boolean isCase(IExpr that) {
        PatternMatcher matcher = new PatternMatcher(this);
        return ((IPatternMatcher)matcher).apply(that);
    }
}

