/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import org.apache.commons.math3.util.MathUtils;
import org.apfloat.Apcomplex;
import org.apfloat.Apfloat;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.ApcomplexNum;
import org.matheclipse.core.expression.ApfloatNum;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.ExprImpl;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.NumberUtil;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;
import org.matheclipse.core.visit.IVisitorLong;

public class Num
extends ExprImpl
implements INum {
    private static final long serialVersionUID = 188084692735007429L;
    double fDouble;

    protected static Num newInstance(double value) {
        Num d = new Num(0.0);
        d.fDouble = value;
        return d;
    }

    private Num(double value) {
        this.fDouble = value;
    }

    @Override
    public int hierarchy() {
        return 2;
    }

    @Override
    public boolean isNumEqualInteger(IInteger ii) throws ArithmeticException {
        return F.isNumEqualInteger(this.fDouble, ii);
    }

    @Override
    public boolean isNumIntValue() {
        return F.isNumIntValue(this.fDouble);
    }

    @Override
    public boolean isNegative() {
        return this.fDouble < 0.0;
    }

    @Override
    public boolean isPositive() {
        return this.fDouble > 0.0;
    }

    @Override
    public boolean equalsInt(int i) {
        return this.fDouble == (double)i;
    }

    @Override
    public IExpr evaluate(EvalEngine engine) {
        if (engine.isNumericMode() && engine.isApfloat()) {
            return ApfloatNum.valueOf(this.fDouble, (long)engine.getNumericPrecision());
        }
        return null;
    }

    @Override
    public INum add(INum val) {
        return Num.valueOf(this.fDouble + val.getRealPart());
    }

    @Override
    public INum multiply(INum val) {
        return Num.valueOf(this.fDouble * val.getRealPart());
    }

    @Override
    public INum pow(INum val) {
        return Num.valueOf(Math.pow(this.fDouble, val.getRealPart()));
    }

    public static double valueOf(String chars) {
        return Double.parseDouble(chars);
    }

    public static Num valueOf(double doubleValue) {
        return Num.newInstance(doubleValue);
    }

    @Override
    public Num eabs() {
        return Num.newInstance(Math.abs(this.fDouble));
    }

    @Override
    public int compareAbsValueToOne() {
        double temp = Math.abs(this.fDouble);
        return Double.compare(temp, 1.0);
    }

    public double plus(double that) {
        return this.fDouble + that;
    }

    @Override
    public IExpr plus(IExpr that) {
        if (that instanceof ApfloatNum) {
            return this.add(ApfloatNum.valueOf(this.fDouble, ((ApfloatNum)that).fApfloat.precision()));
        }
        if (that instanceof Num) {
            return Num.newInstance(this.fDouble + ((Num)that).fDouble);
        }
        if (that instanceof ApcomplexNum) {
            return ApcomplexNum.valueOf(this.fDouble, ((ApcomplexNum)that).fApcomplex.precision()).add((ApcomplexNum)that);
        }
        if (that instanceof ComplexNum) {
            return ComplexNum.valueOf(this.fDouble).add((ComplexNum)that);
        }
        return super.plus(that);
    }

    @Override
    public ISignedNumber divideBy(ISignedNumber that) {
        return Num.valueOf(this.doubleValue() / that.doubleValue());
    }

    @Override
    public ISignedNumber subtractFrom(ISignedNumber that) {
        return Num.valueOf(this.doubleValue() - that.doubleValue());
    }

    @Override
    public int compareTo(double that) {
        return Double.compare(this.fDouble, that);
    }

    @Override
    public double divide(double that) {
        return this.fDouble / that;
    }

    @Override
    public double doubleValue() {
        return this.fDouble;
    }

    @Override
    public boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 instanceof Num) {
            return this.fDouble == ((Num)arg0).fDouble;
        }
        return false;
    }

    @Override
    public boolean isSame(IExpr expression, double epsilon) {
        if (expression instanceof Num) {
            return F.isZero(this.fDouble - ((Num)expression).fDouble, epsilon);
        }
        return false;
    }

    public double exp() {
        return Math.exp(this.fDouble);
    }

    @Override
    public final int hashCode() {
        return MathUtils.hash(this.fDouble);
    }

    @Override
    public int intValue() {
        return Double.valueOf(this.fDouble).intValue();
    }

    @Override
    public int toInt() throws ArithmeticException {
        return NumberUtil.toInt(this.fDouble);
    }

    @Override
    public long toLong() throws ArithmeticException {
        return NumberUtil.toLong(this.fDouble);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.fDouble);
    }

    public boolean isNaN() {
        return Double.isNaN(this.fDouble);
    }

    public double log() {
        return Math.log(this.fDouble);
    }

    public long longValue() {
        return Double.valueOf(this.fDouble).longValue();
    }

    public double times(double that) {
        return this.fDouble * that;
    }

    @Override
    public IExpr times(IExpr that) {
        if (that instanceof ApfloatNum) {
            return this.multiply(ApfloatNum.valueOf(this.fDouble, ((ApfloatNum)that).fApfloat.precision()));
        }
        if (that instanceof Num) {
            return Num.newInstance(this.fDouble * ((Num)that).fDouble);
        }
        if (that instanceof ApcomplexNum) {
            return ApcomplexNum.valueOf(this.fDouble, ((ApcomplexNum)that).fApcomplex.precision()).multiply((ApcomplexNum)that);
        }
        if (that instanceof ComplexNum) {
            return ComplexNum.valueOf(this.fDouble).multiply((ComplexNum)that);
        }
        return super.times(that);
    }

    @Override
    public ISignedNumber negate() {
        return Num.newInstance(-this.fDouble);
    }

    @Override
    public ISignedNumber opposite() {
        return Num.newInstance(-this.fDouble);
    }

    public double pow(double that) {
        return Math.pow(this.fDouble, that);
    }

    public double pow(int exp) {
        return Math.pow(this.fDouble, exp);
    }

    @Override
    public ISignedNumber inverse() {
        return Num.newInstance(1.0 / this.fDouble);
    }

    public double sqrt() {
        return Math.sqrt(this.fDouble);
    }

    public double minus(double that) {
        return this.fDouble - that;
    }

    @Override
    public double getRealPart() {
        double temp = this.fDouble;
        if (temp == -0.0) {
            temp = 0.0;
        }
        return temp;
    }

    @Override
    public boolean isE() {
        return F.isZero(this.fDouble - Math.E);
    }

    @Override
    public boolean isOne() {
        return F.isZero(this.fDouble - 1.0);
    }

    @Override
    public boolean isMinusOne() {
        return F.isZero(this.fDouble + 1.0);
    }

    @Override
    public boolean isPi() {
        return F.isZero(this.fDouble - Math.PI);
    }

    @Override
    public boolean isZero() {
        return F.isZero(this.fDouble);
    }

    @Override
    public IInteger round() {
        return F.integer(NumberUtil.toLong(Math.rint(this.fDouble)));
    }

    @Override
    public int sign() {
        return (int)Math.signum(this.fDouble);
    }

    @Override
    public int complexSign() {
        return this.sign();
    }

    @Override
    public IInteger ceil() {
        return F.integer(NumberUtil.toLong(Math.ceil(this.fDouble)));
    }

    @Override
    public IInteger floor() {
        return F.integer(NumberUtil.toLong(Math.floor(this.fDouble)));
    }

    @Override
    public int compareTo(IExpr expr) {
        if (expr instanceof Num) {
            return Double.compare(this.fDouble, ((Num)expr).fDouble);
        }
        return super.compareTo(expr);
    }

    @Override
    public boolean isLessThan(ISignedNumber that) {
        return this.fDouble < that.doubleValue();
    }

    @Override
    public boolean isGreaterThan(ISignedNumber that) {
        return this.fDouble > that.doubleValue();
    }

    @Override
    public ISymbol head() {
        return F.RealHead;
    }

    public String toString() {
        if (this.fDouble == -0.0) {
            return "0.0";
        }
        return Double.valueOf(this.fDouble).toString();
    }

    @Override
    public <T> T accept(IVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }

    @Override
    public long accept(IVisitorLong visitor) {
        return visitor.visit(this);
    }

    @Override
    public ISignedNumber getIm() {
        return F.CD0;
    }

    @Override
    public ISignedNumber getRe() {
        return this;
    }

    @Override
    public ApfloatNum apfloatNumValue(long precision) {
        return ApfloatNum.valueOf(this.fDouble, precision);
    }

    @Override
    public Num numValue() {
        return this;
    }

    public Apcomplex apcomplexValue(long precision) {
        return new Apcomplex(new Apfloat(this.fDouble, precision));
    }

    @Override
    public ApcomplexNum apcomplexNumValue(long precision) {
        return ApcomplexNum.valueOf(this.apcomplexValue(precision));
    }

    @Override
    public ComplexNum complexNumValue() {
        return ComplexNum.valueOf(this.doubleValue(), 0.0);
    }
}

