/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import com.google.common.math.BigIntegerMath;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.math3.fraction.BigFraction;
import org.apfloat.Apcomplex;
import org.apfloat.Apfloat;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.ApcomplexNum;
import org.matheclipse.core.expression.ApfloatNum;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.ComplexSym;
import org.matheclipse.core.expression.ExprImpl;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.FractionSym;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.expression.NumberUtil;
import org.matheclipse.core.expression.Primality;
import org.matheclipse.core.form.output.OutputFormFactory;
import org.matheclipse.core.generic.combinatoric.KSubsetsList;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;
import org.matheclipse.core.visit.IVisitorLong;

public class IntegerSym
extends ExprImpl
implements IInteger {
    public static final BigInteger BI_MINUS_ONE = BigInteger.valueOf(-1L);
    private static final long serialVersionUID = 6389228668633533063L;
    BigInteger fInteger = null;
    private transient int fHashValue = 0;

    protected static IntegerSym newInstance(BigInteger value) {
        IntegerSym z = new IntegerSym();
        z.fInteger = value;
        return z;
    }

    public static IntegerSym valueOf(long value) {
        IntegerSym z = new IntegerSym();
        z.fInteger = BigInteger.valueOf(value);
        return z;
    }

    public static IntegerSym valueOf(String integerString, int radix) {
        IntegerSym z = new IntegerSym();
        z.fInteger = new BigInteger(integerString, radix);
        return z;
    }

    private IntegerSym() {
    }

    @Override
    public boolean equalsInt(int i) {
        return this.fInteger.equals(BigInteger.valueOf(i));
    }

    @Override
    public IExpr evaluate(EvalEngine engine) {
        if (engine.isNumericMode()) {
            return this.numericNumber();
        }
        return null;
    }

    @Override
    public final INumber numericNumber() {
        return F.num(this);
    }

    @Override
    public int hierarchy() {
        return 8;
    }

    @Override
    public IInteger add(IInteger val) {
        return IntegerSym.newInstance(this.fInteger.add(val.getBigNumerator()));
    }

    @Override
    public IInteger multiply(IInteger val) {
        return IntegerSym.newInstance(this.fInteger.multiply(val.getBigNumerator()));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IntegerSym) {
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            return this.fInteger.equals(((IntegerSym)obj).fInteger);
        }
        return false;
    }

    public static IntegerSym valueOf(BigInteger bigInteger) {
        return IntegerSym.newInstance(bigInteger);
    }

    @Override
    public IExpr[] egcd(IExpr that) {
        if (that instanceof IntegerSym) {
            BigInteger S = ((IntegerSym)that).fInteger;
            IExpr[] result = new IInteger[]{null, F.C1, F.C1};
            if (that == null || that.isZero()) {
                result[0] = this;
                return result;
            }
            if (this.isZero()) {
                result[0] = (IntegerSym)that;
                return result;
            }
            BigInteger q = this.fInteger;
            BigInteger r = S;
            BigInteger c1 = BigInteger.ONE;
            BigInteger d1 = BigInteger.ZERO;
            BigInteger c2 = BigInteger.ZERO;
            BigInteger d2 = BigInteger.ONE;
            while (!r.equals(BigInteger.ZERO)) {
                BigInteger[] qr = q.divideAndRemainder(r);
                q = qr[0];
                BigInteger x1 = c1.subtract(q.multiply(d1));
                BigInteger x2 = c2.subtract(q.multiply(d2));
                c1 = d1;
                c2 = d2;
                d1 = x1;
                d2 = x2;
                q = r;
                r = qr[1];
            }
            if (q.signum() < 0) {
                q = q.negate();
                c1 = c1.negate();
                c2 = c2.negate();
            }
            result[0] = IntegerSym.valueOf(q);
            result[1] = IntegerSym.valueOf(c1);
            result[2] = IntegerSym.valueOf(c2);
            return result;
        }
        return super.egcd(that);
    }

    @Override
    public IntegerSym eabs() {
        return IntegerSym.newInstance(this.fInteger.abs());
    }

    @Override
    public int compareAbsValueToOne() {
        BigInteger temp = this.fInteger;
        if (this.fInteger.compareTo(BigInteger.ZERO) < 0) {
            temp = temp.negate();
        }
        return temp.compareTo(BigInteger.ONE);
    }

    public IntegerSym add(IntegerSym that) {
        return IntegerSym.newInstance(this.fInteger.add(that.fInteger));
    }

    public int bitLength() {
        return this.fInteger.bitLength();
    }

    @Override
    public BigInteger divide(long val) {
        return this.fInteger.divide(BigInteger.valueOf(val));
    }

    @Override
    public BigInteger divide(BigInteger that) {
        return this.fInteger.divide(that);
    }

    public IntegerSym quotient(IntegerSym that) {
        return IntegerSym.newInstance(this.fInteger.divide(that.fInteger));
    }

    @Override
    public double doubleValue() {
        return this.fInteger.doubleValue();
    }

    @Override
    public IntegerSym gcd(IntegerSym that) {
        return IntegerSym.newInstance(this.fInteger.gcd(that.fInteger));
    }

    @Override
    public IInteger gcd(IInteger that) {
        return IntegerSym.newInstance(this.fInteger.gcd(((IntegerSym)that).fInteger));
    }

    @Override
    public IExpr gcd(IExpr that) {
        if (that instanceof IInteger) {
            return this.gcd((IInteger)that);
        }
        return F.C1;
    }

    public IntegerSym lcm(IntegerSym that) {
        if (this.isZero() && that.isZero()) {
            return F.C0;
        }
        BigInteger lcm = IntegerSym.lcm(this.fInteger, that.fInteger);
        return IntegerSym.newInstance(lcm);
    }

    public static BigInteger lcm(BigInteger i0, BigInteger i1) {
        if (i0.equals(BigInteger.ZERO) && i1.equals(BigInteger.ZERO)) {
            return BigInteger.ZERO;
        }
        BigInteger a = i0.abs();
        BigInteger b = i1.abs();
        BigInteger gcd = i0.gcd(b);
        BigInteger lcm = a.multiply(b).divide(gcd);
        return lcm;
    }

    @Override
    public IInteger lcm(IInteger that) {
        return this.lcm((IntegerSym)that);
    }

    @Override
    public final int hashCode() {
        if (this.fHashValue == 0) {
            this.fHashValue = this.fInteger.hashCode();
        }
        return this.fHashValue;
    }

    public boolean isLargerThan(BigInteger that) {
        return this.fInteger.compareTo(that) > 0;
    }

    @Override
    public boolean isNegative() {
        return this.fInteger.compareTo(BigInteger.ZERO) < 0;
    }

    @Override
    public boolean isNumEqualInteger(IInteger ii) throws ArithmeticException {
        return this.equals(ii);
    }

    @Override
    public boolean isNumIntValue() {
        return true;
    }

    @Override
    public boolean isPositive() {
        return this.fInteger.compareTo(BigInteger.ZERO) > 0;
    }

    @Override
    public boolean isZero() {
        return this.fInteger.equals(BigInteger.ZERO);
    }

    @Override
    public boolean isOne() {
        return this.fInteger.equals(BigInteger.ONE);
    }

    @Override
    public boolean isMinusOne() {
        return this.fInteger.equals(BI_MINUS_ONE);
    }

    @Override
    public int intValue() {
        return this.fInteger.intValue();
    }

    @Override
    public long longValue() {
        return this.fInteger.longValue();
    }

    public IntegerSym mod(IntegerSym that) {
        return IntegerSym.newInstance(this.fInteger.mod(that.fInteger));
    }

    @Override
    public IntegerSym multiply(IntegerSym that) {
        return IntegerSym.newInstance(this.fInteger.multiply(that.fInteger));
    }

    @Override
    public BigInteger multiply(long val) {
        return this.fInteger.multiply(BigInteger.valueOf(val));
    }

    @Override
    public ISignedNumber negate() {
        return IntegerSym.newInstance(this.fInteger.negate());
    }

    @Override
    public ISignedNumber opposite() {
        return IntegerSym.newInstance(this.fInteger.negate());
    }

    @Override
    public IExpr plus(IExpr that) {
        if (that instanceof IntegerSym) {
            return this.add((IntegerSym)that);
        }
        if (this.isZero()) {
            return that;
        }
        if (that instanceof FractionSym) {
            return FractionSym.valueOf(this.fInteger).add((FractionSym)that);
        }
        if (that instanceof ComplexSym) {
            return ((ComplexSym)that).add(ComplexSym.valueOf(this));
        }
        return super.plus(that);
    }

    @Override
    public ISignedNumber divideBy(ISignedNumber that) {
        if (that instanceof IntegerSym) {
            return FractionSym.valueOf(this.fInteger).divideBy(that);
        }
        if (that instanceof FractionSym) {
            return FractionSym.valueOf(this.fInteger).divideBy(that);
        }
        return Num.valueOf(this.fInteger.doubleValue() / that.doubleValue());
    }

    @Override
    public ISignedNumber subtractFrom(ISignedNumber that) {
        if (that instanceof IntegerSym) {
            return this.add((IntegerSym)that.negate());
        }
        if (this.isZero()) {
            return that.negate();
        }
        if (that instanceof FractionSym) {
            return FractionSym.valueOf(this.fInteger).subtractFrom(that);
        }
        return Num.valueOf(this.fInteger.doubleValue() - that.doubleValue());
    }

    @Override
    public IntegerSym pow(int exp) {
        return IntegerSym.newInstance(this.fInteger.pow(exp));
    }

    @Override
    public ISignedNumber inverse() {
        if (NumberUtil.isNegative(this.fInteger)) {
            return FractionSym.valueOf(BigInteger.valueOf(-1L), this.fInteger.negate());
        }
        return FractionSym.valueOf(BigInteger.ONE, this.fInteger);
    }

    public BigInteger shiftLeft(int n) {
        return this.fInteger.shiftLeft(n);
    }

    public BigInteger shiftRight(int n) {
        return this.fInteger.shiftRight(n);
    }

    @Override
    public BigInteger subtract(BigInteger that) {
        return this.fInteger.subtract(that);
    }

    @Override
    public IInteger subtract(IInteger that) {
        return IntegerSym.newInstance(this.fInteger.subtract(that.getBigNumerator()));
    }

    @Override
    public IExpr times(IExpr that) {
        if (that instanceof IntegerSym) {
            return this.multiply((IntegerSym)that);
        }
        if (this.isZero()) {
            return F.C0;
        }
        if (that instanceof FractionSym) {
            return FractionSym.valueOf(this.fInteger).multiply((FractionSym)that);
        }
        if (that instanceof ComplexSym) {
            return ((ComplexSym)that).multiply(ComplexSym.valueOf(this));
        }
        return super.times(that);
    }

    public byte[] toByteArray() {
        return this.fInteger.toByteArray();
    }

    @Override
    public BigInteger getBigNumerator() {
        return this.fInteger;
    }

    @Override
    public IInteger getNumerator() {
        return this;
    }

    @Override
    public IInteger getDenominator() {
        return F.C1;
    }

    @Override
    public BigFraction getFraction() {
        return new BigFraction(this.fInteger);
    }

    public IAST factorize(IAST result) {
        IntegerSym b = this;
        if (this.sign() < 0) {
            b = b.multiply(IntegerSym.valueOf(-1L));
            result.add(IntegerSym.valueOf(-1L));
        } else {
            if (b.fInteger.equals(BigInteger.ZERO)) {
                result.add(IntegerSym.valueOf(0L));
                return result;
            }
            if (b.fInteger.equals(BigInteger.ONE)) {
                result.add(IntegerSym.valueOf(1L));
                return result;
            }
        }
        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        BigInteger rest = Primality.countPrimes32749(b.fInteger, map);
        for (Map.Entry entry : map.entrySet()) {
            int key = (Integer)entry.getKey();
            IntegerSym is = IntegerSym.valueOf(key);
            for (int i = 0; i < (Integer)entry.getValue(); ++i) {
                result.add(is);
            }
        }
        if (rest.equals(BigInteger.ONE)) {
            return result;
        }
        b = IntegerSym.valueOf(rest);
        TreeMap<BigInteger, Integer> bigMap = new TreeMap<BigInteger, Integer>();
        Primality.pollardRhoFactors(b.getBigNumerator(), bigMap);
        for (Map.Entry entry : bigMap.entrySet()) {
            BigInteger key = (BigInteger)entry.getKey();
            IntegerSym is = IntegerSym.valueOf(key);
            for (int i = 0; i < (Integer)entry.getValue(); ++i) {
                result.add(is);
            }
        }
        return result;
    }

    public IAST factorInteger() {
        IInteger last = IntegerSym.valueOf(-2L);
        int count = 0;
        IAST iFactors = this.factorize(F.List());
        IAST list = F.List();
        List subList = null;
        for (int i = 1; i < iFactors.size(); ++i) {
            IInteger factor = (IInteger)iFactors.get(i);
            if (!((Object)last).equals(factor)) {
                if (subList != null) {
                    subList.add(IntegerSym.valueOf(count));
                    list.add(subList);
                }
                count = 0;
                subList = F.List((IExpr)factor);
            }
            ++count;
            last = factor;
        }
        if (subList != null) {
            subList.add(IntegerSym.valueOf(count));
            list.add(subList);
        }
        return list;
    }

    public IAST divisors() {
        TreeSet<IntegerSym> set = new TreeSet<IntegerSym>();
        IAST primeFactorsList = this.factorize(F.List());
        int len = primeFactorsList.size() - 1;
        for (int k = 1; k < len; ++k) {
            KSubsetsList iter = KSubsetsList.createKSubsets(primeFactorsList, k, F.List(), 1);
            for (IAST subset : iter) {
                if (subset == null) break;
                IInteger factor = F.C1;
                for (int j = 1; j < subset.size(); ++j) {
                    factor = factor.multiply((IInteger)subset.get(j));
                }
                set.add((IntegerSym)factor);
            }
        }
        IAST resultList = F.List((IExpr)F.C1);
        for (IInteger iInteger : set) {
            resultList.add(iInteger);
        }
        resultList.add(this);
        return resultList;
    }

    public IInteger eulerPhi() throws ArithmeticException {
        IAST ast = this.factorInteger();
        IInteger phi = IntegerSym.valueOf(1L);
        for (int i = 1; i < ast.size(); ++i) {
            IAST element = (IAST)ast.get(i);
            IntegerSym q = (IntegerSym)element.arg1();
            int c = ((IInteger)element.arg2()).toInt();
            phi = c == 1 ? phi.multiply(q.subtract(IntegerSym.valueOf(1L))) : phi.multiply(q.subtract(IntegerSym.valueOf(1L)).multiply(q.pow(c - 1)));
        }
        return phi;
    }

    public IntegerSym moebiusMu() {
        if (this.compareTo(IntegerSym.valueOf(1L)) == 0) {
            return IntegerSym.valueOf(1L);
        }
        IAST ast = this.factorInteger();
        IntegerSym max = IntegerSym.valueOf(1L);
        for (int i = 1; i < ast.size(); ++i) {
            IAST element = (IAST)ast.get(i);
            IntegerSym c = (IntegerSym)element.get(2);
            if (c.compareTo(max) <= 0) continue;
            max = c;
        }
        if (max.compareTo(IntegerSym.valueOf(1L)) > 0) {
            return IntegerSym.valueOf(0L);
        }
        if ((ast.size() - 1 & 1) == 1) {
            return IntegerSym.valueOf(-1L);
        }
        return IntegerSym.valueOf(1L);
    }

    private IntegerSym jacobiSymbolF() {
        IntegerSym a = this.mod(F.C8);
        if (a.isOne()) {
            return F.C1;
        }
        if (a.equals(F.C7)) {
            return F.C1;
        }
        return F.CN1;
    }

    private IntegerSym jacobiSymbolG(IntegerSym b) {
        IntegerSym i1 = this.mod(F.C4);
        if (i1.isOne()) {
            return F.C1;
        }
        IntegerSym i2 = b.mod(F.C4);
        if (i2.isOne()) {
            return F.C1;
        }
        return F.CN1;
    }

    public IntegerSym jacobiSymbol(IntegerSym b) {
        if (this.isOne()) {
            return F.C1;
        }
        if (this.isZero()) {
            return F.C0;
        }
        if (this.equals(F.C2)) {
            return b.jacobiSymbolF();
        }
        if (!this.isOdd()) {
            IntegerSym aDIV2 = IntegerSym.valueOf(this.shiftRight(1));
            return aDIV2.jacobiSymbol(b).multiply(F.C2.jacobiSymbol(b));
        }
        return b.mod(this).jacobiSymbol(this).multiply(this.jacobiSymbolG(b));
    }

    public IInteger[] primitiveRoots() throws ArithmeticException {
        IntegerSym phi = (IntegerSym)this.eulerPhi();
        int size = phi.eulerPhi().toInt();
        if (size <= 0) {
            return null;
        }
        IAST ast = phi.factorInteger();
        IntegerSym[] d = new IntegerSym[ast.size() - 1];
        for (int i = 1; i < ast.size(); ++i) {
            IAST element = (IAST)ast.get(i);
            IntegerSym q = (IntegerSym)element.arg1();
            d[i - 1] = phi.quotient(q);
        }
        int k = 0;
        IntegerSym n = this;
        IntegerSym m = IntegerSym.valueOf(1L);
        IInteger[] resultArray = new IntegerSym[size];
        while (m.compareTo(n) < 0) {
            boolean b = m.gcd(n).compareTo(IntegerSym.valueOf(1L)) == 0;
            for (int i = 0; i < d.length; ++i) {
                b = b && m.modPow(d[i], n).compareTo(IntegerSym.valueOf(1L)) > 0;
            }
            if (b) {
                resultArray[k++] = m;
            }
            m = m.add(IntegerSym.valueOf(1L));
        }
        if (resultArray[0] == null) {
            return new IntegerSym[0];
        }
        return resultArray;
    }

    @Override
    public int compareTo(IntegerSym that) {
        return this.fInteger.compareTo(that.fInteger);
    }

    public IntegerSym[] divideAndRemainder(IntegerSym that) {
        IntegerSym[] res = new IntegerSym[2];
        BigInteger[] largeRes = this.fInteger.divideAndRemainder(that.fInteger);
        res[0] = IntegerSym.newInstance(largeRes[0]);
        res[1] = IntegerSym.newInstance(largeRes[1]);
        return res;
    }

    @Override
    public IntegerSym remainder(IntegerSym that) {
        return IntegerSym.newInstance(this.fInteger.remainder(that.fInteger));
    }

    @Override
    public IExpr remainder(IExpr that) {
        if (that instanceof IntegerSym) {
            return IntegerSym.newInstance(this.fInteger.remainder(((IntegerSym)that).fInteger));
        }
        return this;
    }

    @Override
    public boolean isEven() {
        return NumberUtil.isEven(this.fInteger);
    }

    @Override
    public boolean isOdd() {
        return NumberUtil.isOdd(this.fInteger);
    }

    public IntegerSym modInverse(IntegerSym m) {
        return IntegerSym.newInstance(this.fInteger.modInverse(m.fInteger));
    }

    public IntegerSym modPow(IntegerSym exp, IntegerSym m) {
        return IntegerSym.newInstance(this.fInteger.modPow(exp.fInteger, m.fInteger));
    }

    @Override
    public int toInt() throws ArithmeticException {
        return NumberUtil.toInt(this.fInteger);
    }

    @Override
    public long toLong() throws ArithmeticException {
        return NumberUtil.toLong(this.fInteger);
    }

    @Override
    public int sign() {
        return this.fInteger.signum();
    }

    public IInteger sqrt() throws ArithmeticException {
        return IntegerSym.valueOf(BigIntegerMath.sqrt(this.fInteger, RoundingMode.UNNECESSARY));
    }

    @Override
    public IInteger nthRoot(int n) throws ArithmeticException {
        IntegerSym result;
        if (n < 0) {
            throw new IllegalArgumentException("nthRoot(" + n + ") n must be >= 0");
        }
        if (n == 2) {
            return this.sqrt();
        }
        if (this.sign() == 0) {
            return IntegerSym.valueOf(0L);
        }
        if (this.sign() < 0) {
            if (n % 2 == 0) {
                throw new ArithmeticException();
            }
            return (IntegerSym)((IntegerSym)this.negate()).nthRoot(n).negate();
        }
        IntegerSym temp = this;
        do {
            result = temp;
        } while ((temp = this.divideAndRemainder(temp.pow(n - 1))[0].add(temp.multiply(IntegerSym.valueOf(n - 1))).divideAndRemainder(IntegerSym.valueOf(n))[0]).compareTo(result) < 0);
        return result;
    }

    @Override
    public IInteger[] nthRootSplit(int n) throws ArithmeticException {
        IInteger[] result = new IInteger[2];
        if (this.sign() == 0) {
            result[0] = IntegerSym.valueOf(0L);
            result[1] = IntegerSym.valueOf(1L);
            return result;
        }
        if (this.sign() < 0) {
            if (n % 2 == 0) {
                throw new ArithmeticException();
            }
            result = ((IntegerSym)this.negate()).nthRootSplit(n);
            result[1] = (IInteger)result[1].negate();
            return result;
        }
        IntegerSym b = this;
        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        BigInteger rest = Primality.countPrimes1021(b.fInteger, map);
        IntegerSym nthRoot = IntegerSym.valueOf(1L);
        IntegerSym restFactors = IntegerSym.valueOf(rest);
        for (Map.Entry entry : map.entrySet()) {
            int mod;
            IntegerSym primeLE1021 = IntegerSym.valueOf(((Integer)entry.getKey()).intValue());
            int primeCounter = (Integer)entry.getValue();
            int div = primeCounter / n;
            if (div > 0) {
                nthRoot = nthRoot.multiply(primeLE1021.pow(div));
            }
            if ((mod = primeCounter % n) <= 0) continue;
            restFactors = restFactors.multiply(primeLE1021.pow(mod));
        }
        result[0] = nthRoot;
        result[1] = restFactors;
        return result;
    }

    @Override
    public int complexSign() {
        return this.sign();
    }

    @Override
    public IInteger ceil() {
        return this;
    }

    @Override
    public IInteger floor() {
        return this;
    }

    @Override
    public IInteger round() {
        return this;
    }

    @Override
    public int compareTo(IExpr expr) {
        if (expr instanceof IntegerSym) {
            return this.fInteger.compareTo(((IntegerSym)expr).fInteger);
        }
        if (expr instanceof FractionSym) {
            return -((FractionSym)expr).fRational.compareTo(new BigFraction(this.fInteger, BigInteger.ONE));
        }
        if (expr instanceof Num) {
            double d = this.fInteger.doubleValue() - ((Num)expr).getRealPart();
            if (d < 0.0) {
                return -1;
            }
            if (d > 0.0) {
                return 1;
            }
        }
        return super.compareTo(expr);
    }

    @Override
    public boolean isLessThan(ISignedNumber obj) {
        if (obj instanceof IntegerSym) {
            return this.fInteger.compareTo(((IntegerSym)obj).fInteger) < 0;
        }
        if (obj instanceof FractionSym) {
            return -((FractionSym)obj).fRational.compareTo(new BigFraction(this.fInteger, BigInteger.ONE)) < 0;
        }
        return this.fInteger.doubleValue() < obj.doubleValue();
    }

    @Override
    public boolean isGreaterThan(ISignedNumber obj) {
        if (obj instanceof IntegerSym) {
            return this.fInteger.compareTo(((IntegerSym)obj).fInteger) > 0;
        }
        if (obj instanceof FractionSym) {
            return -((FractionSym)obj).fRational.compareTo(new BigFraction(this.fInteger, BigInteger.ONE)) > 0;
        }
        return this.fInteger.doubleValue() < obj.doubleValue();
    }

    @Override
    public ISymbol head() {
        return F.IntegerHead;
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            OutputFormFactory.get().convertInteger(sb, this, Integer.MIN_VALUE);
            return sb.toString();
        }
        catch (Exception exception) {
            return this.fInteger.toString();
        }
    }

    @Override
    public String internalFormString(boolean symbolsAsFactoryMethod, int depth) {
        int value = NumberUtil.toInt(this.fInteger);
        switch (value) {
            case -1: {
                return "CN1";
            }
            case -2: {
                return "CN2";
            }
            case -3: {
                return "CN3";
            }
            case -4: {
                return "CN4";
            }
            case -5: {
                return "CN5";
            }
            case -6: {
                return "CN6";
            }
            case -7: {
                return "CN7";
            }
            case -8: {
                return "CN8";
            }
            case -9: {
                return "CN9";
            }
            case -10: {
                return "CN10";
            }
            case 0: {
                return "C0";
            }
            case 1: {
                return "C1";
            }
            case 2: {
                return "C2";
            }
            case 3: {
                return "C3";
            }
            case 4: {
                return "C4";
            }
            case 5: {
                return "C5";
            }
            case 6: {
                return "C6";
            }
            case 7: {
                return "C7";
            }
            case 8: {
                return "C8";
            }
            case 9: {
                return "C9";
            }
            case 10: {
                return "C10";
            }
        }
        return "ZZ(" + value + "L)";
    }

    @Override
    public IRational abs() {
        return this.eabs();
    }

    @Override
    public <T> T accept(IVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }

    @Override
    public long accept(IVisitorLong visitor) {
        return visitor.visit(this);
    }

    @Override
    public ISignedNumber getIm() {
        return F.C0;
    }

    @Override
    public ISignedNumber getRe() {
        return this;
    }

    @Override
    public ApfloatNum apfloatNumValue(long precision) {
        return ApfloatNum.valueOf(this.fInteger, precision);
    }

    @Override
    public Num numValue() {
        return Num.valueOf(this.doubleValue());
    }

    public Apcomplex apcomplexValue(long precision) {
        return new Apcomplex(new Apfloat(this.fInteger, precision));
    }

    @Override
    public ApcomplexNum apcomplexNumValue(long precision) {
        return ApcomplexNum.valueOf(this.apcomplexValue(precision));
    }

    @Override
    public ComplexNum complexNumValue() {
        return ComplexNum.valueOf(this.doubleValue());
    }
}

