/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import org.matheclipse.core.expression.AST;

public class HMArrayList<E>
extends AbstractList<E>
implements List<E>,
Cloneable,
Serializable,
RandomAccess {
    private static final long serialVersionUID = 8683452581122892189L;
    private transient int firstIndex;
    protected transient int lastIndex;
    private transient int hashValue;
    private transient E[] array;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("size", Integer.TYPE)};

    protected HMArrayList(E[] array) {
        this.array = array;
        this.hashValue = 0;
        this.firstIndex = 0;
        this.lastIndex = this.modCount = array.length;
    }

    public HMArrayList() {
        this(10);
    }

    public HMArrayList(E ex, E ... es) {
        int len = es.length + 1;
        this.hashValue = 0;
        this.firstIndex = 0;
        this.array = this.newElementArray(len);
        this.array[0] = ex;
        System.arraycopy(es, 0, this.array, 1, es.length);
        this.lastIndex = this.modCount = len;
    }

    public HMArrayList(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.hashValue = 0;
        this.lastIndex = 0;
        this.firstIndex = 0;
        this.array = this.newElementArray(capacity);
    }

    public HMArrayList(Collection<? extends E> collection) {
        this.hashValue = 0;
        this.firstIndex = 0;
        Object[] objects = collection.toArray();
        int size = objects.length;
        this.array = this.newElementArray(size + size / 10);
        System.arraycopy(objects, 0, this.array, 0, size);
        this.lastIndex = size;
        this.modCount = 1;
    }

    private E[] newElementArray(int size) {
        return new Object[size];
    }

    @Override
    public void add(int location, E object) {
        this.hashValue = 0;
        int size = this.lastIndex - this.firstIndex;
        if (0 < location && location < size) {
            if (this.firstIndex == 0 && this.lastIndex == this.array.length) {
                this.growForInsert(location, 1);
            } else if (location < size / 2 && this.firstIndex > 0 || this.lastIndex == this.array.length) {
                System.arraycopy(this.array, this.firstIndex, this.array, --this.firstIndex, location);
            } else {
                int index = location + this.firstIndex;
                System.arraycopy(this.array, index, this.array, index + 1, size - location);
                ++this.lastIndex;
            }
            this.array[location + this.firstIndex] = object;
        } else if (location == 0) {
            if (this.firstIndex == 0) {
                this.growAtFront(1);
            }
            this.array[--this.firstIndex] = object;
        } else if (location == size) {
            if (this.lastIndex == this.array.length) {
                this.growAtEnd(1);
            }
            this.array[this.lastIndex++] = object;
        } else {
            throw new IndexOutOfBoundsException("Index: " + Integer.valueOf(location) + ", Size: " + Integer.valueOf(this.lastIndex - this.firstIndex));
        }
        ++this.modCount;
    }

    @Override
    public boolean add(E object) {
        this.hashValue = 0;
        if (this.lastIndex == this.array.length) {
            this.growAtEnd(1);
        }
        this.array[this.lastIndex++] = object;
        ++this.modCount;
        return true;
    }

    @Override
    public boolean addAll(int location, Collection<? extends E> collection) {
        Object[] dumparray;
        int growSize;
        this.hashValue = 0;
        int size = this.lastIndex - this.firstIndex;
        if (location < 0 || location > size) {
            throw new IndexOutOfBoundsException("Index: " + Integer.valueOf(location) + ", Size: " + Integer.valueOf(this.lastIndex - this.firstIndex));
        }
        if (this == collection) {
            collection = (HMArrayList)this.clone();
        }
        if ((growSize = (dumparray = collection.toArray()).length) == 0) {
            return false;
        }
        if (0 < location && location < size) {
            if (this.array.length - size < growSize) {
                this.growForInsert(location, growSize);
            } else if (location < size / 2 && this.firstIndex > 0 || this.lastIndex > this.array.length - growSize) {
                int newFirst = this.firstIndex - growSize;
                if (newFirst < 0) {
                    int index = location + this.firstIndex;
                    System.arraycopy(this.array, index, this.array, index - newFirst, size - location);
                    this.lastIndex -= newFirst;
                    newFirst = 0;
                }
                System.arraycopy(this.array, this.firstIndex, this.array, newFirst, location);
                this.firstIndex = newFirst;
            } else {
                int index = location + this.firstIndex;
                System.arraycopy(this.array, index, this.array, index + growSize, size - location);
                this.lastIndex += growSize;
            }
        } else if (location == 0) {
            this.growAtFront(growSize);
            this.firstIndex -= growSize;
        } else if (location == size) {
            if (this.lastIndex > this.array.length - growSize) {
                this.growAtEnd(growSize);
            }
            this.lastIndex += growSize;
        }
        System.arraycopy(dumparray, 0, this.array, location + this.firstIndex, growSize);
        ++this.modCount;
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        this.hashValue = 0;
        Object[] dumpArray = collection.toArray();
        if (dumpArray.length == 0) {
            return false;
        }
        if (dumpArray.length > this.array.length - this.lastIndex) {
            this.growAtEnd(dumpArray.length);
        }
        System.arraycopy(dumpArray, 0, this.array, this.lastIndex, dumpArray.length);
        this.lastIndex += dumpArray.length;
        ++this.modCount;
        return true;
    }

    @Override
    public void clear() {
        if (this.firstIndex != this.lastIndex) {
            Arrays.fill(this.array, this.firstIndex, this.lastIndex, null);
            this.lastIndex = 0;
            this.firstIndex = 0;
            ++this.modCount;
        }
        this.hashValue = 0;
    }

    public Object clone() {
        try {
            HMArrayList newList = (HMArrayList)super.clone();
            newList.array = (Object[])this.array.clone();
            newList.hashValue = 0;
            return newList;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean contains(Object object) {
        if (object != null) {
            for (int i = this.firstIndex; i < this.lastIndex; ++i) {
                if (!object.equals(this.array[i])) continue;
                return true;
            }
        } else {
            for (int i = this.firstIndex; i < this.lastIndex; ++i) {
                if (this.array[i] != null) continue;
                return true;
            }
        }
        return false;
    }

    public void ensureCapacity(int minimumCapacity) {
        if (this.array.length < minimumCapacity) {
            if (this.firstIndex > 0) {
                this.growAtFront(minimumCapacity - this.array.length);
            } else {
                this.growAtEnd(minimumCapacity - this.array.length);
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof HMArrayList) {
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            if (this.size() != ((AST)obj).size()) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            HMArrayList list = (HMArrayList)obj;
            int j = list.firstIndex;
            for (int i = this.firstIndex; i < this.lastIndex; ++i) {
                if (this.array[i].equals(list.array[j++])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean isSameHead(E head) {
        return this.array[this.firstIndex] == head;
    }

    public final boolean isSameHead(E head, int length) {
        return this.array[this.firstIndex] == head && length == this.lastIndex - this.firstIndex;
    }

    public final boolean isSameHeadSizeGE(E head, int length) {
        return this.array[this.firstIndex] == head && length <= this.lastIndex - this.firstIndex;
    }

    @Override
    public E get(int location) {
        int index = this.firstIndex + location;
        if (index < this.lastIndex) {
            return this.array[index];
        }
        throw new IndexOutOfBoundsException("Index: " + Integer.valueOf(location) + ", Size: " + Integer.valueOf(this.lastIndex - this.firstIndex));
    }

    private void growAtEnd(int required) {
        int size = this.lastIndex - this.firstIndex;
        if (this.firstIndex >= required - (this.array.length - this.lastIndex)) {
            int newLast = this.lastIndex - this.firstIndex;
            if (size > 0) {
                System.arraycopy(this.array, this.firstIndex, this.array, 0, size);
                int start = newLast < this.firstIndex ? this.firstIndex : newLast;
                Arrays.fill(this.array, start, this.array.length, null);
            }
            this.firstIndex = 0;
            this.lastIndex = newLast;
        } else {
            int increment = size / 2;
            if (required > increment) {
                increment = required;
            }
            if (increment < 12) {
                increment = 12;
            }
            E[] newArray = this.newElementArray(size + increment);
            if (size > 0) {
                System.arraycopy(this.array, this.firstIndex, newArray, 0, size);
                this.firstIndex = 0;
                this.lastIndex = size;
            }
            this.array = newArray;
        }
    }

    private void growAtFront(int required) {
        int size = this.lastIndex - this.firstIndex;
        if (this.array.length - this.lastIndex + this.firstIndex >= required) {
            int newFirst = this.array.length - size;
            if (size > 0) {
                System.arraycopy(this.array, this.firstIndex, this.array, newFirst, size);
                int length = this.firstIndex + size > newFirst ? newFirst : this.firstIndex + size;
                Arrays.fill(this.array, this.firstIndex, length, null);
            }
            this.firstIndex = newFirst;
            this.lastIndex = this.array.length;
        } else {
            int increment = size / 2;
            if (required > increment) {
                increment = required;
            }
            if (increment < 12) {
                increment = 12;
            }
            E[] newArray = this.newElementArray(size + increment);
            if (size > 0) {
                System.arraycopy(this.array, this.firstIndex, newArray, newArray.length - size, size);
            }
            this.firstIndex = newArray.length - size;
            this.lastIndex = newArray.length;
            this.array = newArray;
        }
    }

    private void growForInsert(int location, int required) {
        int size = this.lastIndex - this.firstIndex;
        int increment = size / 2;
        if (required > increment) {
            increment = required;
        }
        if (increment < 12) {
            increment = 12;
        }
        E[] newArray = this.newElementArray(size + increment);
        int newFirst = increment - required;
        System.arraycopy(this.array, location + this.firstIndex, newArray, newFirst + location + required, size - location);
        System.arraycopy(this.array, this.firstIndex, newArray, newFirst, location);
        this.firstIndex = newFirst;
        this.lastIndex = size + increment;
        this.array = newArray;
    }

    @Override
    public int hashCode() {
        if (this.hashValue == 0) {
            this.hashValue = 17;
            for (int i = this.firstIndex; i < this.lastIndex; ++i) {
                this.hashValue = 23 * this.hashValue + this.array[i].hashCode();
            }
        }
        return this.hashValue;
    }

    @Override
    public int indexOf(Object object) {
        if (object != null) {
            for (int i = this.firstIndex; i < this.lastIndex; ++i) {
                if (!object.equals(this.array[i])) continue;
                return i - this.firstIndex;
            }
        } else {
            for (int i = this.firstIndex; i < this.lastIndex; ++i) {
                if (this.array[i] != null) continue;
                return i - this.firstIndex;
            }
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.lastIndex == this.firstIndex;
    }

    @Override
    public int lastIndexOf(Object object) {
        if (object != null) {
            for (int i = this.lastIndex - 1; i >= this.firstIndex; --i) {
                if (!object.equals(this.array[i])) continue;
                return i - this.firstIndex;
            }
        } else {
            for (int i = this.lastIndex - 1; i >= this.firstIndex; --i) {
                if (this.array[i] != null) continue;
                return i - this.firstIndex;
            }
        }
        return -1;
    }

    @Override
    public E remove(int location) {
        E result;
        this.hashValue = 0;
        int size = this.lastIndex - this.firstIndex;
        if (0 <= location && location < size) {
            if (location == size - 1) {
                result = this.array[--this.lastIndex];
                this.array[this.lastIndex] = null;
            } else if (location == 0) {
                result = this.array[this.firstIndex];
                this.array[this.firstIndex++] = null;
            } else {
                int elementIndex = this.firstIndex + location;
                result = this.array[elementIndex];
                if (location < size / 2) {
                    System.arraycopy(this.array, this.firstIndex, this.array, this.firstIndex + 1, location);
                    this.array[this.firstIndex++] = null;
                } else {
                    System.arraycopy(this.array, elementIndex + 1, this.array, elementIndex, size - location - 1);
                    this.array[--this.lastIndex] = null;
                }
            }
            if (this.firstIndex == this.lastIndex) {
                this.lastIndex = 0;
                this.firstIndex = 0;
            }
        } else {
            throw new IndexOutOfBoundsException("Index: " + Integer.valueOf(location) + ", Size: " + Integer.valueOf(this.lastIndex - this.firstIndex));
        }
        ++this.modCount;
        return result;
    }

    @Override
    public boolean remove(Object object) {
        this.hashValue = 0;
        int location = this.indexOf(object);
        if (location >= 0) {
            this.remove(location);
            return true;
        }
        return false;
    }

    @Override
    protected void removeRange(int start, int end) {
        this.hashValue = 0;
        if (start >= 0 && start <= end && end <= this.lastIndex - this.firstIndex) {
            if (start == end) {
                return;
            }
            int size = this.lastIndex - this.firstIndex;
            if (end == size) {
                Arrays.fill(this.array, this.firstIndex + start, this.lastIndex, null);
                this.lastIndex = this.firstIndex + start;
            } else if (start == 0) {
                Arrays.fill(this.array, this.firstIndex, this.firstIndex + end, null);
                this.firstIndex += end;
            } else {
                System.arraycopy(this.array, this.firstIndex + end, this.array, this.firstIndex + start, size - end);
                int newLast = this.lastIndex + start - end;
                Arrays.fill(this.array, newLast, this.lastIndex, null);
                this.lastIndex = newLast;
            }
            ++this.modCount;
        } else {
            throw new IndexOutOfBoundsException("Index: " + (this.lastIndex - this.firstIndex - end));
        }
    }

    @Override
    public E set(int location, E object) {
        this.hashValue = 0;
        if (0 <= location && location < this.lastIndex - this.firstIndex) {
            E result = this.array[this.firstIndex + location];
            this.array[this.firstIndex + location] = object;
            return result;
        }
        throw new IndexOutOfBoundsException("Index: " + Integer.valueOf(location) + ", Size: " + Integer.valueOf(this.lastIndex - this.firstIndex));
    }

    @Override
    public int size() {
        return this.lastIndex - this.firstIndex;
    }

    @Override
    public Object[] toArray() {
        int size = this.lastIndex - this.firstIndex;
        Object[] result = new Object[size];
        System.arraycopy(this.array, this.firstIndex, result, 0, size);
        return result;
    }

    @Override
    public <T> T[] toArray(T[] contents) {
        int size = this.lastIndex - this.firstIndex;
        if (size > contents.length) {
            Class<?> ct = contents.getClass().getComponentType();
            contents = (Object[])Array.newInstance(ct, size);
        }
        System.arraycopy(this.array, this.firstIndex, contents, 0, size);
        if (size < contents.length) {
            contents[size] = null;
        }
        return contents;
    }

    public void trimToSize() {
        int size = this.lastIndex - this.firstIndex;
        E[] newArray = this.newElementArray(size);
        System.arraycopy(this.array, this.firstIndex, newArray, 0, size);
        this.array = newArray;
        this.firstIndex = 0;
        this.lastIndex = this.array.length;
        this.modCount = 0;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        ObjectOutputStream.PutField fields = stream.putFields();
        fields.put("size", this.lastIndex - this.firstIndex);
        stream.writeFields();
        stream.writeInt(this.array.length);
        Iterator it = this.iterator();
        while (it.hasNext()) {
            stream.writeObject(it.next());
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        this.lastIndex = fields.get("size", 0);
        this.array = this.newElementArray(stream.readInt());
        for (int i = 0; i < this.lastIndex; ++i) {
            this.array[i] = stream.readObject();
        }
    }
}

