/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.math.BigInteger;
import org.apache.commons.math3.fraction.BigFraction;
import org.apache.commons.math3.fraction.FractionConversionException;
import org.apfloat.Apcomplex;
import org.apfloat.Apfloat;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.ApcomplexNum;
import org.matheclipse.core.expression.ApfloatNum;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.ComplexSym;
import org.matheclipse.core.expression.ExprImpl;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.IntegerSym;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.expression.NumberUtil;
import org.matheclipse.core.form.output.OutputFormFactory;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;
import org.matheclipse.core.visit.IVisitorLong;

public class FractionSym
extends ExprImpl
implements IFraction {
    private static final long serialVersionUID = 2396715994276842438L;
    BigFraction fRational = null;
    private transient int fHashValue = 0;

    protected static FractionSym newInstance(BigFraction rational) {
        FractionSym r = new FractionSym();
        r.fRational = rational;
        return r;
    }

    public static FractionSym valueOf(BigInteger numerator) {
        FractionSym r = new FractionSym();
        r.fRational = new BigFraction(numerator, BigInteger.ONE);
        return r;
    }

    public static FractionSym valueOf(BigFraction rat) {
        return FractionSym.newInstance(rat);
    }

    public static FractionSym valueOf(BigInteger numerator, BigInteger denominator) {
        FractionSym r = new FractionSym();
        r.fRational = new BigFraction(numerator, denominator);
        return r;
    }

    public static FractionSym valueOf(IInteger numerator, IInteger denominator) {
        FractionSym r = new FractionSym();
        r.fRational = new BigFraction(numerator.getBigNumerator(), denominator.getBigNumerator());
        return r;
    }

    public static FractionSym valueOf(long numerator, long denominator) {
        FractionSym r = new FractionSym();
        r.fRational = new BigFraction(numerator, denominator);
        return r;
    }

    public static FractionSym valueOf(double value) {
        FractionSym r = new FractionSym();
        try {
            r.fRational = new BigFraction(value, Config.DOUBLE_EPSILON, 200);
        }
        catch (FractionConversionException e) {
            r.fRational = new BigFraction(value);
        }
        return r;
    }

    private FractionSym() {
    }

    @Override
    public boolean isZero() {
        return this.fRational.getNumerator().equals(BigInteger.ZERO);
    }

    @Override
    public boolean equalsInt(int i) {
        return this.fRational.getNumerator().equals(BigInteger.valueOf(i)) && this.fRational.getDenominator().equals(BigInteger.ONE);
    }

    @Override
    public BigInteger getBigDenominator() {
        return this.fRational.getDenominator();
    }

    @Override
    public BigInteger getBigNumerator() {
        return this.fRational.getNumerator();
    }

    @Override
    public BigFraction getFraction() {
        return this.fRational;
    }

    @Override
    public IInteger getDenominator() {
        return IntegerSym.valueOf(this.fRational.getDenominator());
    }

    @Override
    public IInteger getNumerator() {
        return IntegerSym.valueOf(this.fRational.getNumerator());
    }

    @Override
    public int hierarchy() {
        return 16;
    }

    @Override
    public IFraction add(IFraction parm1) {
        return FractionSym.newInstance(this.fRational.add(((FractionSym)parm1).fRational));
    }

    @Override
    public IFraction multiply(IFraction parm1) {
        return FractionSym.newInstance(this.fRational.multiply(((FractionSym)parm1).fRational));
    }

    @Override
    public boolean isNegative() {
        return this.fRational.getNumerator().compareTo(BigInteger.ZERO) == -1;
    }

    @Override
    public boolean isPositive() {
        return this.fRational.getNumerator().compareTo(BigInteger.ZERO) == 1;
    }

    @Override
    public FractionSym eabs() {
        return FractionSym.newInstance(this.fRational.abs());
    }

    @Override
    public int compareAbsValueToOne() {
        BigFraction temp = this.fRational;
        if (this.fRational.compareTo(BigFraction.ZERO) < 0) {
            temp = temp.negate();
        }
        return temp.compareTo(BigFraction.ONE);
    }

    public BigFraction add(BigFraction that) {
        return this.fRational.add(that);
    }

    @Override
    public BigFraction divide(BigFraction that) {
        return this.fRational.divide(that);
    }

    @Override
    public BigInteger[] divideAndRemainder() {
        return this.fRational.getNumerator().divideAndRemainder(this.fRational.getDenominator());
    }

    @Override
    public double doubleValue() {
        return this.fRational.doubleValue();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof FractionSym) {
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            return this.fRational.equals(((FractionSym)obj).fRational);
        }
        return false;
    }

    @Override
    public IExpr evaluate(EvalEngine engine) {
        if (engine.isNumericMode()) {
            return this.numericNumber();
        }
        INumber cTemp = this.normalize();
        return cTemp == this ? null : cTemp;
    }

    @Override
    public final INumber numericNumber() {
        return F.num(this);
    }

    @Override
    public INumber normalize() {
        if (this.getBigDenominator().equals(BigInteger.ONE)) {
            return F.integer(this.getBigNumerator());
        }
        if (this.getBigNumerator().equals(BigInteger.ZERO)) {
            return F.C0;
        }
        return this;
    }

    public BigInteger getDividend() {
        return this.fRational.getNumerator();
    }

    public BigInteger getDivisor() {
        return this.fRational.getDenominator();
    }

    @Override
    public int hashCode() {
        if (this.fHashValue == 0) {
            this.fHashValue = this.fRational.hashCode();
        }
        return this.fHashValue;
    }

    public long longValue() {
        return this.fRational.longValue();
    }

    @Override
    public BigFraction multiply(BigFraction that) {
        return this.fRational.multiply(that);
    }

    @Override
    public ISignedNumber negate() {
        return FractionSym.newInstance(this.fRational.negate());
    }

    @Override
    public ISignedNumber opposite() {
        return FractionSym.newInstance(this.fRational.negate());
    }

    @Override
    public IExpr plus(IExpr that) {
        if (that instanceof FractionSym) {
            return this.add((FractionSym)that);
        }
        if (that instanceof IntegerSym) {
            return this.add(FractionSym.valueOf(((IntegerSym)that).fInteger));
        }
        if (that instanceof ComplexSym) {
            return ((ComplexSym)that).add(ComplexSym.valueOf(this));
        }
        return super.plus(that);
    }

    @Override
    public ISignedNumber divideBy(ISignedNumber that) {
        if (that instanceof FractionSym) {
            return FractionSym.newInstance(this.divide(((FractionSym)that).fRational));
        }
        if (that instanceof IntegerSym) {
            return this.divideBy(FractionSym.valueOf(((IntegerSym)that).fInteger));
        }
        return Num.valueOf(this.doubleValue() / that.doubleValue());
    }

    @Override
    public ISignedNumber subtractFrom(ISignedNumber that) {
        if (that instanceof FractionSym) {
            return this.add((FractionSym)that.negate());
        }
        if (this.isZero()) {
            return that.negate();
        }
        if (that instanceof IntegerSym) {
            return this.subtractFrom(FractionSym.valueOf(((IntegerSym)that).fInteger));
        }
        return Num.valueOf(this.doubleValue() - that.doubleValue());
    }

    @Override
    public IFraction pow(int exp) {
        if (exp <= 0) {
            throw new IllegalArgumentException("exp: " + exp + " should be a positive number");
        }
        IFraction powSqr = this;
        FractionSym result = null;
        while (exp >= 1) {
            if ((exp & 1) == 1) {
                result = result == null ? powSqr : result.multiply(powSqr);
            }
            powSqr = powSqr.multiply(powSqr);
            exp >>>= 1;
        }
        return result;
    }

    @Override
    public ISignedNumber inverse() {
        return FractionSym.newInstance(NumberUtil.inverse(this.fRational));
    }

    @Override
    public BigFraction subtract(BigFraction that) {
        return this.fRational.subtract(that);
    }

    @Override
    public IExpr times(IExpr that) {
        if (that instanceof FractionSym) {
            return this.multiply((FractionSym)that);
        }
        if (that instanceof IntegerSym) {
            return this.multiply(FractionSym.valueOf(((IntegerSym)that).fInteger));
        }
        if (that instanceof ComplexSym) {
            return ((ComplexSym)that).multiply(ComplexSym.valueOf(this));
        }
        return super.times(that);
    }

    @Override
    public String internalFormString(boolean symbolsAsFactoryMethod, int depth) {
        int numerator = this.fRational.getNumerator().intValue();
        int denominator = this.fRational.getDenominator().intValue();
        if (numerator == 1) {
            switch (denominator) {
                case 2: {
                    return "C1D2";
                }
                case 3: {
                    return "C1D3";
                }
                case 4: {
                    return "C1D4";
                }
            }
        }
        if (numerator == -1) {
            switch (denominator) {
                case 2: {
                    return "CN1D2";
                }
                case 3: {
                    return "CN1D3";
                }
                case 4: {
                    return "CN1D4";
                }
            }
        }
        return "QQ(" + numerator + "L," + denominator + "L)";
    }

    @Override
    public int toInt() throws ArithmeticException {
        if (this.fRational.getDenominator().equals(BigInteger.ONE)) {
            return NumberUtil.toInt(this.fRational.getNumerator());
        }
        if (this.fRational.getNumerator().equals(BigInteger.ZERO)) {
            return 0;
        }
        throw new ArithmeticException("toInt: denominator != 1");
    }

    @Override
    public long toLong() throws ArithmeticException {
        if (this.fRational.getDenominator().equals(BigInteger.ONE)) {
            return NumberUtil.toLong(this.fRational.getNumerator());
        }
        if (this.fRational.getNumerator().equals(BigInteger.ZERO)) {
            return 0L;
        }
        throw new ArithmeticException("toLong: denominator != 1");
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            OutputFormFactory.get().convertFraction(sb, this.fRational, Integer.MIN_VALUE);
            return sb.toString();
        }
        catch (Exception exception) {
            return this.fRational.getNumerator().toString() + "/" + this.fRational.getDenominator().toString();
        }
    }

    @Override
    public String fullFormString() {
        StringBuffer buf = new StringBuffer("Rational");
        if (Config.PARSER_USE_LOWERCASE_SYMBOLS) {
            buf.append('(');
        } else {
            buf.append('[');
        }
        buf.append(this.fRational.getNumerator().toString().toString());
        buf.append(',');
        buf.append(this.fRational.getDenominator().toString().toString());
        if (Config.PARSER_USE_LOWERCASE_SYMBOLS) {
            buf.append(')');
        } else {
            buf.append(']');
        }
        return buf.toString();
    }

    @Override
    public IExpr gcd(IExpr that) {
        if (that instanceof FractionSym) {
            BigFraction arg2 = ((FractionSym)that).getRational();
            return FractionSym.valueOf(this.fRational.getNumerator().gcd(arg2.getNumerator()), IntegerSym.lcm(this.fRational.getDenominator(), arg2.getDenominator()));
        }
        return super.gcd(that);
    }

    @Override
    public BigFraction getRational() {
        return this.fRational;
    }

    @Override
    public int sign() {
        return this.fRational.getNumerator().signum();
    }

    @Override
    public int complexSign() {
        return this.sign();
    }

    @Override
    public IInteger ceil() {
        return IntegerSym.valueOf(NumberUtil.ceiling(this.fRational));
    }

    @Override
    public IInteger floor() {
        return IntegerSym.valueOf(NumberUtil.floor(this.fRational));
    }

    @Override
    public IInteger round() {
        return IntegerSym.valueOf(NumberUtil.round(this.fRational, 6));
    }

    @Override
    public int compareTo(IExpr expr) {
        if (expr instanceof FractionSym) {
            return this.fRational.compareTo(((FractionSym)expr).fRational);
        }
        if (expr instanceof IntegerSym) {
            return this.fRational.compareTo(new BigFraction(((IntegerSym)expr).fInteger, BigInteger.ONE));
        }
        if (expr instanceof Num) {
            double d = this.fRational.doubleValue() - ((Num)expr).getRealPart();
            if (d < 0.0) {
                return -1;
            }
            if (d > 0.0) {
                return 1;
            }
        }
        return super.compareTo(expr);
    }

    @Override
    public boolean isLessThan(ISignedNumber obj) {
        if (obj instanceof FractionSym) {
            return this.fRational.compareTo(((FractionSym)obj).fRational) < 0;
        }
        if (obj instanceof IntegerSym) {
            return this.fRational.compareTo(new BigFraction(((IntegerSym)obj).fInteger, BigInteger.ONE)) < 0;
        }
        return this.fRational.doubleValue() < obj.doubleValue();
    }

    @Override
    public boolean isGreaterThan(ISignedNumber obj) {
        if (obj instanceof FractionSym) {
            return this.fRational.compareTo(((FractionSym)obj).fRational) > 0;
        }
        if (obj instanceof IntegerSym) {
            return this.fRational.compareTo(new BigFraction(((IntegerSym)obj).fInteger, BigInteger.ONE)) > 0;
        }
        return this.fRational.doubleValue() < obj.doubleValue();
    }

    @Override
    public ISymbol head() {
        return F.Rational;
    }

    @Override
    public IFraction abs() {
        return this.eabs();
    }

    @Override
    public <T> T accept(IVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }

    @Override
    public long accept(IVisitorLong visitor) {
        return visitor.visit(this);
    }

    @Override
    public ISignedNumber getIm() {
        return F.C0;
    }

    @Override
    public ISignedNumber getRe() {
        return this;
    }

    @Override
    public ApfloatNum apfloatNumValue(long precision) {
        return ApfloatNum.valueOf(this.fRational.getNumerator(), this.fRational.getDenominator(), precision);
    }

    @Override
    public Num numValue() {
        return Num.valueOf(this.fRational.doubleValue());
    }

    public Apcomplex apcomplexValue(long precision) {
        Apfloat real = new Apfloat(this.fRational.getNumerator(), precision).divide(new Apfloat(this.fRational.getDenominator(), precision));
        return new Apcomplex(real);
    }

    @Override
    public ApcomplexNum apcomplexNumValue(long precision) {
        return ApcomplexNum.valueOf(this.apcomplexValue(precision));
    }

    @Override
    public ComplexNum complexNumValue() {
        double nr = this.fRational.getNumerator().doubleValue();
        double dr = this.fRational.getDenominator().doubleValue();
        return ComplexNum.valueOf(nr / dr);
    }
}

