/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import edu.jas.structure.ElemFactory;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.IterationLimitExceeded;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.IntegerSym;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.IPatternMatcher;
import org.matheclipse.core.patternmatching.PatternMatcher;
import org.matheclipse.core.visit.VisitorReplaceAll;
import org.matheclipse.core.visit.VisitorReplacePart;
import org.matheclipse.core.visit.VisitorReplaceSlots;

public abstract class ExprImpl
implements IExpr {
    public static IExpr replaceRepeated(IExpr expr, VisitorReplaceAll visitor) {
        IExpr result = expr;
        IExpr temp = expr.accept(visitor);
        int iterationLimit = EvalEngine.get().getIterationLimit();
        int iterationCounter = 1;
        while (temp != null) {
            result = temp;
            temp = result.accept(visitor);
            if (iterationLimit < 0 || iterationLimit > ++iterationCounter) continue;
            IterationLimitExceeded.throwIt(iterationCounter, result);
        }
        return result;
    }

    @Override
    public IExpr abs() {
        if (this instanceof INumber) {
            return ((INumber)((Object)this)).eabs();
        }
        throw new UnsupportedOperationException(this.toString());
    }

    @Override
    public IExpr and(IExpr that) {
        return F.And(this, that);
    }

    @Override
    public IExpr apply(IExpr ... leaves) {
        IAST ast = F.ast(this.head());
        for (int i = 0; i < leaves.length; ++i) {
            ast.add(leaves[i]);
        }
        return ast;
    }

    @Override
    public IExpr apply(List<? extends IExpr> leaves) {
        IAST ast = F.ast(this.head());
        for (int i = 0; i < leaves.size(); ++i) {
            ast.add(leaves.get(i));
        }
        return ast;
    }

    @Override
    public Object asType(Class clazz) {
        if (clazz.equals(Boolean.class)) {
            if (this.equals(F.True)) {
                return Boolean.TRUE;
            }
            if (this.equals(F.False)) {
                return Boolean.FALSE;
            }
        } else if (clazz.equals(Integer.class)) {
            if (this.isSignedNumber()) {
                try {
                    return ((ISignedNumber)((Object)this)).toInt();
                }
                catch (ArithmeticException arithmeticException) {}
            }
        } else if (clazz.equals(BigInteger.class)) {
            if (this instanceof IntegerSym) {
                return new BigInteger(((IntegerSym)this).toByteArray());
            }
        } else if (clazz.equals(String.class)) {
            return this.toString();
        }
        throw new UnsupportedOperationException("ExprImpl.asType() - cast not supported.");
    }

    @Override
    public int compareTo(IExpr expr) {
        if (this.hierarchy() > expr.hierarchy()) {
            return 1;
        }
        if (this.hierarchy() < expr.hierarchy()) {
            return -1;
        }
        return 0;
    }

    @Override
    public IExpr copy() {
        try {
            return (IExpr)this.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public IExpr divide(IExpr that) {
        if (that.isNumber()) {
            return F.eval(F.Times((IExpr)this, that.inverse()));
        }
        return F.eval(F.Times((IExpr)this, (IExpr)F.Power(that, F.CN1)));
    }

    public IExpr[] egcd(IExpr b) {
        throw new UnsupportedOperationException(this.toString());
    }

    @Override
    public IExpr evaluate(EvalEngine engine) {
        return null;
    }

    @Override
    public ElemFactory<IExpr> factory() {
        throw new UnsupportedOperationException(this.toString());
    }

    @Override
    public String fullFormString() {
        return this.toString();
    }

    @Override
    public IExpr gcd(IExpr that) {
        throw new UnsupportedOperationException("gcd(" + this.toString() + ", " + that.toString() + ")");
    }

    @Override
    public IExpr getAt(int index) {
        return F.Part(this, F.integer(index));
    }

    @Override
    public abstract ISymbol head();

    @Override
    public String internalFormString(boolean symbolsAsFactoryMethod, int depth) {
        return this.toString();
    }

    @Override
    public IExpr inverse() {
        return this.power(F.CN1);
    }

    @Override
    public final boolean isAnd() {
        return false;
    }

    @Override
    public final boolean isArcCos() {
        return false;
    }

    @Override
    public final boolean isArcCosh() {
        return false;
    }

    @Override
    public final boolean isArcSin() {
        return false;
    }

    @Override
    public final boolean isArcSinh() {
        return false;
    }

    @Override
    public final boolean isArcTan() {
        return false;
    }

    @Override
    public final boolean isArcTanh() {
        return false;
    }

    @Override
    public final boolean isAST() {
        return false;
    }

    @Override
    public final boolean isAST(IExpr header) {
        return false;
    }

    @Override
    public final boolean isAST(IExpr header, int sz) {
        return false;
    }

    @Override
    public boolean isAST(IExpr header, int length, IExpr ... args) {
        return false;
    }

    @Override
    public final boolean isAST(String symbol) {
        return false;
    }

    @Override
    public final boolean isAST(String symbol, int length) {
        return false;
    }

    @Override
    public final boolean isASTSizeGE(IExpr header, int length) {
        return false;
    }

    @Override
    public boolean isAtom() {
        return true;
    }

    @Override
    public boolean isComplex() {
        return this instanceof IComplex;
    }

    @Override
    public boolean isComplexInfinity() {
        return false;
    }

    @Override
    public boolean isComplexNumeric() {
        return this instanceof IComplexNum;
    }

    @Override
    public boolean isCondition() {
        return false;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public final boolean isCos() {
        return false;
    }

    @Override
    public final boolean isCosh() {
        return false;
    }

    @Override
    public boolean isDirectedInfinity() {
        return false;
    }

    @Override
    public boolean isE() {
        return false;
    }

    @Override
    public boolean isFalse() {
        return false;
    }

    @Override
    public final boolean isFlatAST() {
        return false;
    }

    @Override
    public boolean isFraction() {
        return this instanceof IFraction;
    }

    @Override
    public boolean isFree(IExpr pattern) {
        return this.isFree(pattern, true);
    }

    @Override
    public boolean isFree(IExpr pattern, boolean heads) {
        PatternMatcher matcher = new PatternMatcher(pattern);
        return !((IPatternMatcher)matcher).apply(this);
    }

    @Override
    public boolean isFree(Predicate<IExpr> predicate, boolean heads) {
        return !predicate.apply(this);
    }

    @Override
    public boolean isFunction() {
        return false;
    }

    @Override
    public boolean isGEOrdered(IExpr obj) {
        return this.compareTo(obj) >= 0;
    }

    @Override
    public boolean isGTOrdered(IExpr obj) {
        return this.compareTo(obj) > 0;
    }

    @Override
    public boolean isIndeterminate() {
        return false;
    }

    @Override
    public boolean isInfinity() {
        return false;
    }

    @Override
    public boolean isInteger() {
        return this instanceof IInteger;
    }

    @Override
    public boolean isLEOrdered(IExpr obj) {
        return this.compareTo(obj) <= 0;
    }

    @Override
    public final boolean isList() {
        return false;
    }

    @Override
    public final boolean isListOfLists() {
        return false;
    }

    @Override
    public final boolean isLog() {
        return false;
    }

    @Override
    public boolean isLTOrdered(IExpr obj) {
        return this.compareTo(obj) < 0;
    }

    @Override
    public final int[] isMatrix() {
        return null;
    }

    @Override
    public boolean isMember(IExpr pattern, boolean heads) {
        PatternMatcher matcher = new PatternMatcher(pattern);
        return this.isMember(matcher, heads);
    }

    @Override
    public boolean isMember(Predicate<IExpr> predicate, boolean heads) {
        return predicate.apply(this);
    }

    @Override
    public boolean isMinusOne() {
        return false;
    }

    @Override
    public boolean isModule() {
        return false;
    }

    @Override
    public boolean isNegative() {
        return false;
    }

    @Override
    public boolean isNegativeInfinity() {
        return false;
    }

    @Override
    public boolean isNot() {
        return false;
    }

    @Override
    public boolean isNumber() {
        return this instanceof INumber;
    }

    @Override
    public boolean isNumEqualInteger(IInteger ii) throws ArithmeticException {
        return false;
    }

    @Override
    public boolean isNumeric() {
        return this instanceof INum || this instanceof IComplexNum;
    }

    @Override
    public boolean isNumericFunction() {
        return this.isNumber() || this.isConstant();
    }

    @Override
    public boolean isNumericMode() {
        return this.isNumeric();
    }

    @Override
    public boolean isNumIntValue() {
        return false;
    }

    @Override
    public boolean isOne() {
        return false;
    }

    @Override
    public boolean isONE() {
        return this.isOne();
    }

    @Override
    public boolean isOr() {
        return false;
    }

    @Override
    public final boolean isOrderlessAST() {
        return false;
    }

    @Override
    public boolean isPattern() {
        return false;
    }

    @Override
    public boolean isPatternDefault() {
        return false;
    }

    @Override
    public boolean isPatternExpr() {
        return false;
    }

    @Override
    public boolean isPatternSequence() {
        return false;
    }

    @Override
    public boolean isPi() {
        return false;
    }

    @Override
    public final boolean isPlus() {
        return false;
    }

    @Override
    public boolean isPolynomial(ISymbol variable) {
        return this.isNumber();
    }

    @Override
    public boolean isPolynomial(IAST variables) {
        return this.isNumber();
    }

    @Override
    public boolean isPolynomialOfMaxDegree(ISymbol variable, long maxDegree) {
        return this.isPolynomial(variable);
    }

    @Override
    public boolean isPositive() {
        return false;
    }

    @Override
    public final boolean isPower() {
        return false;
    }

    @Override
    public boolean isRational() {
        return this instanceof IRational;
    }

    @Override
    public boolean isRealFunction() {
        return this.isSignedNumber() || this.isConstant();
    }

    @Override
    public final boolean isRuleAST() {
        return false;
    }

    @Override
    public boolean isSame(IExpr expression) {
        return this.isSame(expression, Config.DOUBLE_EPSILON);
    }

    @Override
    public boolean isSame(IExpr expression, double epsilon) {
        return this.equals(expression);
    }

    @Override
    public final boolean isSequence() {
        return false;
    }

    @Override
    public boolean isSignedNumber() {
        return this instanceof ISignedNumber;
    }

    @Override
    public final boolean isSin() {
        return false;
    }

    @Override
    public final boolean isSinh() {
        return false;
    }

    @Override
    public boolean isSlot() {
        return false;
    }

    @Override
    public boolean isSlotSequence() {
        return false;
    }

    @Override
    public boolean isSymbol() {
        return this instanceof ISymbol;
    }

    @Override
    public final boolean isTan() {
        return false;
    }

    @Override
    public final boolean isTanh() {
        return false;
    }

    @Override
    public final boolean isTimes() {
        return false;
    }

    @Override
    public boolean isTrue() {
        return false;
    }

    @Override
    public boolean isUnit() {
        return true;
    }

    @Override
    public boolean isValue() {
        return false;
    }

    @Override
    public final int isVector() {
        return -1;
    }

    @Override
    public boolean isZero() {
        return false;
    }

    @Override
    public boolean isZERO() {
        return this.isZero();
    }

    @Override
    public long leafCount() {
        return this.isAtom() ? 1L : 0L;
    }

    @Override
    public List<IExpr> leaves() {
        return null;
    }

    @Override
    public IExpr minus(IExpr that) {
        if (this.isNumber() && that.isNumber()) {
            return F.eval(F.Plus((IExpr)this, (IExpr)((INumber)that).opposite()));
        }
        if (that.isNumber()) {
            return F.eval(F.Plus((IExpr)this, (IExpr)((INumber)that).opposite()));
        }
        return F.eval(F.Plus((IExpr)this, (IExpr)F.Times((IExpr)F.CN1, that)));
    }

    @Override
    public IExpr mod(IExpr that) {
        return F.Mod(this, that);
    }

    @Override
    public final IExpr multiply(IExpr that) {
        return this.times(that);
    }

    @Override
    public IExpr negate() {
        return this.opposite();
    }

    @Override
    public final IExpr negative() {
        return this.opposite();
    }

    @Override
    public IExpr opposite() {
        return this.times(F.CN1);
    }

    @Override
    public IExpr or(IExpr that) {
        return F.Or(this, that);
    }

    @Override
    public IExpr plus(IExpr that) {
        return F.eval(F.Plus((IExpr)this, that));
    }

    @Override
    public final IExpr power(IExpr that) {
        if (this.isNumber() && that.isNumber()) {
            return F.eval(F.Power((IExpr)this, that));
        }
        return F.Power((IExpr)this, that);
    }

    @Override
    public final IExpr power(int n) {
        if (this.isNumber()) {
            return F.eval(F.Power((IExpr)this, F.integer(n)));
        }
        return F.Power((IExpr)this, F.integer(n));
    }

    @Override
    public IExpr remainder(IExpr that) {
        throw new UnsupportedOperationException(this.toString());
    }

    @Override
    public IExpr replaceAll(Function<IExpr, IExpr> function) {
        return this.accept(new VisitorReplaceAll(function));
    }

    @Override
    public IExpr replaceAll(IAST astRules) {
        return this.accept(new VisitorReplaceAll(astRules));
    }

    @Override
    public IExpr replacePart(IAST astRules) {
        return this.accept(new VisitorReplacePart(astRules));
    }

    @Override
    public IExpr replaceRepeated(Function<IExpr, IExpr> function) {
        return ExprImpl.replaceRepeated(this, new VisitorReplaceAll(function));
    }

    @Override
    public IExpr replaceRepeated(IAST astRules) {
        return ExprImpl.replaceRepeated(this, new VisitorReplaceAll(astRules));
    }

    @Override
    public IExpr replaceSlots(IAST astSlots) {
        return this.accept(new VisitorReplaceSlots(astSlots));
    }

    @Override
    @Deprecated
    public int signum() {
        if (this.isZERO()) {
            return 0;
        }
        if (this.isSignedNumber()) {
            return ((ISignedNumber)((Object)this)).sign();
        }
        return 1;
    }

    @Override
    public IExpr subtract(IExpr that) {
        return this.plus((IExpr)that.negate());
    }

    @Override
    public IExpr sum(IExpr that) {
        return this.plus(that);
    }

    @Override
    public IExpr times(IExpr that) {
        return F.eval(F.Times((IExpr)this, that));
    }

    @Override
    public ISymbol topHead() {
        return this.head();
    }

    @Override
    public String toScript() {
        return this.toString();
    }

    @Override
    public String toScriptFactory() {
        throw new UnsupportedOperationException(this.toString());
    }

    @Override
    public IExpr variables2Slots(Map<IExpr, IExpr> map, List<IExpr> variableList) {
        return this;
    }
}

