/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.matheclipse.core.expression.ExprField;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IBigNumber;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.INumber;

public class ExprFieldElement
implements FieldElement<ExprFieldElement>,
Comparable<ExprFieldElement> {
    private final IExpr val;

    public ExprFieldElement(IExpr v) {
        if (v.isFraction()) {
            this.val = ((IFraction)v).normalize();
            return;
        }
        if (v.isComplex()) {
            this.val = ((IComplex)v).normalize();
            return;
        }
        this.val = v;
    }

    @Override
    public ExprFieldElement add(ExprFieldElement a) {
        if (this.val.isAtom() && a.val.isAtom()) {
            return new ExprFieldElement(this.val.plus(a.val));
        }
        return new ExprFieldElement(F.evalExpandAll(F.Plus(this.val, a.val)));
    }

    @Override
    public int compareTo(ExprFieldElement o) {
        return this.val.compareTo(o.val);
    }

    @Override
    public ExprFieldElement divide(ExprFieldElement a) throws ArithmeticException {
        if (this.val.isAtom() && a.val.isAtom()) {
            return new ExprFieldElement(this.val.divide(a.val));
        }
        return new ExprFieldElement(F.evalExpandAll(F.Divide(this.val, a.val)));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ExprFieldElement) {
            IExpr arg2 = ((ExprFieldElement)obj).val;
            if (this.val.isNumeric()) {
                if (arg2 instanceof IBigNumber) {
                    return this.val.isSame(((IBigNumber)arg2).numericNumber());
                }
                if (arg2.isNumeric()) {
                    return this.val.isSame(arg2);
                }
                return false;
            }
            if (arg2.isNumeric()) {
                if (this.val instanceof IBigNumber) {
                    return arg2.isSame(((IBigNumber)this.val).numericNumber());
                }
                return false;
            }
            return this.val.equals(((ExprFieldElement)obj).val);
        }
        return false;
    }

    public final IExpr getExpr() {
        return this.val;
    }

    @Override
    public Field<ExprFieldElement> getField() {
        return ExprField.CONST;
    }

    public int hashCode() {
        return this.val.hashCode();
    }

    @Override
    public ExprFieldElement multiply(ExprFieldElement a) {
        if (this.val.isAtom() && a.val.isAtom()) {
            return new ExprFieldElement(this.val.times(a.val));
        }
        return new ExprFieldElement(F.evalExpandAll(F.Times(this.val, a.val)));
    }

    @Override
    public ExprFieldElement multiply(int a) {
        if (this.val.isAtom()) {
            return new ExprFieldElement(this.val.times(F.integer(a)));
        }
        return new ExprFieldElement(F.evalExpandAll(F.Times(this.val, (IExpr)F.integer(a))));
    }

    @Override
    public ExprFieldElement negate() {
        if (this.val.isNumber()) {
            return new ExprFieldElement(((INumber)this.val).opposite());
        }
        return new ExprFieldElement(F.evalExpandAll(F.Times(this.val, (IExpr)F.CN1)));
    }

    @Override
    public ExprFieldElement reciprocal() {
        if (this.val.isNumber()) {
            return new ExprFieldElement(((INumber)this.val).inverse());
        }
        return new ExprFieldElement(F.evalExpandAll(this.val.power(-1)));
    }

    @Override
    public ExprFieldElement subtract(ExprFieldElement a) {
        if (this.val.isAtom() && a.val.isAtom()) {
            return new ExprFieldElement(this.val.minus(a.val));
        }
        return new ExprFieldElement(F.evalExpandAll(F.Subtract(this.val, a.val)));
    }

    public String toString() {
        return this.val.toString();
    }
}

