/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.math.BigInteger;
import org.apache.commons.math3.fraction.BigFraction;
import org.apfloat.Apcomplex;
import org.apfloat.Apfloat;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.ApcomplexNum;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.ExprImpl;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.FractionSym;
import org.matheclipse.core.expression.IntegerSym;
import org.matheclipse.core.expression.NumberUtil;
import org.matheclipse.core.form.output.OutputFormFactory;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;
import org.matheclipse.core.visit.IVisitorLong;

public class ComplexSym
extends ExprImpl
implements IComplex {
    private static final long serialVersionUID = 1489050560741527824L;
    private BigFraction _real;
    private BigFraction _imaginary;
    private transient int fHashValue;
    public static final ComplexSym ZERO = ComplexSym.valueOf(BigFraction.ZERO);

    private ComplexSym() {
    }

    public static ComplexSym valueOf(BigInteger real, BigInteger imaginary) {
        ComplexSym c = new ComplexSym();
        c._real = new BigFraction(real, BigInteger.ONE);
        c._imaginary = new BigFraction(imaginary, BigInteger.ONE);
        return c;
    }

    public static ComplexSym valueOf(BigInteger real) {
        ComplexSym c = new ComplexSym();
        c._real = new BigFraction(real, BigInteger.ONE);
        c._imaginary = BigFraction.ZERO;
        return c;
    }

    public static ComplexSym valueOf(IInteger real, IInteger imaginary) {
        ComplexSym c = new ComplexSym();
        c._real = new BigFraction(real.getBigNumerator(), BigInteger.ONE);
        c._imaginary = new BigFraction(imaginary.getBigNumerator(), BigInteger.ONE);
        return c;
    }

    public static ComplexSym valueOf(IInteger real) {
        ComplexSym c = new ComplexSym();
        c._real = new BigFraction(real.getBigNumerator(), BigInteger.ONE);
        c._imaginary = BigFraction.ZERO;
        return c;
    }

    public static ComplexSym valueOf(BigFraction real) {
        ComplexSym c = new ComplexSym();
        c._real = real;
        c._imaginary = BigFraction.ZERO;
        return c;
    }

    public static ComplexSym valueOf(BigFraction real, BigFraction imaginary) {
        ComplexSym c = new ComplexSym();
        c._real = real;
        c._imaginary = imaginary;
        return c;
    }

    public static ComplexSym valueOf(long real_numerator, long real_denominator, long imag_numerator, long imag_denominator) {
        ComplexSym c = new ComplexSym();
        c._real = new BigFraction(real_numerator, real_denominator);
        c._imaginary = new BigFraction(imag_numerator, imag_denominator);
        return c;
    }

    public static ComplexSym valueOf(IFraction real) {
        ComplexSym c = new ComplexSym();
        c._real = real.getRational();
        c._imaginary = BigFraction.ZERO;
        return c;
    }

    public static ComplexSym valueOf(IFraction real, IFraction imaginary) {
        ComplexSym c = new ComplexSym();
        c._real = real.getRational();
        c._imaginary = imaginary.getRational();
        return c;
    }

    @Override
    public IComplex conjugate() {
        return ComplexSym.valueOf(this._real, this._imaginary.negate());
    }

    @Override
    public IExpr eabs() {
        return F.Sqrt(F.QQ(this._real.multiply(this._real).add(this._imaginary.multiply(this._imaginary))));
    }

    @Override
    public int compareAbsValueToOne() {
        BigFraction temp = this._real.multiply(this._real).add(this._imaginary.multiply(this._imaginary));
        return temp.compareTo(BigFraction.ONE);
    }

    public ComplexSym add(ComplexSym parm1) throws ArithmeticException {
        return ComplexSym.valueOf(this._real.add(parm1._real), this._imaginary.add(parm1._imaginary));
    }

    @Override
    public IComplex add(IComplex parm1) {
        return ComplexSym.valueOf(this._real.add(parm1.getRealPart()), this._imaginary.add(parm1.getImaginaryPart()));
    }

    public Apcomplex apcomplexValue(long precision) {
        Apfloat real = new Apfloat(this._real.getNumerator(), precision).divide(new Apfloat(this._real.getDenominator(), precision));
        Apfloat imag = new Apfloat(this._imaginary.getNumerator(), precision).divide(new Apfloat(this._imaginary.getDenominator(), precision));
        return new Apcomplex(real, imag);
    }

    @Override
    public ApcomplexNum apcomplexNumValue(long precision) {
        return ApcomplexNum.valueOf(this.apcomplexValue(precision));
    }

    @Override
    public ComplexNum complexNumValue() {
        double nr = this._real.getNumerator().doubleValue();
        double dr = this._real.getDenominator().doubleValue();
        double ni = this._imaginary.getNumerator().doubleValue();
        double di = this._imaginary.getDenominator().doubleValue();
        return ComplexNum.valueOf(nr / dr, ni / di);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ComplexSym) {
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            return this._real.equals(((ComplexSym)obj)._real) && this._imaginary.equals(((ComplexSym)obj)._imaginary);
        }
        return false;
    }

    @Override
    public IExpr evaluate(EvalEngine engine) {
        if (engine.isNumericMode()) {
            return this.numericNumber();
        }
        INumber cTemp = this.normalize();
        return cTemp == this ? null : cTemp;
    }

    @Override
    public final INumber numericNumber() {
        return F.complexNum(this);
    }

    @Override
    public BigFraction getImaginaryPart() {
        return this._imaginary;
    }

    @Override
    public ISignedNumber getIm() {
        if (this._imaginary.getDenominator().equals(BigInteger.ONE)) {
            return IntegerSym.newInstance(this._imaginary.getNumerator());
        }
        return FractionSym.newInstance(this._imaginary);
    }

    @Override
    public BigFraction getRealPart() {
        return this._real;
    }

    @Override
    public ISignedNumber getRe() {
        if (this._real.getDenominator().equals(BigInteger.ONE)) {
            return IntegerSym.newInstance(this._real.getNumerator());
        }
        return FractionSym.newInstance(this._real);
    }

    @Override
    public final int hashCode() {
        if (this.fHashValue == 0) {
            this.fHashValue = this._real.hashCode() * 29 + this._imaginary.hashCode();
        }
        return this.fHashValue;
    }

    @Override
    public int hierarchy() {
        return 32;
    }

    @Override
    public boolean isZero() {
        return NumberUtil.isZero(this._real) && NumberUtil.isZero(this._imaginary);
    }

    @Override
    public IComplex multiply(IComplex parm1) {
        return ComplexSym.valueOf(this._real.multiply(parm1.getRealPart()).subtract(this._imaginary.multiply(parm1.getImaginaryPart())), this._real.multiply(parm1.getImaginaryPart()).add(parm1.getRealPart().multiply(this._imaginary)));
    }

    @Override
    public IComplex pow(int parm1) {
        int temp = parm1;
        if (parm1 == 0 && this._real.equals(BigFraction.ZERO) && this._imaginary.equals(BigFraction.ZERO)) {
            throw new ArithmeticException();
        }
        if (parm1 == 1) {
            return this;
        }
        IComplex res = ComplexSym.valueOf(BigFraction.ONE, BigFraction.ZERO);
        if (parm1 < 0) {
            temp *= -1;
        }
        for (int i = 0; i < temp; ++i) {
            res = res.multiply(this);
        }
        if (parm1 < 0) {
            BigFraction d = res.getRealPart().multiply(res.getRealPart()).add(res.getImaginaryPart().multiply(res.getImaginaryPart()));
            return ComplexSym.valueOf(res.getRealPart().divide(d), res.getImaginaryPart().negate().divide(d));
        }
        return res;
    }

    @Override
    public IExpr plus(IExpr that) {
        if (that instanceof ComplexSym) {
            return this.add((ComplexSym)that);
        }
        if (that instanceof IntegerSym) {
            return this.add(ComplexSym.valueOf((IntegerSym)that));
        }
        if (that instanceof FractionSym) {
            return this.add(ComplexSym.valueOf((FractionSym)that));
        }
        return super.plus(that);
    }

    @Override
    public ComplexSym negate() {
        return ComplexSym.valueOf(this._real.negate(), this._imaginary.negate());
    }

    @Override
    public INumber opposite() {
        return ComplexSym.valueOf(this._real.negate(), this._imaginary.negate());
    }

    @Override
    public IExpr times(IExpr that) {
        if (that instanceof ComplexSym) {
            return this.multiply((ComplexSym)that);
        }
        if (that instanceof IntegerSym) {
            return this.multiply(ComplexSym.valueOf((IntegerSym)that));
        }
        if (that instanceof FractionSym) {
            return this.multiply(ComplexSym.valueOf((FractionSym)that));
        }
        return super.times(that);
    }

    @Override
    public IExpr inverse() {
        BigFraction tmp = this._real.multiply(this._real).add(this._imaginary.multiply(this._imaginary));
        return ComplexSym.valueOf(this._real.divide(tmp), this._imaginary.negate().divide(tmp));
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            OutputFormFactory.get().convertComplex(sb, this, Integer.MIN_VALUE);
            return sb.toString();
        }
        catch (Exception e1) {
            StringBuilder tb = new StringBuilder();
            tb.append('(');
            tb.append(this._real.toString());
            tb.append(")+I*(");
            tb.append(this._imaginary.toString());
            tb.append(')');
            return tb.toString();
        }
    }

    @Override
    public String fullFormString() {
        StringBuffer buf = new StringBuffer("Complex");
        if (Config.PARSER_USE_LOWERCASE_SYMBOLS) {
            buf.append('(');
        } else {
            buf.append('[');
        }
        if (this._real.getDenominator().equals(BigInteger.ONE)) {
            buf.append(this._real.getNumerator().toString());
        } else {
            buf.append("Rational");
            if (Config.PARSER_USE_LOWERCASE_SYMBOLS) {
                buf.append('(');
            } else {
                buf.append('[');
            }
            buf.append(this._real.getNumerator().toString().toString());
            buf.append(',');
            buf.append(this._real.getDenominator().toString().toString());
            if (Config.PARSER_USE_LOWERCASE_SYMBOLS) {
                buf.append(')');
            } else {
                buf.append(']');
            }
        }
        buf.append(',');
        if (this._imaginary.getDenominator().equals(BigInteger.ONE)) {
            buf.append(this._imaginary.getNumerator().toString());
        } else {
            buf.append("Rational");
            if (Config.PARSER_USE_LOWERCASE_SYMBOLS) {
                buf.append('(');
            } else {
                buf.append('[');
            }
            buf.append(this._imaginary.getNumerator().toString().toString());
            buf.append(',');
            buf.append(this._imaginary.getDenominator().toString().toString());
            if (Config.PARSER_USE_LOWERCASE_SYMBOLS) {
                buf.append(')');
            } else {
                buf.append(']');
            }
        }
        if (Config.PARSER_USE_LOWERCASE_SYMBOLS) {
            buf.append(')');
        } else {
            buf.append(']');
        }
        return buf.toString();
    }

    @Override
    public String internalFormString(boolean symbolsAsFactoryMethod, int depth) {
        int real_numerator = NumberUtil.toInt(this._real.getNumerator());
        int real_denominator = NumberUtil.toInt(this._real.getDenominator());
        int imag_numerator = NumberUtil.toInt(this._imaginary.getNumerator());
        int imag_denominator = NumberUtil.toInt(this._imaginary.getDenominator());
        if (this._real.equals(BigFraction.ZERO)) {
            if (this._imaginary.equals(BigFraction.ONE)) {
                return "CI";
            }
            if (this._imaginary.equals(BigFraction.MINUS_ONE)) {
                return "CNI";
            }
        }
        return "CC(" + real_numerator + "L," + real_denominator + "L," + imag_numerator + "L," + imag_denominator + "L)";
    }

    @Override
    public INumber normalize() {
        if (this._imaginary.equals(BigFraction.ZERO)) {
            if (this._real.getDenominator().equals(BigInteger.ONE)) {
                return F.integer(this._real.getNumerator());
            }
            if (this._real.getNumerator().equals(BigInteger.ZERO)) {
                return F.C0;
            }
            return FractionSym.newInstance(this._real);
        }
        return this;
    }

    @Override
    public int complexSign() {
        int i = this._real.getNumerator().signum();
        if (i == 0) {
            return this._imaginary.getNumerator().signum();
        }
        return i;
    }

    @Override
    public int compareTo(IExpr expr) {
        if (expr instanceof ComplexSym) {
            int cp = this._real.compareTo(((ComplexSym)expr)._real);
            if (cp != 0) {
                return cp;
            }
            return this._imaginary.compareTo(((ComplexSym)expr)._imaginary);
        }
        return super.compareTo(expr);
    }

    @Override
    public ISymbol head() {
        return F.Complex;
    }

    @Override
    public <T> T accept(IVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }

    @Override
    public long accept(IVisitorLong visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equalsInt(int i) {
        return false;
    }

    @Override
    public INumber ceil() throws ArithmeticException {
        return ComplexSym.valueOf(NumberUtil.ceiling(this._real), NumberUtil.ceiling(this._imaginary));
    }

    @Override
    public INumber floor() throws ArithmeticException {
        return ComplexSym.valueOf(NumberUtil.floor(this._real), NumberUtil.floor(this._imaginary));
    }
}

