/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import org.apfloat.Apcomplex;
import org.apfloat.Apfloat;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.ApcomplexNum;
import org.matheclipse.core.expression.ApfloatNum;
import org.matheclipse.core.expression.ExprImpl;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.form.output.OutputFormFactory;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;
import org.matheclipse.core.visit.IVisitorLong;
import org.matheclipse.parser.client.math.Complex;

public class ComplexNum
extends ExprImpl
implements IComplexNum {
    private static final long serialVersionUID = -6033055105824482264L;
    public static final ComplexNum I = ComplexNum.valueOf(0.0, 1.0);
    public static final ComplexNum NaN = ComplexNum.valueOf(Double.NaN, Double.NaN);
    public static final ComplexNum ONE = ComplexNum.valueOf(1.0, 0.0);
    public static final ComplexNum ZERO = ComplexNum.valueOf(0.0, 0.0);
    org.apache.commons.math3.complex.Complex fComplex;

    protected static ComplexNum newInstance(org.apache.commons.math3.complex.Complex value) {
        ComplexNum d = new ComplexNum(0.0, 0.0);
        d.fComplex = value;
        return d;
    }

    public static ComplexNum valueOf(INum d) {
        return ComplexNum.newInstance(new org.apache.commons.math3.complex.Complex(d.getRealPart(), 0.0));
    }

    public static ComplexNum valueOf(org.apache.commons.math3.complex.Complex c) {
        return ComplexNum.newInstance(c);
    }

    public static ComplexNum valueOf(double real) {
        return ComplexNum.newInstance(new org.apache.commons.math3.complex.Complex(real, 0.0));
    }

    public static ComplexNum valueOf(double real, double imaginary) {
        return ComplexNum.newInstance(new org.apache.commons.math3.complex.Complex(real, imaginary));
    }

    private ComplexNum(double r, double i) {
        this.fComplex = new org.apache.commons.math3.complex.Complex(r, i);
    }

    @Override
    public double getImaginaryPart() {
        double temp = this.fComplex.getImaginary();
        if (temp == -0.0) {
            temp = 0.0;
        }
        return temp;
    }

    @Override
    public double getRealPart() {
        double temp = this.fComplex.getReal();
        if (temp == -0.0) {
            temp = 0.0;
        }
        return temp;
    }

    @Override
    public boolean isZero() {
        return this.fComplex.getReal() == 0.0 && this.fComplex.getImaginary() == 0.0;
    }

    @Override
    public int hierarchy() {
        return 4;
    }

    @Override
    public IComplexNum add(IComplexNum val) {
        return ComplexNum.newInstance(this.fComplex.add(((ComplexNum)val).fComplex));
    }

    public ComplexNum add(ComplexNum that) {
        return ComplexNum.newInstance(this.fComplex.add(that.fComplex));
    }

    public Apcomplex apcomplexValue(long precision) {
        return new Apcomplex(new Apfloat(this.fComplex.getReal(), precision), new Apfloat(this.fComplex.getImaginary(), precision));
    }

    @Override
    public ApcomplexNum apcomplexNumValue(long precision) {
        return ApcomplexNum.valueOf(this.apcomplexValue(precision));
    }

    @Override
    public ComplexNum complexNumValue() {
        return this;
    }

    @Override
    public IComplexNum multiply(IComplexNum val) {
        return ComplexNum.newInstance(this.fComplex.multiply(((ComplexNum)val).fComplex));
    }

    @Override
    public IComplexNum pow(IComplexNum val) {
        return ComplexNum.newInstance(this.fComplex.pow(((ComplexNum)val).fComplex));
    }

    public org.apache.commons.math3.complex.Complex add(org.apache.commons.math3.complex.Complex that) {
        return this.fComplex.add(that);
    }

    @Override
    public IComplexNum conjugate() {
        return ComplexNum.newInstance(this.fComplex.conjugate());
    }

    @Override
    public org.apache.commons.math3.complex.Complex divide(org.apache.commons.math3.complex.Complex that) {
        return this.fComplex.divide(that);
    }

    @Override
    public ComplexNum divide(ComplexNum that) throws ArithmeticException {
        return ComplexNum.newInstance(this.fComplex.divide(that.fComplex));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ComplexNum) {
            return this.fComplex.equals(((ComplexNum)obj).fComplex);
        }
        return false;
    }

    @Override
    public IExpr evaluate(EvalEngine engine) {
        if (engine.isNumericMode() && engine.isApfloat()) {
            return ApcomplexNum.valueOf(this.getRealPart(), this.getImaginaryPart(), engine.getNumericPrecision());
        }
        if (F.isZero(this.getImaginaryPart())) {
            return F.num(this.getRealPart());
        }
        return null;
    }

    @Override
    public boolean isSame(IExpr expression, double epsilon) {
        if (expression instanceof ComplexNum) {
            return F.isZero(this.fComplex.getReal() - ((ComplexNum)expression).fComplex.getReal(), epsilon) && F.isZero(this.fComplex.getImaginary() - ((ComplexNum)expression).fComplex.getImaginary(), epsilon);
        }
        return false;
    }

    @Override
    public double dabs() {
        return ComplexNum.dabs(this.fComplex);
    }

    public static double dabs(org.apache.commons.math3.complex.Complex c) {
        if (c.isNaN()) {
            return Double.NaN;
        }
        if (c.isInfinite()) {
            return Double.POSITIVE_INFINITY;
        }
        if (Math.abs(c.getReal()) < Math.abs(c.getImaginary())) {
            if (c.getImaginary() == 0.0) {
                return Math.abs(c.getReal());
            }
            double q = c.getReal() / c.getImaginary();
            return Math.abs(c.getImaginary()) * Math.sqrt(1.0 + q * q);
        }
        if (c.getReal() == 0.0) {
            return Math.abs(c.getImaginary());
        }
        double q = c.getImaginary() / c.getReal();
        return Math.abs(c.getReal()) * Math.sqrt(1.0 + q * q);
    }

    @Override
    public Num eabs() {
        return Num.valueOf(this.dabs());
    }

    @Override
    public int compareAbsValueToOne() {
        double temp = this.dabs();
        return Double.compare(temp, 1.0);
    }

    public double getImaginary() {
        return this.fComplex.getImaginary();
    }

    public double getReal() {
        return this.fComplex.getReal();
    }

    @Override
    public final int hashCode() {
        return this.fComplex.hashCode();
    }

    public boolean isInfinite() {
        return this.fComplex.isInfinite();
    }

    public boolean isNaN() {
        return this.fComplex.isNaN();
    }

    @Override
    public ComplexNum multiply(ComplexNum that) {
        return ComplexNum.newInstance(this.fComplex.multiply(that.fComplex));
    }

    @Override
    public ComplexNum negate() {
        return ComplexNum.newInstance(this.fComplex.negate());
    }

    @Override
    public INumber opposite() {
        return ComplexNum.newInstance(this.fComplex.negate());
    }

    @Override
    public IExpr plus(IExpr that) {
        if (that instanceof ComplexNum) {
            return ComplexNum.newInstance(this.fComplex.add(((ComplexNum)that).fComplex));
        }
        if (that instanceof ApcomplexNum) {
            ApcomplexNum acn = (ApcomplexNum)that;
            return ApcomplexNum.valueOf(this.getRealPart(), this.getImaginaryPart(), acn.fApcomplex.precision()).add(acn);
        }
        if (that instanceof ApfloatNum) {
            ApfloatNum afn = (ApfloatNum)that;
            return ApcomplexNum.valueOf(this.getRealPart(), this.getImaginaryPart(), afn.fApfloat.precision()).add(ApcomplexNum.valueOf(afn.fApfloat, Apfloat.ZERO));
        }
        if (that instanceof Num) {
            return this.add(ComplexNum.valueOf(((Num)that).getRealPart()));
        }
        return super.plus(that);
    }

    @Override
    public IExpr inverse() {
        double tmp = this.fComplex.getReal() * this.fComplex.getReal() + this.fComplex.getImaginary() * this.fComplex.getImaginary();
        return ComplexNum.valueOf(this.fComplex.getReal() / tmp, -this.fComplex.getImaginary() / tmp);
    }

    @Override
    public org.apache.commons.math3.complex.Complex subtract(org.apache.commons.math3.complex.Complex that) {
        return this.fComplex.subtract(that);
    }

    @Override
    public ComplexNum subtract(ComplexNum that) {
        return ComplexNum.newInstance(this.fComplex.subtract(that.fComplex));
    }

    @Override
    public IExpr times(IExpr that) {
        if (that instanceof ComplexNum) {
            return ComplexNum.newInstance(this.fComplex.multiply(((ComplexNum)that).fComplex));
        }
        if (that instanceof ApcomplexNum) {
            ApcomplexNum acn = (ApcomplexNum)that;
            return ApcomplexNum.valueOf(this.getRealPart(), this.getImaginaryPart(), acn.fApcomplex.precision()).multiply(acn);
        }
        if (that instanceof ApfloatNum) {
            ApfloatNum afn = (ApfloatNum)that;
            return ApcomplexNum.valueOf(this.getRealPart(), this.getImaginaryPart(), afn.fApfloat.precision()).multiply(ApcomplexNum.valueOf(afn.fApfloat, Apfloat.ZERO));
        }
        if (that instanceof Num) {
            return this.multiply(ComplexNum.valueOf(((Num)that).getRealPart()));
        }
        return super.times(that);
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            OutputFormFactory.get().convertDoubleComplex(sb, this, Integer.MIN_VALUE);
            return sb.toString();
        }
        catch (Exception exception) {
            return this.fComplex.toString();
        }
    }

    @Override
    public int complexSign() {
        int i = (int)Math.signum(this.fComplex.getReal());
        if (i == 0) {
            return (int)Math.signum(this.fComplex.getImaginary());
        }
        return i;
    }

    @Override
    public int compareTo(org.apache.commons.math3.complex.Complex that) {
        long l2;
        if (this.fComplex.getReal() < that.getReal()) {
            return -1;
        }
        if (this.fComplex.getReal() > that.getReal()) {
            return 1;
        }
        long l1 = Double.doubleToLongBits(this.fComplex.getReal());
        if (l1 < (l2 = Double.doubleToLongBits(that.getReal()))) {
            return -1;
        }
        if (l2 > l1) {
            return 1;
        }
        if (this.fComplex.getImaginary() < that.getImaginary()) {
            return -1;
        }
        if (this.fComplex.getImaginary() > that.getImaginary()) {
            return 1;
        }
        l1 = Double.doubleToLongBits(this.fComplex.getImaginary());
        if (l1 < (l2 = Double.doubleToLongBits(that.getImaginary()))) {
            return -1;
        }
        if (l2 > l1) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareTo(IExpr expr) {
        if (expr instanceof ComplexNum) {
            return this.compareTo(((ComplexNum)expr).fComplex);
        }
        return super.compareTo(expr);
    }

    @Override
    public ISymbol head() {
        return F.Complex;
    }

    public org.apache.commons.math3.complex.Complex complexValue() {
        return this.fComplex;
    }

    public Complex getCMComplex() {
        return new Complex(this.fComplex.getReal(), this.fComplex.getImaginary());
    }

    @Override
    public <T> T accept(IVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }

    @Override
    public long accept(IVisitorLong visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equalsInt(int i) {
        return false;
    }

    @Override
    public ISignedNumber getIm() {
        return F.num(this.getImaginaryPart());
    }

    @Override
    public ISignedNumber getRe() {
        return F.num(this.getRealPart());
    }

    @Override
    public INumber ceil() throws ArithmeticException {
        return ComplexNum.valueOf(Math.ceil(this.fComplex.getReal()), Math.ceil(this.fComplex.getImaginary()));
    }

    @Override
    public INumber floor() throws ArithmeticException {
        return ComplexNum.valueOf(Math.floor(this.fComplex.getReal()), Math.floor(this.fComplex.getImaginary()));
    }
}

