/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.math.BigInteger;
import java.math.RoundingMode;
import org.apfloat.Apcomplex;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatMath;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.Apint;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.ApcomplexNum;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.ExprImpl;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;
import org.matheclipse.core.visit.IVisitorLong;

public class ApfloatNum
extends ExprImpl
implements INum {
    private static final long serialVersionUID = 2500259920655377884L;
    Apfloat fApfloat;

    public static ApfloatNum valueOf(double value, long precision) {
        return new ApfloatNum(value, precision);
    }

    public static ApfloatNum valueOf(Apfloat value) {
        return new ApfloatNum(value);
    }

    public static ApfloatNum valueOf(BigInteger numerator, long precision) {
        return new ApfloatNum(numerator, precision);
    }

    public static ApfloatNum valueOf(BigInteger numerator, BigInteger denominator, long precision) {
        Apfloat n = new Apfloat(numerator, precision);
        Apfloat d = new Apfloat(denominator, precision);
        return new ApfloatNum(n.divide(d));
    }

    public static ApfloatNum valueOf(String value, int precision) {
        return new ApfloatNum(value, (long)precision);
    }

    private ApfloatNum(double value, long precision) {
        this.fApfloat = new Apfloat(value, precision);
    }

    private ApfloatNum(String value, long precision) {
        this.fApfloat = new Apfloat(value, precision);
    }

    private ApfloatNum(BigInteger value, long precision) {
        this.fApfloat = new Apfloat(value, precision);
    }

    private ApfloatNum(Apfloat value) {
        this.fApfloat = value;
    }

    @Override
    public int hierarchy() {
        return 2;
    }

    @Override
    public boolean isNumEqualInteger(IInteger ii) throws ArithmeticException {
        return this.fApfloat.frac().equals(new Apint(ii.getBigNumerator()));
    }

    @Override
    public boolean isNumIntValue() {
        return this.fApfloat.frac().equals(Apfloat.ZERO);
    }

    @Override
    public boolean isNegative() {
        return this.fApfloat.compareTo(Apfloat.ZERO) < 0;
    }

    @Override
    public boolean isPositive() {
        return this.fApfloat.compareTo(Apfloat.ZERO) > 0;
    }

    @Override
    public boolean equalsInt(int i) {
        return this.fApfloat.intValue() == i;
    }

    @Override
    public IExpr evaluate(EvalEngine engine) {
        return null;
    }

    @Override
    public INum add(INum val) {
        return ApfloatNum.valueOf(this.fApfloat.add(((ApfloatNum)val).fApfloat));
    }

    @Override
    public INum multiply(INum val) {
        return ApfloatNum.valueOf(this.fApfloat.multiply(((ApfloatNum)val).fApfloat));
    }

    @Override
    public INum pow(INum val) {
        return ApfloatNum.valueOf(ApfloatMath.pow(this.fApfloat, ((ApfloatNum)val).fApfloat));
    }

    public long precision() throws ApfloatRuntimeException {
        return this.fApfloat.precision();
    }

    @Override
    public ApfloatNum eabs() {
        return ApfloatNum.valueOf(ApfloatMath.abs(this.fApfloat));
    }

    @Override
    public int compareAbsValueToOne() {
        return ApfloatMath.abs(this.fApfloat).compareTo(Apfloat.ONE);
    }

    @Override
    public IExpr plus(IExpr that) {
        if (that instanceof ApfloatNum) {
            return this.add((ApfloatNum)that);
        }
        if (that instanceof Num) {
            return this.add(ApfloatNum.valueOf(((Num)that).getRealPart(), this.fApfloat.precision()));
        }
        if (that instanceof ApcomplexNum) {
            return ApcomplexNum.valueOf(this.fApfloat, Apfloat.ZERO).add((ApcomplexNum)that);
        }
        if (that instanceof ComplexNum) {
            ComplexNum cn = (ComplexNum)that;
            return ApcomplexNum.valueOf(this.fApfloat, Apfloat.ZERO).add(ApcomplexNum.valueOf(cn.getRealPart(), cn.getImaginaryPart(), this.fApfloat.precision()));
        }
        return super.plus(that);
    }

    @Override
    public ISignedNumber divideBy(ISignedNumber that) {
        return ApfloatNum.valueOf(this.fApfloat.divide(((ApfloatNum)that).fApfloat));
    }

    @Override
    public ISignedNumber subtractFrom(ISignedNumber that) {
        return ApfloatNum.valueOf(this.fApfloat.subtract(((ApfloatNum)that).fApfloat));
    }

    @Override
    public double doubleValue() {
        return this.fApfloat.doubleValue();
    }

    public Apfloat apfloatValue() {
        return this.fApfloat;
    }

    @Override
    public boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 instanceof ApfloatNum) {
            return this.fApfloat == ((ApfloatNum)arg0).fApfloat;
        }
        return false;
    }

    @Override
    public boolean isSame(IExpr expression, double epsilon) {
        if (expression instanceof ApfloatNum) {
            return this.fApfloat.equals(((ApfloatNum)expression).fApfloat);
        }
        return false;
    }

    public Apfloat exp() {
        return ApfloatMath.exp(this.fApfloat);
    }

    @Override
    public final int hashCode() {
        return this.fApfloat.hashCode();
    }

    @Override
    public int intValue() {
        return this.fApfloat.intValue();
    }

    @Override
    public int toInt() throws ArithmeticException {
        int i = this.fApfloat.intValue();
        if (i == Integer.MAX_VALUE || i == Integer.MIN_VALUE) {
            throw new ArithmeticException("ApfloatNum:toInt: number out of range");
        }
        return i;
    }

    @Override
    public long toLong() throws ArithmeticException {
        long l = this.fApfloat.longValue();
        if (l == Long.MAX_VALUE || l == Long.MIN_VALUE) {
            throw new ArithmeticException("ApfloatNum:toLong: number out of range");
        }
        return l;
    }

    public Apfloat log() {
        return ApfloatMath.log(this.fApfloat);
    }

    public long longValue() {
        return this.fApfloat.longValue();
    }

    @Override
    public IExpr times(IExpr that) {
        if (that instanceof ApfloatNum) {
            return this.multiply((ApfloatNum)that);
        }
        if (that instanceof Num) {
            return this.multiply(ApfloatNum.valueOf(((Num)that).getRealPart(), this.fApfloat.precision()));
        }
        if (that instanceof ApcomplexNum) {
            return ApcomplexNum.valueOf(this.fApfloat, Apfloat.ZERO).multiply((ApcomplexNum)that);
        }
        if (that instanceof ComplexNum) {
            ComplexNum cn = (ComplexNum)that;
            return ApcomplexNum.valueOf(this.fApfloat, Apfloat.ZERO).multiply(ApcomplexNum.valueOf(cn.getRealPart(), cn.getImaginaryPart(), this.fApfloat.precision()));
        }
        return super.times(that);
    }

    @Override
    public ISignedNumber negate() {
        return ApfloatNum.valueOf(this.fApfloat.negate());
    }

    @Override
    public ISignedNumber opposite() {
        return ApfloatNum.valueOf(this.fApfloat.negate());
    }

    @Override
    public ISignedNumber inverse() {
        return ApfloatNum.valueOf(ApfloatMath.inverseRoot(this.fApfloat, 1L));
    }

    public Apfloat sqrt() {
        return ApfloatMath.sqrt(this.fApfloat);
    }

    @Override
    public double getRealPart() {
        double temp = this.fApfloat.doubleValue();
        if (temp == -0.0) {
            temp = 0.0;
        }
        return temp;
    }

    @Override
    public boolean isE() {
        return this.fApfloat.equals(ApfloatMath.exp(Apfloat.ONE));
    }

    @Override
    public boolean isMinusOne() {
        return this.fApfloat.equals(Apfloat.MINUS_ONE);
    }

    @Override
    public boolean isOne() {
        return this.fApfloat.equals(Apfloat.ONE);
    }

    @Override
    public boolean isPi() {
        return this.fApfloat.equals(ApfloatMath.pi(this.fApfloat.precision()));
    }

    @Override
    public boolean isZero() {
        return this.fApfloat.equals(Apfloat.ZERO);
    }

    @Override
    public IInteger round() {
        Apfloat f = ApfloatMath.round(this.fApfloat, 1L, RoundingMode.HALF_UP);
        return F.integer(ApfloatMath.floor(f).toBigInteger());
    }

    @Override
    public int sign() {
        return this.fApfloat.signum();
    }

    @Override
    public int complexSign() {
        return this.sign();
    }

    @Override
    public IInteger ceil() {
        return F.integer(ApfloatMath.ceil(this.fApfloat).toBigInteger());
    }

    @Override
    public IInteger floor() {
        return F.integer(ApfloatMath.floor(this.fApfloat).toBigInteger());
    }

    @Override
    public int compareTo(IExpr expr) {
        if (expr instanceof ApfloatNum) {
            return this.fApfloat.compareTo(((ApfloatNum)expr).fApfloat);
        }
        return super.compareTo(expr);
    }

    @Override
    public boolean isLessThan(ISignedNumber that) {
        return this.fApfloat.compareTo(((ApfloatNum)that).fApfloat) < 0;
    }

    @Override
    public boolean isGreaterThan(ISignedNumber that) {
        return this.fApfloat.compareTo(((ApfloatNum)that).fApfloat) > 0;
    }

    @Override
    public ISymbol head() {
        return F.RealHead;
    }

    public String toString() {
        return this.fApfloat.toString();
    }

    @Override
    public <T> T accept(IVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }

    @Override
    public long accept(IVisitorLong visitor) {
        return visitor.visit(this);
    }

    @Override
    public ISignedNumber getIm() {
        return F.CD0;
    }

    @Override
    public ISignedNumber getRe() {
        return this;
    }

    @Override
    public ApfloatNum apfloatNumValue(long precision) {
        return this;
    }

    @Override
    public Num numValue() {
        return Num.valueOf(this.doubleValue());
    }

    public Apcomplex apcomplexValue(long precision) {
        return new Apcomplex(this.fApfloat);
    }

    @Override
    public ApcomplexNum apcomplexNumValue(long precision) {
        return ApcomplexNum.valueOf(this.fApfloat, Apfloat.ZERO);
    }

    @Override
    public ComplexNum complexNumValue() {
        return ComplexNum.valueOf(this.fApfloat.doubleValue());
    }
}

