/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.math.BigInteger;
import org.apfloat.Apcomplex;
import org.apfloat.ApcomplexMath;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatMath;
import org.apfloat.ApfloatRuntimeException;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.ApfloatNum;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.ExprImpl;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.form.output.OutputFormFactory;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;
import org.matheclipse.core.visit.IVisitorLong;
import org.matheclipse.parser.client.math.Complex;

public class ApcomplexNum
extends ExprImpl
implements IComplexNum {
    private static final long serialVersionUID = -6033055105824482264L;
    public static final ApcomplexNum I = new ApcomplexNum(Apcomplex.I);
    public static final ApcomplexNum ONE = new ApcomplexNum(Apcomplex.ONE);
    public static final ApcomplexNum ZERO = new ApcomplexNum(Apcomplex.ZERO);
    Apcomplex fApcomplex;

    public static ApcomplexNum valueOf(Apcomplex value) {
        return new ApcomplexNum(value);
    }

    public static ApcomplexNum valueOf(Apfloat real, Apfloat imag) {
        return new ApcomplexNum(real, imag);
    }

    public static ApcomplexNum valueOf(double real, long precision) {
        return ApcomplexNum.valueOf(new Apcomplex(new Apfloat(real, precision), Apfloat.ZERO));
    }

    public static ApcomplexNum valueOf(double real, double imaginary, long precision) {
        return ApcomplexNum.valueOf(new Apcomplex(new Apfloat(real, precision), new Apfloat(imaginary, precision)));
    }

    public static ApcomplexNum valueOf(BigInteger realNumerator, BigInteger realDenominator, BigInteger imagNumerator, BigInteger imagDenominator, int precision) {
        Apfloat real = new Apfloat(realNumerator, (long)precision).divide(new Apfloat(realDenominator, (long)precision));
        Apfloat imag = new Apfloat(imagNumerator, (long)precision).divide(new Apfloat(imagDenominator, (long)precision));
        return new ApcomplexNum(real, imag);
    }

    private ApcomplexNum(Apcomplex complex) {
        this.fApcomplex = complex;
    }

    private ApcomplexNum(Apfloat real, Apfloat imag) {
        this.fApcomplex = new Apcomplex(real, imag);
    }

    @Override
    public double getImaginaryPart() {
        double temp = this.fApcomplex.imag().doubleValue();
        if (temp == -0.0) {
            temp = 0.0;
        }
        return temp;
    }

    public Apcomplex apcomplexValue() {
        return this.fApcomplex;
    }

    @Override
    public ApcomplexNum apcomplexNumValue(long precision) {
        return this;
    }

    @Override
    public ComplexNum complexNumValue() {
        return ComplexNum.valueOf(this.fApcomplex.real().doubleValue(), this.fApcomplex.imag().doubleValue());
    }

    @Override
    public double getRealPart() {
        double temp = this.fApcomplex.real().doubleValue();
        if (temp == -0.0) {
            temp = 0.0;
        }
        return temp;
    }

    @Override
    public boolean isZero() {
        return this.fApcomplex.equals(Apcomplex.ZERO);
    }

    @Override
    public int hierarchy() {
        return 4;
    }

    @Override
    public IComplexNum add(IComplexNum val) {
        return ApcomplexNum.valueOf(this.fApcomplex.add(((ApcomplexNum)val).fApcomplex));
    }

    public ApcomplexNum add(ApcomplexNum that) {
        return ApcomplexNum.valueOf(this.fApcomplex.add(that.fApcomplex));
    }

    @Override
    public IComplexNum multiply(IComplexNum val) {
        return ApcomplexNum.valueOf(this.fApcomplex.multiply(((ApcomplexNum)val).fApcomplex));
    }

    @Override
    public IComplexNum pow(IComplexNum val) {
        return ApcomplexNum.valueOf(ApcomplexMath.pow(this.fApcomplex, ((ApcomplexNum)val).fApcomplex));
    }

    public Apcomplex add(Apcomplex that) {
        return this.fApcomplex.add(that);
    }

    @Override
    public IComplexNum conjugate() {
        return ApcomplexNum.valueOf(this.fApcomplex.conj());
    }

    @Override
    public Apcomplex divide(Apcomplex that) {
        return this.fApcomplex.divide(that);
    }

    @Override
    public ApcomplexNum divide(ApcomplexNum that) throws ArithmeticException {
        return ApcomplexNum.valueOf(this.fApcomplex.divide(that.fApcomplex));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ApcomplexNum) {
            return this.fApcomplex.equals(((ApcomplexNum)obj).fApcomplex);
        }
        return false;
    }

    @Override
    public IExpr evaluate(EvalEngine engine) {
        if (this.fApcomplex.imag().equals(Apfloat.ZERO)) {
            return ApfloatNum.valueOf(this.fApcomplex.real());
        }
        return null;
    }

    @Override
    public boolean isSame(IExpr expression, double epsilon) {
        if (expression instanceof ApcomplexNum) {
            return this.fApcomplex.equals(((ApcomplexNum)expression).fApcomplex);
        }
        return false;
    }

    @Override
    public double dabs() {
        if (Math.abs(this.getReal()) < Math.abs(this.getImaginary())) {
            if (this.getImaginary() == 0.0) {
                return Math.abs(this.getReal());
            }
            double q = this.getReal() / this.getImaginary();
            return Math.abs(this.getImaginary()) * Math.sqrt(1.0 + q * q);
        }
        if (this.getReal() == 0.0) {
            return Math.abs(this.getImaginary());
        }
        double q = this.getImaginary() / this.getReal();
        return Math.abs(this.getReal()) * Math.sqrt(1.0 + q * q);
    }

    @Override
    public Num eabs() {
        return Num.valueOf(this.dabs());
    }

    @Override
    public int compareAbsValueToOne() {
        double temp = this.dabs();
        return Double.compare(temp, 1.0);
    }

    public double getImaginary() {
        return this.fApcomplex.imag().doubleValue();
    }

    public double getReal() {
        return this.fApcomplex.real().doubleValue();
    }

    @Override
    public final int hashCode() {
        return this.fApcomplex.hashCode();
    }

    @Override
    public ApcomplexNum multiply(ApcomplexNum that) {
        return ApcomplexNum.valueOf(this.fApcomplex.multiply(that.fApcomplex));
    }

    @Override
    public ApcomplexNum negate() {
        return ApcomplexNum.valueOf(this.fApcomplex.negate());
    }

    @Override
    public INumber opposite() {
        return ApcomplexNum.valueOf(this.fApcomplex.negate());
    }

    @Override
    public IExpr plus(IExpr that) {
        if (that instanceof ApcomplexNum) {
            return ApcomplexNum.valueOf(this.fApcomplex.add(((ApcomplexNum)that).fApcomplex));
        }
        if (that instanceof ApfloatNum) {
            return this.add(ApcomplexNum.valueOf(((ApfloatNum)that).fApfloat, Apfloat.ZERO));
        }
        if (that instanceof Num) {
            return this.add(ApcomplexNum.valueOf(((Num)that).getRealPart(), this.fApcomplex.precision()));
        }
        if (that instanceof ComplexNum) {
            ComplexNum cn = (ComplexNum)that;
            return this.add(ApcomplexNum.valueOf(cn.getRealPart(), cn.getImaginaryPart(), this.fApcomplex.precision()));
        }
        return super.plus(that);
    }

    @Override
    public IExpr inverse() {
        return ApcomplexNum.valueOf(ApcomplexMath.inverseRoot(this.fApcomplex, 1L));
    }

    @Override
    public Apcomplex subtract(Apcomplex that) {
        return this.fApcomplex.subtract(that);
    }

    @Override
    public ApcomplexNum subtract(ApcomplexNum that) {
        return ApcomplexNum.valueOf(this.fApcomplex.subtract(that.fApcomplex));
    }

    @Override
    public IExpr times(IExpr that) {
        if (that instanceof ApcomplexNum) {
            return ApcomplexNum.valueOf(this.fApcomplex.multiply(((ApcomplexNum)that).fApcomplex));
        }
        if (that instanceof ApfloatNum) {
            return this.multiply(ApcomplexNum.valueOf(((ApfloatNum)that).fApfloat, Apfloat.ZERO));
        }
        if (that instanceof Num) {
            return this.multiply(ApcomplexNum.valueOf(((Num)that).getRealPart(), this.fApcomplex.precision()));
        }
        if (that instanceof ComplexNum) {
            ComplexNum cn = (ComplexNum)that;
            return this.multiply(ApcomplexNum.valueOf(cn.getRealPart(), cn.getImaginaryPart(), this.fApcomplex.precision()));
        }
        return super.times(that);
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            OutputFormFactory.get().convertApcomplex(sb, this.apcomplexValue(), Integer.MIN_VALUE);
            return sb.toString();
        }
        catch (Exception exception) {
            return this.fApcomplex.toString();
        }
    }

    @Override
    public int complexSign() {
        int i = this.fApcomplex.real().signum();
        if (i == 0) {
            return this.fApcomplex.imag().signum();
        }
        return i;
    }

    @Override
    public int compareTo(Apcomplex that) {
        if (this.fApcomplex.real().compareTo(that.real()) < 0) {
            return -1;
        }
        if (this.fApcomplex.real().compareTo(that.real()) > 0) {
            return 1;
        }
        return this.fApcomplex.imag().compareTo(that.imag());
    }

    @Override
    public int compareTo(IExpr expr) {
        if (expr instanceof ApcomplexNum) {
            return this.compareTo(((ApcomplexNum)expr).fApcomplex);
        }
        return super.compareTo(expr);
    }

    @Override
    public ISymbol head() {
        return F.Complex;
    }

    public Apcomplex getComplex() {
        return this.fApcomplex;
    }

    public Complex getCMComplex() {
        return new Complex(this.fApcomplex.real().doubleValue(), this.fApcomplex.imag().doubleValue());
    }

    @Override
    public <T> T accept(IVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }

    @Override
    public long accept(IVisitorLong visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equalsInt(int i) {
        return false;
    }

    @Override
    public ISignedNumber getIm() {
        return F.num(this.getImaginaryPart());
    }

    @Override
    public ISignedNumber getRe() {
        return F.num(this.getRealPart());
    }

    @Override
    public INumber ceil() throws ArithmeticException {
        return F.complex(F.integer(ApfloatMath.ceil(this.fApcomplex.real()).toBigInteger()), F.integer(ApfloatMath.ceil(this.fApcomplex.imag()).toBigInteger()));
    }

    @Override
    public INumber floor() throws ArithmeticException {
        return F.complex(F.integer(ApfloatMath.floor(this.fApcomplex.real()).toBigInteger()), F.integer(ApfloatMath.floor(this.fApcomplex.imag()).toBigInteger()));
    }

    public long precision() throws ApfloatRuntimeException {
        return this.fApcomplex.precision();
    }
}

