/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import edu.jas.structure.ElemFactory;
import java.math.BigInteger;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.commons.math3.complex.Complex;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.function.LeafCount;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.expression.ASTRange;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.ExprImpl;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.HMArrayList;
import org.matheclipse.core.expression.IntegerSym;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.expression.StringX;
import org.matheclipse.core.expression.Symbol;
import org.matheclipse.core.form.output.OutputFormFactory;
import org.matheclipse.core.generic.Functors;
import org.matheclipse.core.generic.IsUnaryVariableOrPattern;
import org.matheclipse.core.generic.Predicates;
import org.matheclipse.core.generic.UnaryVariable2Slot;
import org.matheclipse.core.generic.interfaces.BiFunction;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.PatternMatcher;
import org.matheclipse.core.polynomials.Polynomial;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;
import org.matheclipse.core.visit.IVisitorLong;
import org.matheclipse.core.visit.VisitorReplaceAll;
import org.matheclipse.core.visit.VisitorReplacePart;
import org.matheclipse.core.visit.VisitorReplaceSlots;

public class AST
extends HMArrayList<IExpr>
implements IAST {
    protected EnumMap<IAST.PROPERTY, Object> fProperties = null;
    private static final long serialVersionUID = 4295200630292148027L;
    private transient int fEvalFlags = 0;
    protected transient int fPatternMatchingHashValue = 0;

    @Override
    public Object getProperty(IAST.PROPERTY key) {
        if (this.fProperties == null) {
            return null;
        }
        return this.fProperties.get((Object)key);
    }

    @Override
    public Object putProperty(IAST.PROPERTY key, Object value) {
        if (this.fProperties == null) {
            this.fProperties = new EnumMap(IAST.PROPERTY.class);
        }
        return this.fProperties.put(key, value);
    }

    public static AST parse(String inputString) {
        StringTokenizer tokenizer = new StringTokenizer(inputString, "[],", true);
        String token = tokenizer.nextToken();
        AST list = AST.newInstance(StringX.valueOf(token));
        token = tokenizer.nextToken();
        if (token.equals("[")) {
            AST.parseList(tokenizer, list);
            return list;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseList(StringTokenizer tokenizer, AST list) {
        String token = tokenizer.nextToken();
        do {
            block8: {
                AST argList;
                String arg;
                if (token.equals("]")) {
                    return;
                }
                if (token.equals(",")) {
                    arg = tokenizer.nextToken();
                    token = tokenizer.nextToken();
                    if (token.equals("[")) {
                        argList = AST.newInstance(StringX.valueOf(arg));
                        AST.parseList(tokenizer, argList);
                        list.add(argList);
                        break block8;
                    } else {
                        list.add(StringX.valueOf(arg));
                        continue;
                    }
                }
                if (!token.equals(" ")) {
                    arg = token;
                    token = tokenizer.nextToken();
                    if (token.equals("[")) {
                        argList = AST.newInstance(StringX.valueOf(arg));
                        AST.parseList(tokenizer, argList);
                        list.add(argList);
                    } else {
                        list.add(StringX.valueOf(arg));
                        continue;
                    }
                }
            }
            token = tokenizer.nextToken();
        } while (tokenizer.hasMoreTokens());
    }

    private AST(int initialCapacity, boolean setLength) {
        super(initialCapacity + 1);
        this.lastIndex += setLength ? initialCapacity + 1 : 0;
        ++this.modCount;
    }

    public AST() {
        super(0);
        ++this.lastIndex;
        ++this.modCount;
    }

    AST(IExpr[] es) {
        super(es);
    }

    public AST(IExpr head, IExpr ... es) {
        super(head, es);
    }

    @Override
    public IAST clone() {
        AST ast = (AST)super.clone();
        ast.fEvalFlags = 0;
        ast.fPatternMatchingHashValue = 0;
        ast.fProperties = null;
        return ast;
    }

    @Override
    public IAST setAtClone(int position, IExpr expr) {
        IAST ast = this.clone();
        ast.set(position, expr);
        return ast;
    }

    @Override
    public IExpr copy() {
        return this.clone();
    }

    public boolean equalsFromPosition(int from0, AST f1, int from1) {
        if (this.size() - from0 != f1.size() - from1) {
            return false;
        }
        int j = from1;
        for (int i = from0; i < this.size() - 1; ++i) {
            if (((IExpr)this.get(i + 1)).equals(f1.get(1 + j++))) continue;
            return false;
        }
        return true;
    }

    @Override
    public ISymbol topHead() {
        IExpr header = this.head();
        if (header instanceof ISymbol) {
            return (ISymbol)header;
        }
        if (header instanceof IAST) {
            return ((IAST)header).topHead();
        }
        if (header.isSignedNumber()) {
            if (header instanceof INum) {
                return F.RealHead;
            }
            if (header instanceof IInteger) {
                return F.IntegerHead;
            }
            if (header instanceof IFraction) {
                return F.Rational;
            }
        }
        if (header instanceof IComplex) {
            return F.Complex;
        }
        if (header instanceof IComplexNum) {
            return F.Complex;
        }
        if (header instanceof IPattern) {
            return F.PatternHead;
        }
        if (this.head() instanceof IStringX) {
            return F.StringHead;
        }
        return null;
    }

    @Override
    public final int hierarchy() {
        return 512;
    }

    @Override
    public final boolean isLTOrdered(IExpr obj) {
        return this.compareTo(obj) < 0;
    }

    @Override
    public final boolean isLEOrdered(IExpr obj) {
        return this.compareTo(obj) <= 0;
    }

    @Override
    public final boolean isGTOrdered(IExpr obj) {
        return this.compareTo(obj) > 0;
    }

    @Override
    public final boolean isGEOrdered(IExpr obj) {
        return this.compareTo(obj) >= 0;
    }

    @Override
    public final int getEvalFlags() {
        return this.fEvalFlags;
    }

    @Override
    public final void setEvalFlags(int i) {
        this.fEvalFlags = i;
    }

    @Override
    public final void addEvalFlags(int i) {
        this.fEvalFlags |= i;
    }

    @Override
    public IAST addOneIdentity(IAST value) {
        if (value.size() == 2) {
            this.add(value.arg1());
        } else {
            this.add(value);
        }
        return this;
    }

    @Override
    public IExpr getOneIdentity(IExpr defaultValue) {
        if (this.size() > 2) {
            return this;
        }
        if (this.size() == 2) {
            return this.arg1();
        }
        return defaultValue;
    }

    @Override
    public final boolean isEvalFlagOn(int i) {
        return (this.fEvalFlags & i) == i;
    }

    @Override
    public final boolean isEvalFlagOff(int i) {
        return (this.fEvalFlags & i) == 0;
    }

    @Override
    public IExpr opposite() {
        return F.Times((IExpr)F.CN1, (IExpr)this);
    }

    @Override
    public IExpr plus(IExpr that) {
        return F.Plus((IExpr)this, that);
    }

    @Override
    public IExpr inverse() {
        return F.eval(F.Power((IExpr)this, F.CN1));
    }

    @Override
    public IExpr times(IExpr that) {
        return F.Times((IExpr)this, that);
    }

    @Override
    public final boolean isList() {
        return this.isSameHeadSizeGE(F.List, 1);
    }

    @Override
    public final boolean isSequence() {
        return this.isSameHeadSizeGE(F.Sequence, 1);
    }

    @Override
    public boolean isListOfLists() {
        if (this.head().equals(F.List)) {
            for (int i = 1; i < this.size(); ++i) {
                if (((IExpr)this.get(i)).isList()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isComplexInfinity() {
        return this.isSameHead(F.DirectedInfinity, 1);
    }

    @Override
    public boolean isDirectedInfinity() {
        return this.get(0) == F.DirectedInfinity && (this.size() == 2 || this.size() == 1);
    }

    @Override
    public boolean isE() {
        return false;
    }

    @Override
    public boolean isIndeterminate() {
        return false;
    }

    @Override
    public boolean isInfinity() {
        return this.equals(F.CInfinity);
    }

    @Override
    public boolean isNegative() {
        IExpr result;
        if (this.isNumericFunction() && (result = F.evaln(this)).isSignedNumber()) {
            return ((ISignedNumber)result).isNegative();
        }
        return false;
    }

    @Override
    public boolean isNegativeInfinity() {
        return this.equals(F.CNInfinity);
    }

    @Override
    public final boolean isPlus() {
        return this.isSameHeadSizeGE(F.Plus, 3);
    }

    @Override
    public final boolean isPower() {
        return this.isSameHead(F.Power, 3);
    }

    @Override
    public final boolean isTimes() {
        return this.isSameHeadSizeGE(F.Times, 3);
    }

    @Override
    public final boolean isSin() {
        return this.isSameHead(F.Sin, 2);
    }

    @Override
    public final boolean isCos() {
        return this.isSameHead(F.Cos, 2);
    }

    @Override
    public final boolean isTan() {
        return this.isSameHead(F.Tan, 2);
    }

    @Override
    public final boolean isArcSin() {
        return this.isSameHead(F.ArcSin, 2);
    }

    @Override
    public final boolean isAnd() {
        return this.isSameHeadSizeGE(F.And, 3);
    }

    @Override
    public final boolean isArcCos() {
        return this.isSameHead(F.ArcCos, 2);
    }

    @Override
    public final boolean isArcTan() {
        return this.isSameHead(F.ArcTan, 2);
    }

    @Override
    public final boolean isSinh() {
        return this.isSameHead(F.Sinh, 2);
    }

    @Override
    public final boolean isSlot() {
        return this.isSameHead(F.Slot, 2) && this.arg1().isInteger();
    }

    @Override
    public final boolean isSlotSequence() {
        return this.isSameHead(F.SlotSequence, 2) && this.arg1().isInteger();
    }

    @Override
    public final boolean isCosh() {
        return this.isSameHead(F.Cosh, 2);
    }

    @Override
    public final boolean isTanh() {
        return this.isSameHead(F.Tanh, 2);
    }

    @Override
    public final boolean isArcSinh() {
        return this.isSameHead(F.ArcSinh, 2);
    }

    @Override
    public final boolean isArcCosh() {
        return this.isSameHead(F.ArcCosh, 2);
    }

    @Override
    public final boolean isArcTanh() {
        return this.isSameHead(F.ArcTanh, 2);
    }

    @Override
    public final boolean isLog() {
        return this.isSameHead(F.Log, 2);
    }

    @Override
    public final boolean isOr() {
        return this.isSameHeadSizeGE(F.Or, 3);
    }

    @Override
    public final boolean isOne() {
        return false;
    }

    @Override
    public final boolean isMinusOne() {
        return false;
    }

    @Override
    public final boolean isZero() {
        return false;
    }

    @Override
    public final boolean isTrue() {
        return false;
    }

    @Override
    public final boolean isFalse() {
        return false;
    }

    @Override
    public final boolean isSame(IExpr expression) {
        return this.equals(expression);
    }

    @Override
    public final boolean isSame(IExpr expression, double epsilon) {
        return this.equals(expression);
    }

    @Override
    public int[] isMatrix() {
        if (this.isEvalFlagOn(32)) {
            int[] dim = new int[]{this.size() - 1, ((IAST)this.arg1()).size() - 1};
            return dim;
        }
        if (this.head().equals(F.List)) {
            int[] dim = new int[]{this.size() - 1, 0};
            if (dim[0] > 0) {
                if (this.arg1().isList()) {
                    dim[1] = ((IAST)this.arg1()).size() - 1;
                    for (int i = 2; i < this.size(); ++i) {
                        if (!((IExpr)this.get(i)).isList()) {
                            return null;
                        }
                        if (dim[1] == ((IAST)this.get(i)).size() - 1) continue;
                        return null;
                    }
                } else {
                    return null;
                }
                this.addEvalFlags(32);
                return dim;
            }
        }
        return null;
    }

    @Override
    public final int isVector() {
        if (this.isEvalFlagOn(64)) {
            return this.size() - 1;
        }
        if (this.head().equals(F.List)) {
            int dim = this.size() - 1;
            if (dim > 0) {
                if (this.arg1().isList()) {
                    return -1;
                }
                for (int i = 2; i < this.size(); ++i) {
                    if (!((IExpr)this.get(i)).isList()) continue;
                    return -1;
                }
            }
            this.addEvalFlags(64);
            return dim;
        }
        return -1;
    }

    @Override
    public final boolean isFraction() {
        return false;
    }

    @Override
    public final boolean isPattern() {
        return false;
    }

    @Override
    public boolean isPatternDefault() {
        return false;
    }

    @Override
    public boolean isPatternExpr() {
        return (this.fEvalFlags & 7) != 0;
    }

    @Override
    public final boolean isPatternSequence() {
        return false;
    }

    @Override
    public boolean isPi() {
        return false;
    }

    @Override
    public boolean isPolynomial(ISymbol variable) {
        return this.isPolynomial(F.List((IExpr)variable));
    }

    @Override
    public boolean isPolynomial(IAST variables) {
        if (this.isPlus() || this.isTimes() || this.isPower()) {
            IExpr expr = F.evalExpandAll(this);
            Polynomial poly = new Polynomial(expr, variables, null, false);
            return poly.isPolynomial(expr);
        }
        return false;
    }

    @Override
    public boolean isPolynomialOfMaxDegree(ISymbol variable, long maxDegree) {
        return this.isPolynomialOfMaxDegree(F.List((IExpr)variable), maxDegree);
    }

    public boolean isPolynomialOfMaxDegree(IAST variables, long maxDegree) {
        IExpr expr;
        Polynomial poly;
        if ((this.isPlus() || this.isTimes() || this.isPower()) && (poly = new Polynomial(expr = F.evalExpandAll(this), variables, null, true)).isPolynomial()) {
            return poly.maximumDegree() <= maxDegree;
        }
        return false;
    }

    @Override
    public boolean isPositive() {
        IExpr result;
        if (this.isNumericFunction() && (result = F.evaln(this)).isSignedNumber()) {
            return ((ISignedNumber)result).isPositive();
        }
        return false;
    }

    @Override
    public final boolean isCondition() {
        return this.size() == 3 && this.head().equals(F.Condition);
    }

    @Override
    public final boolean isModule() {
        return this.size() == 3 && this.head().equals(F.Module);
    }

    @Override
    public final boolean isSymbol() {
        return false;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public final boolean isComplex() {
        return false;
    }

    @Override
    public boolean isComplexNumeric() {
        return false;
    }

    @Override
    public final boolean isInteger() {
        return false;
    }

    @Override
    public boolean isNumEqualInteger(IInteger ii) throws ArithmeticException {
        return false;
    }

    @Override
    public final boolean isNumIntValue() {
        return false;
    }

    @Override
    public final boolean isRational() {
        return false;
    }

    @Override
    public final boolean isSignedNumber() {
        return false;
    }

    @Override
    public final boolean isNot() {
        return this.size() == 2 && this.head().equals(F.Not);
    }

    @Override
    public final boolean isNumeric() {
        return false;
    }

    @Override
    public boolean isNumericMode() {
        ISymbol symbol = this.topHead();
        if ((symbol.getAttributes() & 0x400) == 1024) {
            for (int i = 1; i < this.size(); ++i) {
                if (!((IExpr)this.get(i)).isNumericMode()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isNumericFunction() {
        ISymbol symbol = this.topHead();
        if ((symbol.getAttributes() & 0x400) == 1024) {
            for (int i = 1; i < this.size(); ++i) {
                if (((IExpr)this.get(i)).isNumericFunction()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isRealFunction() {
        if (this.isPlus() || this.isTimes()) {
            for (int i = 1; i < this.size(); ++i) {
                if (((IExpr)this.get(i)).isRealFunction()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public final boolean isNumber() {
        return false;
    }

    @Override
    public IAST apply(IExpr head) {
        return this.setAtClone(0, head);
    }

    @Override
    public final IAST apply(IExpr head, int start) {
        return this.apply(head, start, this.size());
    }

    @Override
    public IAST apply(IExpr head, int start, int end) {
        IAST ast = F.ast(head);
        for (int i = start; i < end; ++i) {
            ast.add(this.get(i));
        }
        return ast;
    }

    @Override
    public IExpr apply(List<? extends IExpr> leaves) {
        IAST ast = F.ast(this.head());
        this.addAll(leaves);
        return ast;
    }

    @Override
    public IExpr apply(IExpr ... leaves) {
        IAST ast = F.ast(this.head());
        Collections.addAll(ast, leaves);
        return ast;
    }

    @Override
    public final IAST map(Function<IExpr, IExpr> function) {
        return this.map(this.clone(), function);
    }

    @Override
    public IAST mapAt(IAST replacement, int position) {
        return this.map(Functors.replaceArg(replacement, position));
    }

    @Override
    public IAST mapAt(IAST appendAST, IAST replacement, int position) {
        Function<IExpr, IExpr> function = Functors.replaceArg(replacement, position);
        for (int i = 1; i < this.size(); ++i) {
            IExpr temp = function.apply((IExpr)this.get(i));
            if (temp == null) continue;
            appendAST.add(temp);
        }
        return appendAST;
    }

    @Override
    public IAST map(IExpr head, Function<IExpr, IExpr> function) {
        return this.map(this.setAtClone(0, head), function);
    }

    @Override
    public IAST map(IAST clonedResultAST, Function<IExpr, IExpr> function) {
        for (int i = 1; i < this.size(); ++i) {
            IExpr temp = function.apply((IExpr)this.get(i));
            if (temp == null) continue;
            clonedResultAST.set(i, temp);
        }
        return clonedResultAST;
    }

    @Override
    public IAST map(IAST resultAST, IAST secondAST, BiFunction<IExpr, IExpr, IExpr> function) {
        for (int i = 1; i < this.size(); ++i) {
            resultAST.add(function.apply((IExpr)this.get(i), (IExpr)secondAST.get(i)));
        }
        return resultAST;
    }

    @Override
    public final IExpr replaceAll(IAST astRules) {
        return this.accept(new VisitorReplaceAll(astRules));
    }

    @Override
    public final IExpr replaceAll(Function<IExpr, IExpr> function) {
        return this.accept(new VisitorReplaceAll(function));
    }

    @Override
    public final IExpr replacePart(IAST astRules) {
        return this.accept(new VisitorReplacePart(astRules));
    }

    @Override
    public final IExpr replaceRepeated(IAST astRules) {
        return ExprImpl.replaceRepeated(this, new VisitorReplaceAll(astRules));
    }

    @Override
    public final IExpr replaceRepeated(Function<IExpr, IExpr> function) {
        return ExprImpl.replaceRepeated(this, new VisitorReplaceAll(function));
    }

    @Override
    public final IExpr replaceSlots(IAST astSlots) {
        return this.accept(new VisitorReplaceSlots(astSlots));
    }

    @Override
    public IAST[] filter(Predicate<IExpr> predicate) {
        IAST[] result = new IAST[]{this.copyHead(), this.copyHead()};
        this.filter(result[0], result[1], predicate);
        return result;
    }

    @Override
    public IAST[] filter(Function<IExpr, IExpr> function) {
        IAST[] result = new IAST[]{this.copyHead(), this.copyHead()};
        this.filter(result[0], result[1], function);
        return result;
    }

    @Override
    public final IAST filter(IAST filterAST, Predicate<IExpr> predicate) {
        int size = this.size();
        for (int i = 1; i < size; ++i) {
            if (!predicate.apply((IExpr)this.get(i))) continue;
            filterAST.add(this.get(i));
        }
        return filterAST;
    }

    @Override
    public final IAST filter(IAST filterAST, Predicate<IExpr> predicate, int maxMatches) {
        int count = 0;
        if (count >= maxMatches) {
            return filterAST;
        }
        int size = this.size();
        for (int i = 1; i < size; ++i) {
            if (!predicate.apply((IExpr)this.get(i))) continue;
            if (++count == maxMatches) {
                filterAST.add(this.get(i));
                break;
            }
            filterAST.add(this.get(i));
        }
        return filterAST;
    }

    @Override
    public final IAST filter(IAST filterAST, IAST restAST, Function<IExpr, IExpr> function) {
        int size = this.size();
        for (int i = 1; i < size; ++i) {
            IExpr expr = function.apply((IExpr)this.get(i));
            if (expr != null) {
                filterAST.add(expr);
                continue;
            }
            restAST.add(this.get(i));
        }
        return filterAST;
    }

    @Override
    public final IAST filter(IAST filterAST, IExpr expr) {
        return this.filter(filterAST, Predicates.isTrue(expr));
    }

    @Override
    public final IAST filter(IAST filterAST, IAST restAST, Predicate<IExpr> predicate) {
        int size = this.size();
        for (int i = 1; i < size; ++i) {
            if (predicate.apply((IExpr)this.get(i))) {
                filterAST.add(this.get(i));
                continue;
            }
            restAST.add(this.get(i));
        }
        return filterAST;
    }

    @Override
    public final boolean isAST() {
        return true;
    }

    @Override
    public final boolean isOrderlessAST() {
        return (4 & this.topHead().getAttributes()) == 4;
    }

    @Override
    public final boolean isFlatAST() {
        return (8 & this.topHead().getAttributes()) == 8;
    }

    @Override
    public final boolean isAST(IExpr header) {
        return this.isSameHead(header);
    }

    @Override
    public final boolean isAST(IExpr header, int length) {
        return this.isSameHead(header, length);
    }

    @Override
    public boolean isAST(IExpr header, int length, IExpr ... args) {
        if (this.isSameHead(header, length)) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null || ((IExpr)this.get(i + 1)).equals(args[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public final boolean isASTSizeGE(IExpr header, int length) {
        return this.isSameHeadSizeGE(header, length);
    }

    @Override
    public final boolean isAST(String symbol) {
        if (Config.PARSER_USE_LOWERCASE_SYMBOLS) {
            String name = symbol;
            if (name.length() > 0) {
                name = symbol.toLowerCase();
            }
            return ((IExpr)this.get(0)).toString().equals(name);
        }
        return ((IExpr)this.get(0)).toString().equals(symbol);
    }

    @Override
    public final boolean isAST(String symbol, int length) {
        if (Config.PARSER_USE_LOWERCASE_SYMBOLS) {
            String name = symbol;
            if (name.length() > 0) {
                name = symbol.toLowerCase();
            }
            return this.size() == length && ((IExpr)this.get(0)).toString().equals(name);
        }
        return this.size() == length && ((IExpr)this.get(0)).toString().equals(symbol);
    }

    @Override
    public final boolean isRuleAST() {
        return this.size() == 3 && (this.head().equals(F.Rule) || this.head().equals(F.RuleDelayed));
    }

    @Override
    public boolean isFreeAt(int position, IExpr pattern) {
        return ((IExpr)this.get(position)).isFree(pattern, true);
    }

    @Override
    public boolean isFree(IExpr pattern) {
        return this.isFree(pattern, true);
    }

    @Override
    public final boolean isFree(IExpr pattern, boolean heads) {
        PatternMatcher matcher = new PatternMatcher(pattern);
        return !this.isMember(matcher, heads);
    }

    @Override
    public final boolean isFree(Predicate<IExpr> predicate, boolean heads) {
        return !this.isMember(predicate, heads);
    }

    @Override
    public boolean isMember(IExpr pattern, boolean heads) {
        PatternMatcher matcher = new PatternMatcher(pattern);
        return this.isMember(matcher, heads);
    }

    @Override
    public final boolean isMember(Predicate<IExpr> predicate, boolean heads) {
        if (predicate.apply(this)) {
            return true;
        }
        int start = 1;
        if (heads) {
            start = 0;
        }
        for (int i = start; i < this.size(); ++i) {
            if (!((IExpr)this.get(i)).isMember(predicate, heads)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isFunction() {
        return this.size() >= 2 && this.head().equals(F.Function);
    }

    private int compareToTimes(AST ast) {
        if (ast.isPower()) {
            IExpr lastTimes = (IExpr)this.get(this.size() - 1);
            if (!(lastTimes instanceof IAST)) {
                int cp = lastTimes.compareTo(ast.arg1());
                if (cp != 0) {
                    return cp;
                }
                return F.C1.compareTo(ast.arg2());
            }
            if (lastTimes.isPower()) {
                int cp = ((IAST)lastTimes).arg1().compareTo(ast.arg1());
                if (cp != 0) {
                    return cp;
                }
                cp = ((IAST)lastTimes).arg2().compareTo(ast.arg2());
                if (cp != 0) {
                    return cp;
                }
                return 1;
            }
            int cp = lastTimes.compareTo(ast.arg1());
            if (cp != 0) {
                return cp;
            }
            return F.C1.compareTo(ast.arg2());
        }
        if (ast.isTimes()) {
            int i1;
            int commonArgCounter;
            int i0 = this.size();
            int n = commonArgCounter = i0 > (i1 = ast.size()) ? i1 : i0;
            while (--commonArgCounter > 0) {
                int cp;
                if ((cp = ((IExpr)this.get(--i0)).compareTo((IExpr)ast.get(--i1))) == 0) continue;
                return cp;
            }
            return this.size() - ast.size();
        }
        return this.compareToAST(ast);
    }

    @Override
    public int compareTo(IExpr expr) {
        if (expr instanceof AST) {
            if (this.isTimes()) {
                return this.compareToTimes((AST)expr);
            }
            if (expr.isTimes()) {
                return -1 * ((AST)expr).compareToTimes(this);
            }
            return this.compareToAST((AST)expr);
        }
        if (expr instanceof Symbol) {
            return -1 * ((Symbol)expr).compareTo(this);
        }
        if (this.hierarchy() > expr.hierarchy()) {
            return 1;
        }
        if (this.hierarchy() < expr.hierarchy()) {
            return -1;
        }
        return 0;
    }

    private int compareToAST(AST ast) {
        int cp = this.head().compareTo(ast.head());
        if (cp != 0) {
            return cp;
        }
        int commonArgSize = this.size() > ast.size() ? ast.size() : this.size();
        for (int i = 1; i < commonArgSize; ++i) {
            cp = ((IExpr)this.get(i)).compareTo((IExpr)ast.get(i));
            if (cp == 0) continue;
            return cp;
        }
        return this.size() - ast.size();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof AST) {
            return super.equals(obj);
        }
        return false;
    }

    @Override
    public boolean equalsAt(int position, IExpr expr) {
        return ((IExpr)this.get(position)).equals(expr);
    }

    @Override
    public IExpr evaluate(EvalEngine engine) {
        IExpr temp = engine.evalAST(this);
        if ((this.topHead().getAttributes() & 0x1000) == 4096 && temp != null) {
            System.out.println(this.toString());
            System.out.println(" => " + temp.toString());
        }
        return temp;
    }

    @Override
    public final int patternHashCode() {
        if (this.fPatternMatchingHashValue == 0) {
            int attr;
            this.fPatternMatchingHashValue = this.size() > 1 ? ((attr = this.topHead().getAttributes() & 0xC) != 0 ? (attr == 12 ? 17 * this.head().hashCode() : (attr == 8 ? (this.arg1() instanceof IAST ? 31 * this.head().hashCode() + ((IAST)this.arg1()).head().hashCode() : 37 * this.head().hashCode() + this.arg1().hashCode()) : 17 * this.head().hashCode() + this.size())) : (this.arg1() instanceof IAST ? 31 * this.head().hashCode() + ((IAST)this.arg1()).head().hashCode() + this.size() : 37 * this.head().hashCode() + this.arg1().hashCode() + this.size())) : (this.size() == 1 ? 17 * this.head().hashCode() : 41);
        }
        return this.fPatternMatchingHashValue;
    }

    @Override
    public final boolean isAtom() {
        return false;
    }

    @Override
    public final IAST copyHead() {
        return AST.newInstance((IExpr)this.get(0));
    }

    @Override
    public final IAST copyUntil(int index) {
        return AST.newInstance(this, index);
    }

    @Override
    public final IExpr variables2Slots(Map<IExpr, IExpr> map, List<IExpr> variableList) {
        return AST.variables2Slots(this, new IsUnaryVariableOrPattern<IExpr>(), new UnaryVariable2Slot(map, variableList));
    }

    private static IExpr variables2Slots(IExpr expr, Predicate<IExpr> from, Function<IExpr, ? extends IExpr> to) {
        if (from.apply(expr)) {
            return to.apply(expr);
        }
        if (expr.isAST()) {
            IAST nestedList = (IAST)expr;
            IAST result = null;
            IExpr head = (IExpr)nestedList.get(0);
            IExpr temp = AST.variables2Slots(head, from, to);
            if (temp == null) {
                return null;
            }
            result = nestedList.apply(temp);
            int size = nestedList.size();
            for (int i = 1; i < size; ++i) {
                temp = AST.variables2Slots((IExpr)nestedList.get(i), from, to);
                if (temp == null) {
                    return null;
                }
                result.set(i, temp);
            }
            return result;
        }
        return expr;
    }

    @Override
    public String fullFormString() {
        String sep = ", ";
        IExpr temp = this.head();
        StringBuffer text = new StringBuffer();
        if (temp == null) {
            text.append("<null-head>");
        } else {
            text.append(temp.fullFormString());
        }
        if (Config.PARSER_USE_LOWERCASE_SYMBOLS) {
            text.append('(');
        } else {
            text.append('[');
        }
        for (int i = 1; i < this.size(); ++i) {
            temp = (IExpr)this.get(i);
            if (temp == null) {
                text.append("<null-arg>");
                continue;
            }
            text.append(((IExpr)this.get(i)).fullFormString());
            if (i >= this.size() - 1) continue;
            text.append(", ");
        }
        if (Config.PARSER_USE_LOWERCASE_SYMBOLS) {
            text.append(')');
        } else {
            text.append(']');
        }
        return text.toString();
    }

    @Override
    public String internalFormString(boolean symbolsAsFactoryMethod, int depth) {
        String sep = ",";
        IExpr temp = this.head();
        if (temp.equals(F.Hold) && this.size() == 2) {
            return this.arg1().internalFormString(symbolsAsFactoryMethod, depth);
        }
        if (this.isInfinity()) {
            return "CInfinity";
        }
        if (this.isNegativeInfinity()) {
            return "CNInfinity";
        }
        if (this.isComplexInfinity()) {
            return "CComplexInfinity";
        }
        if (this.equals(F.Slot1)) {
            return "Slot1";
        }
        if (this.equals(F.Slot2)) {
            return "Slot2";
        }
        if (this.isPower()) {
            if (this.equalsAt(2, F.C1D2)) {
                if (this.arg1().isInteger()) {
                    IInteger i = (IInteger)this.arg1();
                    if (i.equals(F.C2)) {
                        return "CSqrt2";
                    }
                    if (i.equals(F.C3)) {
                        return "CSqrt3";
                    }
                    if (i.equals(F.C5)) {
                        return "CSqrt5";
                    }
                    if (i.equals(F.C6)) {
                        return "CSqrt6";
                    }
                    if (i.equals(F.C7)) {
                        return "CSqrt7";
                    }
                    if (i.equals(F.C10)) {
                        return "CSqrt10";
                    }
                }
                return "Sqrt(" + this.arg1().internalFormString(symbolsAsFactoryMethod, depth + 1) + ")";
            }
            if (this.equalsAt(2, F.C2)) {
                return "Sqr(" + this.arg1().internalFormString(symbolsAsFactoryMethod, depth + 1) + ")";
            }
            if (this.equalsAt(2, F.CN1D2) && this.arg1().isInteger()) {
                IInteger i = (IInteger)this.arg1();
                if (i.equals(F.C2)) {
                    return "C1DSqrt2";
                }
                if (i.equals(F.C3)) {
                    return "C1DSqrt3";
                }
                if (i.equals(F.C5)) {
                    return "C1DSqrt5";
                }
                if (i.equals(F.C6)) {
                    return "C1DSqrt6";
                }
                if (i.equals(F.C7)) {
                    return "C1DSqrt7";
                }
                if (i.equals(F.C10)) {
                    return "C1DSqrt10";
                }
            }
        }
        StringBuffer text = new StringBuffer(this.size() * 10);
        if (temp.isSymbol()) {
            ISymbol sym = (ISymbol)temp;
            String name = null;
            if (Config.PARSER_USE_LOWERCASE_SYMBOLS) {
                name = sym.toString();
                if (name.length() > 0) {
                    name = name.toLowerCase();
                }
                name = AST2Expr.PREDEFINED_SYMBOLS_MAP.get(name);
            }
            if (name == null && !Character.isUpperCase(sym.toString().charAt(0))) {
                text.append("$(");
                for (int i = 0; i < this.size(); ++i) {
                    text.append(((IExpr)this.get(i)).internalFormString(symbolsAsFactoryMethod, depth + 1));
                    if (i >= this.size() - 1) continue;
                    text.append(",");
                }
                text.append(')');
                return text.toString();
            }
        } else if (temp.isPattern() || temp.isAST()) {
            text.append("$(");
            for (int i = 0; i < this.size(); ++i) {
                text.append(((IExpr)this.get(i)).internalFormString(symbolsAsFactoryMethod, depth + 1));
                if (i >= this.size() - 1) continue;
                text.append(",");
            }
            text.append(')');
            return text.toString();
        }
        text.append(temp.internalFormString(false, 0));
        text.append('(');
        if (this.isTimes() || this.isPlus()) {
            if (depth == 0 && this.isList()) {
                text.append('\n');
            }
            AST.internalFormOrderless(this, text, ",", symbolsAsFactoryMethod, depth);
            if (depth == 0 && this.isList()) {
                text.append('\n');
            }
        } else {
            if (depth == 0 && this.isList()) {
                text.append('\n');
            }
            for (int i = 1; i < this.size(); ++i) {
                text.append(((IExpr)this.get(i)).internalFormString(symbolsAsFactoryMethod, depth + 1));
                if (i >= this.size() - 1) continue;
                text.append(",");
                if (depth != 0 || !this.isList()) continue;
                text.append('\n');
            }
            if (depth == 0 && this.isList()) {
                text.append('\n');
            }
        }
        text.append(')');
        return text.toString();
    }

    private static void internalFormOrderless(IAST ast, StringBuffer text, String sep, boolean symbolsAsFactoryMethod, int depth) {
        for (int i = 1; i < ast.size(); ++i) {
            if (ast.get(i) instanceof IAST && ast.head().equals(((IExpr)ast.get(i)).head())) {
                AST.internalFormOrderless((IAST)ast.get(i), text, sep, symbolsAsFactoryMethod, depth);
            } else {
                text.append(((IExpr)ast.get(i)).internalFormString(symbolsAsFactoryMethod, depth + 1));
            }
            if (i >= ast.size() - 1) continue;
            text.append(sep);
        }
    }

    @Override
    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            OutputFormFactory.get(EvalEngine.get().isRelaxedSyntax()).convert(sb, this);
            return sb.toString();
        }
        catch (Exception e1) {
            try {
                StringBuffer buf = new StringBuffer();
                if (this.size() > 0 && this.isList()) {
                    buf.append('{');
                    for (int i = 1; i < this.size(); ++i) {
                        buf.append(this.get(i) == this ? "(this AST)" : String.valueOf(this.get(i)));
                        if (i >= this.size() - 1) continue;
                        buf.append(", ");
                    }
                    buf.append('}');
                    return buf.toString();
                }
                if (this.isAST(F.Slot, 2) && this.arg1().isSignedNumber()) {
                    try {
                        int slot = ((ISignedNumber)this.arg1()).toInt();
                        if (slot <= 0) {
                            return this.toFullFormString();
                        }
                        if (slot == 1) {
                            return "#";
                        }
                        return "#" + slot;
                    }
                    catch (ArithmeticException arithmeticException) {
                        return this.toFullFormString();
                    }
                }
                return this.toFullFormString();
            }
            catch (NullPointerException e) {
                System.out.println(this.fullFormString());
                throw e;
            }
        }
    }

    private String toFullFormString() {
        String sep = ", ";
        IExpr temp = null;
        if (this.size() > 0) {
            temp = this.head();
        }
        StringBuffer text = temp == null ? new StringBuffer("<null-tag>") : new StringBuffer(temp.toString());
        text.append('[');
        for (int i = 1; i < this.size(); ++i) {
            IExpr o = (IExpr)this.get(i);
            text = text.append(o == this ? "(this AST)" : o.toString());
            if (i >= this.size() - 1) continue;
            text.append(", ");
        }
        text.append(']');
        return text.toString();
    }

    @Override
    public final boolean addAll(List<? extends IExpr> ast) {
        return this.addAll(ast, 1, ast.size());
    }

    @Override
    public boolean addAll(List<? extends IExpr> ast, int startPosition, int endPosition) {
        if (ast.size() > 0 && startPosition < endPosition) {
            this.ensureCapacity(this.size() + (endPosition - startPosition));
            for (int i = startPosition; i < endPosition; ++i) {
                this.add(ast.get(i));
            }
            return true;
        }
        return false;
    }

    @Override
    public IAST addAtClone(int position, IExpr expr) {
        IAST ast = this.clone();
        ast.add(position, expr);
        return ast;
    }

    @Override
    public final ASTRange args() {
        return new ASTRange(this, 1);
    }

    @Override
    public final ASTRange range() {
        return new ASTRange(this, 0, this.size());
    }

    @Override
    public final ASTRange range(int start) {
        return new ASTRange(this, start, this.size());
    }

    @Override
    public final ASTRange range(int start, int end) {
        return new ASTRange(this, start, end);
    }

    public static AST newInstance(int intialCapacity, IExpr head) {
        AST ast = new AST(intialCapacity + 1, false);
        ast.add(head);
        return ast;
    }

    public static AST newInstance(IExpr head) {
        AST ast = new AST(5, false);
        ast.add(head);
        return ast;
    }

    private static AST newInstance(IAST ast, int endPosition) {
        AST result = new AST(5, false);
        result.addAll(ast, 0, endPosition);
        return result;
    }

    public static AST newInstance(ISymbol symbol, int ... arr) {
        IExpr[] eArr = new IExpr[arr.length + 1];
        eArr[0] = symbol;
        for (int i = 1; i <= arr.length; ++i) {
            eArr[i] = IntegerSym.valueOf(arr[i - 1]);
        }
        return new AST(eArr);
    }

    public static AST newInstance(ISymbol symbol, double ... arr) {
        IExpr[] eArr = new IExpr[arr.length + 1];
        eArr[0] = symbol;
        for (int i = 1; i <= arr.length; ++i) {
            eArr[i] = Num.valueOf(arr[i - 1]);
        }
        return new AST(eArr);
    }

    public static AST newInstance(ISymbol symbol, Complex ... arr) {
        IExpr[] eArr = new IExpr[arr.length + 1];
        eArr[0] = symbol;
        for (int i = 1; i <= arr.length; ++i) {
            eArr[i] = ComplexNum.valueOf(arr[i - 1].getReal(), arr[i - 1].getImaginary());
        }
        return new AST(eArr);
    }

    public static AST newInstance(ISymbol symbol, double[][] matrix) {
        IExpr[] eArr = new IExpr[matrix.length + 1];
        eArr[0] = symbol;
        for (int i = 1; i <= matrix.length; ++i) {
            eArr[i] = AST.newInstance(F.List, matrix[i - 1]);
        }
        return new AST(eArr);
    }

    @Override
    public final <T> T accept(IVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public final boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public final int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }

    @Override
    public long accept(IVisitorLong visitor) {
        return visitor.visit(this);
    }

    @Override
    public final IExpr negative() {
        return this.opposite();
    }

    @Override
    public IExpr minus(IExpr that) {
        return F.Plus((IExpr)this, (IExpr)F.Times((IExpr)F.CN1, that));
    }

    @Override
    public final IExpr multiply(IExpr that) {
        if (that.isZero()) {
            return F.C0;
        }
        return F.eval(F.Times((IExpr)this, that));
    }

    @Override
    public final IExpr power(int n) {
        return F.Power((IExpr)this, F.integer(n));
    }

    @Override
    public final IExpr power(IExpr that) {
        return F.Power((IExpr)this, that);
    }

    @Override
    public IExpr mod(IExpr that) {
        return F.Mod(this, that);
    }

    @Override
    public IExpr and(IExpr that) {
        return F.And(this, that);
    }

    @Override
    public IExpr or(IExpr that) {
        return F.Or(this, that);
    }

    @Override
    public final IExpr getAt(int index) {
        return (IExpr)this.get(index);
    }

    @Override
    public Object asType(Class clazz) {
        if (clazz.equals(Boolean.class)) {
            IExpr temp = F.eval(this);
            if (temp.equals(F.True)) {
                return Boolean.TRUE;
            }
            if (temp.equals(F.False)) {
                return Boolean.FALSE;
            }
        } else if (clazz.equals(Integer.class)) {
            IExpr temp = F.eval(this);
            if (temp.isSignedNumber()) {
                try {
                    return ((ISignedNumber)((Object)this)).toInt();
                }
                catch (ArithmeticException arithmeticException) {}
            }
        } else if (clazz.equals(BigInteger.class)) {
            IExpr temp = F.eval(this);
            if (temp instanceof IntegerSym) {
                return new BigInteger(((IntegerSym)temp).toByteArray());
            }
        } else if (clazz.equals(String.class)) {
            return this.toString();
        }
        throw new UnsupportedOperationException("AST.asType() - cast not supported.");
    }

    @Override
    public final IInteger getInt(int index) {
        try {
            return (IInteger)this.get(index);
        }
        catch (ClassCastException classCastException) {
            throw new WrongArgumentType(this, (IExpr)this.get(index), index);
        }
    }

    @Override
    public final INumber getNumber(int index) {
        try {
            return (INumber)this.get(index);
        }
        catch (ClassCastException classCastException) {
            throw new WrongArgumentType(this, (IExpr)this.get(index), index);
        }
    }

    @Override
    public final IAST getAST(int index) {
        try {
            return (IAST)this.get(index);
        }
        catch (ClassCastException classCastException) {
            throw new WrongArgumentType(this, (IExpr)this.get(index), index);
        }
    }

    @Override
    public IExpr getPart(int ... positions) {
        IExpr expr = this;
        int size = positions.length;
        for (int i = 0; i < size && expr.isAST(); ++i) {
            expr = (IExpr)((IAST)expr).get(positions[i]);
            if (i != size - 1) continue;
            return expr;
        }
        return null;
    }

    @Override
    public IExpr getPart(List<Integer> positions) {
        IExpr expr = this;
        int size = positions.size();
        for (int i = 0; i < size && expr.isAST(); ++i) {
            expr = (IExpr)((IAST)expr).get(positions.get(i));
            if (i != size - 1) continue;
            return expr;
        }
        return null;
    }

    @Override
    public final IAST getList(int index) {
        IExpr temp = (IExpr)this.get(index);
        if (temp.isList()) {
            return (IAST)temp;
        }
        throw new WrongArgumentType(this, temp, index);
    }

    @Override
    public long leafCount() {
        return this.accept(new LeafCount.LeafCountVisitor(0));
    }

    @Override
    public List<IExpr> leaves() {
        int sz = this.size();
        if (sz < 2) {
            return Collections.EMPTY_LIST;
        }
        return this.subList(1, sz);
    }

    public IExpr[] egcd(IExpr b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IExpr gcd(IExpr that) {
        if (this.equals(that)) {
            return that;
        }
        return F.C1;
    }

    @Override
    public IExpr abs() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean isZERO() {
        return this.isZero();
    }

    @Override
    @Deprecated
    public int signum() {
        IExpr temp;
        if (this.isTimes() && (temp = this.arg1()).isSignedNumber() && ((ISignedNumber)temp).isNegative()) {
            return -1;
        }
        return 1;
    }

    @Override
    public IExpr subtract(IExpr that) {
        return F.eval(F.Plus((IExpr)this, (IExpr)F.Times((IExpr)F.CN1, that)));
    }

    @Override
    public IExpr sum(IExpr that) {
        if (that.isZero()) {
            return this;
        }
        return F.eval(F.Plus((IExpr)this, that));
    }

    @Override
    public ElemFactory<IExpr> factory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final String toScript() {
        return this.toString();
    }

    @Override
    public final String toScriptFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IExpr divide(IExpr that) {
        if (that.isNumber()) {
            return F.eval(F.Times((IExpr)this, that.inverse()));
        }
        return F.eval(F.Times((IExpr)this, (IExpr)F.Power(that, F.CN1)));
    }

    @Override
    public final boolean isONE() {
        return this.isOne();
    }

    @Override
    public final boolean isUnit() {
        if (this.isZero()) {
            return false;
        }
        if (this.isOne()) {
            return true;
        }
        if (this.isNumber()) {
            return true;
        }
        IExpr temp = F.eval(F.Times((IExpr)this, (IExpr)F.Power((IExpr)this, F.CN1)));
        return temp.isOne();
    }

    @Override
    public final boolean isValue() {
        ISymbol symbol;
        EvalEngine engine = EvalEngine.get();
        IExpr result = engine.evalAttributes(symbol = this.topHead(), this);
        if (result != null) {
            if (result.isAST(symbol)) {
                return engine.evalRules(symbol, (IAST)result) != null;
            }
            return false;
        }
        return engine.evalRules(symbol, this) != null;
    }

    @Override
    public IExpr remainder(IExpr that) {
        if (this.equals(that)) {
            return F.C0;
        }
        return this;
    }

    @Override
    public IAST removeAtClone(int position) {
        IAST ast = this.clone();
        ast.remove(position);
        return ast;
    }

    @Override
    public final IExpr negate() {
        if (this.isTimes()) {
            IExpr arg1 = this.arg1();
            if (arg1.isNumber()) {
                return this.setAtClone(1, (IExpr)((INumber)arg1).negate());
            }
            IAST timesAST = this.clone();
            timesAST.add(1, F.CN1);
            return timesAST;
        }
        if (this.isNegativeInfinity()) {
            return F.CInfinity;
        }
        if (this.isInfinity()) {
            return F.CNInfinity;
        }
        return F.eval(F.Times((IExpr)F.CN1, (IExpr)this));
    }

    @Override
    public final IExpr head() {
        return (IExpr)this.get(0);
    }

    @Override
    public Iterator<IExpr> iterator() {
        ASTIterator i = new ASTIterator();
        i._table = this;
        i._start = 1;
        i._end = this.size();
        i._nextIndex = 1;
        i._currentIndex = 0;
        return i;
    }

    @Override
    public Iterator<IExpr> iterator0() {
        return super.iterator();
    }

    @Override
    public final IExpr arg1() {
        return (IExpr)this.get(1);
    }

    @Override
    public final IExpr arg2() {
        return (IExpr)this.get(2);
    }

    @Override
    public final IExpr arg3() {
        return (IExpr)this.get(3);
    }

    @Override
    public final IExpr arg4() {
        return (IExpr)this.get(4);
    }

    @Override
    public final IExpr arg5() {
        return (IExpr)this.get(5);
    }

    @Override
    public final IExpr last() {
        return (IExpr)this.get(this.size() - 1);
    }

    @Override
    public IAST appendClone(IExpr expr) {
        IAST ast = this.clone();
        ast.add(expr);
        return ast;
    }

    @Override
    public IAST prependClone(IExpr expr) {
        return this.addAtClone(1, expr);
    }

    protected static final class ASTIterator
    implements ListIterator<IExpr> {
        private HMArrayList<IExpr> _table;
        private int _currentIndex;
        private int _start;
        private int _end;
        private int _nextIndex;

        protected ASTIterator() {
        }

        @Override
        public boolean hasNext() {
            return this._nextIndex != this._end;
        }

        @Override
        public IExpr next() {
            if (this._nextIndex == this._end) {
                throw new NoSuchElementException();
            }
            this._currentIndex = this._nextIndex++;
            return this._table.get(this._currentIndex);
        }

        @Override
        public int nextIndex() {
            return this._nextIndex;
        }

        @Override
        public boolean hasPrevious() {
            return this._nextIndex != this._start;
        }

        @Override
        public IExpr previous() {
            if (this._nextIndex == this._start) {
                throw new NoSuchElementException();
            }
            this._currentIndex = --this._nextIndex;
            return this._table.get(this._nextIndex);
        }

        @Override
        public int previousIndex() {
            return this._nextIndex - 1;
        }

        @Override
        public void add(IExpr o) {
            this._table.add(this._nextIndex++, o);
            ++this._end;
            this._currentIndex = -1;
        }

        @Override
        public void set(IExpr o) {
            if (this._currentIndex < 0) {
                throw new IllegalStateException();
            }
            this._table.set(this._currentIndex, o);
        }

        @Override
        public void remove() {
            if (this._currentIndex >= 0) {
                this._table.remove(this._currentIndex);
                --this._end;
                if (this._currentIndex < this._nextIndex) {
                    --this._nextIndex;
                }
            } else {
                throw new IllegalStateException();
            }
            this._currentIndex = -1;
        }
    }
}

