/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.util;

import java.util.List;
import org.matheclipse.core.generic.interfaces.IArrayFunction;
import org.matheclipse.core.generic.interfaces.IIterator;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class TableGenerator {
    final List<? extends IIterator<IExpr>> fIterList;
    final IExpr fDefaultValue;
    final IAST fPrototypeList;
    final IArrayFunction fFunction;
    int fIndex;
    private IExpr[] fCurrentIndex;

    public TableGenerator(List<? extends IIterator<IExpr>> iterList, IAST prototypeList, IArrayFunction function) {
        this(iterList, prototypeList, function, null);
    }

    public TableGenerator(List<? extends IIterator<IExpr>> iterList, IAST prototypeList, IArrayFunction function, IExpr defaultValue) {
        this.fIterList = iterList;
        this.fPrototypeList = prototypeList;
        this.fFunction = function;
        this.fIndex = 0;
        this.fCurrentIndex = new IExpr[iterList.size()];
        this.fDefaultValue = defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IExpr table() {
        if (this.fIndex < this.fIterList.size()) {
            IIterator<IExpr> iter = this.fIterList.get(this.fIndex);
            if (iter.setUp()) {
                try {
                    int index = this.fIndex++;
                    IAST result = this.fPrototypeList.clone();
                    while (iter.hasNext()) {
                        this.fCurrentIndex[index] = (IExpr)iter.next();
                        IExpr temp = this.table();
                        if (temp == null) {
                            result.add(this.fDefaultValue);
                            continue;
                        }
                        result.add(temp);
                    }
                    IAST iAST = result;
                    return iAST;
                }
                finally {
                    --this.fIndex;
                    iter.tearDown();
                }
            }
            return this.fDefaultValue;
        }
        return this.fFunction.evaluate(this.fCurrentIndex);
    }
}

