/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.util;

import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class Options {
    private IAST fDefaultOptionsList;
    private IAST fCurrentOptionsList;

    public Options(ISymbol symbol, IAST currentOptionsList, int startIndex) {
        IExpr temp = F.eval(F.Options(symbol));
        this.fDefaultOptionsList = temp != null && temp instanceof IAST && temp.isList() ? (IAST)temp : null;
        this.fCurrentOptionsList = null;
        if (currentOptionsList != null && startIndex < currentOptionsList.size()) {
            this.fCurrentOptionsList = F.List();
            for (int i = startIndex; i < currentOptionsList.size(); ++i) {
                this.fCurrentOptionsList.add(1, currentOptionsList.get(i));
            }
        }
    }

    public Options(ISymbol symbol, IExpr optionExpr) {
        IExpr temp = F.eval(F.Options(symbol));
        this.fDefaultOptionsList = temp != null && temp instanceof IAST && temp.isList() ? (IAST)temp : null;
        this.fCurrentOptionsList = F.List();
        this.fCurrentOptionsList.add(optionExpr);
    }

    public boolean isOption(String optionString) {
        IExpr temp = this.getOption(optionString);
        if (temp != null) {
            return temp.equals(F.True);
        }
        return false;
    }

    public IExpr getOption(String optionString) {
        int i;
        IAST rule = null;
        if (this.fCurrentOptionsList != null) {
            try {
                for (i = 1; i < this.fCurrentOptionsList.size(); ++i) {
                    if (!((IExpr)this.fCurrentOptionsList.get(i)).isAST() || !(rule = (IAST)this.fCurrentOptionsList.get(i)).isRuleAST() || !rule.arg1().toString().equalsIgnoreCase(optionString)) continue;
                    return (IExpr)rule.get(2);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.fDefaultOptionsList != null) {
            try {
                for (i = 1; i < this.fDefaultOptionsList.size(); ++i) {
                    if (!((IExpr)this.fDefaultOptionsList.get(i)).isAST() || !(rule = (IAST)this.fDefaultOptionsList.get(i)).isRuleAST() || !rule.arg1().toString().equalsIgnoreCase(optionString)) continue;
                    return (IExpr)rule.get(2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public IAST replaceAll(IAST options) {
        IAST result = options.clone();
        if (this.fCurrentOptionsList != null) {
            result = (IAST)F.eval(F.ReplaceAll(result, this.fCurrentOptionsList));
        }
        if (this.fDefaultOptionsList != null) {
            result = (IAST)F.eval(F.ReplaceAll(result, this.fDefaultOptionsList));
        }
        return result;
    }
}

